/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPJavaProject {
    private final IJavaProject fJavaProject;
    private final List<CPListElement> fCPListElements;
    private IPath fDefaultOutputLocation;

    public static CPJavaProject createFromExisting(IJavaProject javaProject) throws CoreException {
        List<CPListElement> classpathEntries = ClasspathModifier.getExistingEntries(javaProject);
        return new CPJavaProject(javaProject, classpathEntries, javaProject.getOutputLocation());
    }

    public CPJavaProject(IJavaProject javaProject, List<CPListElement> cpListElements, IPath defaultOutputLocation) {
        this.fJavaProject = javaProject;
        this.fCPListElements = cpListElements;
        this.fDefaultOutputLocation = defaultOutputLocation;
    }

    public CPJavaProject createWorkingCopy() {
        ArrayList<CPListElement> newList = new ArrayList<CPListElement>(this.fCPListElements.size());
        for (CPListElement element : this.fCPListElements) {
            newList.add(element.copy());
        }
        return new CPJavaProject(this.fJavaProject, newList, this.fDefaultOutputLocation);
    }

    public CPListElement get(int index) {
        return this.fCPListElements.get(index);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] result = new IClasspathEntry[this.fCPListElements.size()];
        int i = 0;
        for (CPListElement element : this.fCPListElements) {
            result[i] = element.getClasspathEntry();
            ++i;
        }
        return result;
    }

    public CPListElement getCPElement(CPListElement element) {
        return ClasspathModifier.getClasspathEntry(this.fCPListElements, element);
    }

    public List<CPListElement> getCPListElements() {
        return this.fCPListElements;
    }

    public IPath getDefaultOutputLocation() {
        return this.fDefaultOutputLocation;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public int indexOf(CPListElement element) {
        return this.fCPListElements.indexOf(element);
    }

    public void setDefaultOutputLocation(IPath path) {
        this.fDefaultOutputLocation = path;
    }
}

