/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentAssistProvider;
import org.eclipse.egit.ui.internal.components.RemoteSelectionCombo;
import org.eclipse.egit.ui.internal.components.UpstreamConfigComponent;
import org.eclipse.egit.ui.internal.push.AddRemotePage;
import org.eclipse.egit.ui.internal.push.AddRemoteWizard;
import org.eclipse.egit.ui.internal.push.PushWizard;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PushBranchPage
extends WizardPage {
    private static final int MAX_SHORTCOMMIT_MESSAGE_LENGTH = 65;
    private final Repository repository;
    private final ObjectId commitToPush;
    private final Ref ref;
    private boolean showNewRemoteButton = true;
    private RemoteConfig remoteConfig;
    private List<RemoteConfig> remoteConfigs;
    private RemoteSelectionCombo remoteSelectionCombo;
    private Text remoteBranchNameText;
    private RefContentAssistProvider assist;
    private CreateLocalBranchOperation.UpstreamConfig upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.NONE;
    private UpstreamConfigComponent upstreamConfigComponent;
    private boolean forceUpdateSelected = false;
    private AddRemotePage addRemotePage;
    private Set<Resource> disposables = new HashSet<Resource>();

    public PushBranchPage(Repository repository, ObjectId commitToPush, Ref ref) {
        super(UIText.PushBranchPage_PageName);
        this.setTitle(UIText.PushBranchPage_PageTitle);
        this.setMessage(UIText.PushBranchPage_PageMessage);
        this.repository = repository;
        this.commitToPush = commitToPush;
        this.ref = ref;
    }

    public void setShowNewRemoteButton(boolean showNewRemoteButton) {
        this.showNewRemoteButton = showNewRemoteButton;
    }

    AddRemotePage getAddRemotePage() {
        return this.addRemotePage;
    }

    RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    String getFullRemoteReference() {
        if (!this.remoteBranchNameText.getText().startsWith("refs/")) {
            return "refs/heads/" + this.remoteBranchNameText.getText();
        }
        return this.remoteBranchNameText.getText();
    }

    boolean isConfigureUpstreamSelected() {
        return this.upstreamConfig != CreateLocalBranchOperation.UpstreamConfig.NONE;
    }

    boolean isRebaseSelected() {
        return this.upstreamConfig == CreateLocalBranchOperation.UpstreamConfig.REBASE;
    }

    boolean isForceUpdateSelected() {
        return this.forceUpdateSelected;
    }

    public void createControl(Composite parent) {
        try {
            this.remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
            Collections.sort(this.remoteConfigs, new Comparator<RemoteConfig>(){

                @Override
                public int compare(RemoteConfig first, RemoteConfig second) {
                    return String.CASE_INSENSITIVE_ORDER.compare(first.getName(), second.getName());
                }
            });
        }
        catch (URISyntaxException e) {
            this.remoteConfigs = new ArrayList<RemoteConfig>();
            this.handleError(e);
        }
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite inputPanel = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inputPanel);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(inputPanel);
        Label sourceLabel = new Label(inputPanel, 0);
        sourceLabel.setText(UIText.PushBranchPage_Source);
        Composite sourceComposite = new Composite(inputPanel, 0);
        sourceComposite.setLayoutData((Object)GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).create());
        RowLayout rowLayout = RowLayoutFactory.fillDefaults().create();
        rowLayout.center = true;
        sourceComposite.setLayout((Layout)rowLayout);
        if (this.ref != null) {
            Image branchIcon = UIIcons.BRANCH.createImage();
            this.disposables.add((Resource)branchIcon);
            Label branchIconLabel = new Label(sourceComposite, 0);
            branchIconLabel.setLayoutData((Object)new RowData(branchIcon.getBounds().width, branchIcon.getBounds().height));
            branchIconLabel.setImage(branchIcon);
            Label localBranchLabel = new Label(sourceComposite, 0);
            localBranchLabel.setText(Repository.shortenRefName((String)this.ref.getName()));
            Label spacer = new Label(sourceComposite, 0);
            spacer.setLayoutData((Object)new RowData(3, -1));
        }
        Image commitIcon = UIIcons.CHANGESET.createImage();
        this.disposables.add((Resource)commitIcon);
        Label commitIconLabel = new Label(sourceComposite, 0);
        commitIconLabel.setImage(commitIcon);
        commitIconLabel.setLayoutData((Object)new RowData(commitIcon.getBounds().width, commitIcon.getBounds().height));
        Label commit = new Label(sourceComposite, 0);
        RevWalk revWalk = new RevWalk(this.repository);
        StringBuilder commitBuilder = new StringBuilder(this.commitToPush.abbreviate(7).name());
        StringBuilder commitTooltipBuilder = new StringBuilder(this.commitToPush.getName());
        try {
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)this.commitToPush);
            commitBuilder.append("  ");
            commitBuilder.append(Utils.shortenText((String)revCommit.getShortMessage(), (int)65));
            commitTooltipBuilder.append("\n\n");
            commitTooltipBuilder.append(revCommit.getFullMessage());
        }
        catch (IOException ex) {
            commitBuilder.append(UIText.PushBranchPage_CannotAccessCommitDescription);
            commitTooltipBuilder.append(ex.getMessage());
            Activator.handleError(ex.getLocalizedMessage(), ex, false);
        }
        commit.setText(commitBuilder.toString());
        commit.setToolTipText(commitTooltipBuilder.toString());
        Label destinationLabel = new Label(inputPanel, 0);
        destinationLabel.setText(UIText.PushBranchPage_Destination);
        GridDataFactory.fillDefaults().applyTo((Control)destinationLabel);
        Composite remoteGroup = new Composite(inputPanel, 0);
        remoteGroup.setLayoutData((Object)GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).create());
        remoteGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        Label remoteLabel = new Label(remoteGroup, 0);
        remoteLabel.setText(UIText.PushBranchPage_RemoteLabel);
        int remoteSelectionSpan = this.showNewRemoteButton ? 1 : 2;
        this.remoteSelectionCombo = new RemoteSelectionCombo(remoteGroup, 0, RemoteSelectionCombo.SelectionType.PUSH);
        GridDataFactory.fillDefaults().grab(true, false).span(remoteSelectionSpan, 1).applyTo((Control)this.remoteSelectionCombo);
        this.setRemoteConfigs();
        this.remoteSelectionCombo.addRemoteSelectionListener(new RemoteSelectionCombo.IRemoteSelectionListener(){

            @Override
            public void remoteSelected(RemoteConfig rc) {
                PushBranchPage.this.remoteConfig = rc;
                PushBranchPage.this.setRefAssist(rc);
                PushBranchPage.this.checkPage();
            }
        });
        if (this.showNewRemoteButton) {
            Button newRemoteButton = new Button(remoteGroup, 8);
            newRemoteButton.setText(UIText.PushBranchPage_NewRemoteButton);
            GridDataFactory.fillDefaults().applyTo((Control)newRemoteButton);
            newRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PushBranchPage.this.showNewRemoteDialog();
                }
            });
        }
        Label branchNameLabel = new Label(remoteGroup, 0);
        branchNameLabel.setText(UIText.PushBranchPage_RemoteBranchNameLabel);
        this.remoteBranchNameText = new Text(remoteGroup, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.remoteBranchNameText);
        this.remoteBranchNameText.setText(this.getSuggestedBranchName());
        UIUtils.addRefContentProposalToText(this.remoteBranchNameText, this.repository, new UIUtils.IRefListProvider(){

            @Override
            public List<Ref> getRefList() {
                if (PushBranchPage.this.assist != null) {
                    return PushBranchPage.this.assist.getRefsForContentAssist(false, true);
                }
                return Collections.emptyList();
            }
        });
        if (this.ref != null) {
            this.upstreamConfigComponent = new UpstreamConfigComponent(inputPanel, 0);
            this.upstreamConfigComponent.getContainer().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).indent(-1, 20).create());
            this.upstreamConfigComponent.addUpstreamConfigSelectionListener(new UpstreamConfigComponent.UpstreamConfigSelectionListener(){

                @Override
                public void upstreamConfigSelected(CreateLocalBranchOperation.UpstreamConfig newUpstreamConfig) {
                    PushBranchPage.this.upstreamConfig = newUpstreamConfig;
                    PushBranchPage.this.checkPage();
                }
            });
            this.setDefaultUpstreamConfig();
        }
        final Button forceUpdateButton = new Button(inputPanel, 32);
        forceUpdateButton.setText(UIText.PushBranchPage_ForceUpdateButton);
        forceUpdateButton.setSelection(false);
        forceUpdateButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        forceUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PushBranchPage.this.forceUpdateSelected = forceUpdateButton.getSelection();
            }
        });
        Link advancedDialogLink = new Link(main, 0);
        advancedDialogLink.setText(UIText.PushBranchPage_advancedWizardLink);
        advancedDialogLink.setToolTipText(UIText.PushBranchPage_advancedWizardLinkTooltip);
        advancedDialogLink.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, true));
        advancedDialogLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell parentShell = PushBranchPage.this.getShell().getParent().getShell();
                PushWizard advancedWizard = null;
                try {
                    advancedWizard = new PushWizard(PushBranchPage.this.repository);
                    PushBranchPage.this.getShell().close();
                    new WizardDialog(parentShell, (IWizard)advancedWizard).open();
                }
                catch (URISyntaxException ex) {
                    Activator.logError(ex.getMessage(), ex);
                }
            }
        });
        this.setControl((Control)main);
        this.checkPage();
        this.remoteBranchNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PushBranchPage.this.checkPage();
            }
        });
    }

    private void setRemoteConfigs() {
        this.remoteSelectionCombo.setItems(this.remoteConfigs);
        if (this.ref != null) {
            String branchName = Repository.shortenRefName((String)this.ref.getName());
            BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
            String remoteName = branchConfig.getRemote();
            if (remoteName != null) {
                for (RemoteConfig rc : this.remoteConfigs) {
                    if (!remoteName.equals(rc.getName())) continue;
                    this.remoteSelectionCombo.setSelectedRemote(rc);
                }
            }
        }
        this.remoteConfig = this.remoteSelectionCombo.getSelectedRemote();
        this.setRefAssist(this.remoteConfig);
    }

    private void setDefaultUpstreamConfig() {
        if (this.ref != null) {
            boolean rebase;
            boolean alreadyConfigured;
            String branchName = Repository.shortenRefName((String)this.ref.getName());
            BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
            boolean bl = alreadyConfigured = branchConfig.getMerge() != null;
            CreateLocalBranchOperation.UpstreamConfig config = alreadyConfigured ? ((rebase = branchConfig.isRebase()) ? CreateLocalBranchOperation.UpstreamConfig.REBASE : CreateLocalBranchOperation.UpstreamConfig.MERGE) : CreateLocalBranchOperation.UpstreamConfig.getDefault((Repository)this.repository, (String)("refs/remotes/origin/" + branchName));
            this.upstreamConfig = config;
            this.upstreamConfigComponent.setUpstreamConfig(this.upstreamConfig);
        }
    }

    private void showNewRemoteDialog() {
        AddRemoteWizard wizard = new AddRemoteWizard(this.repository);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            URIish uri = wizard.getUri();
            String remoteName = wizard.getRemoteName();
            this.addRemotePage = wizard.getAddRemotePage();
            this.setSelectedRemote(remoteName, uri);
        }
    }

    private void checkPage() {
        block9: {
            String branchName;
            block8: {
                block7: {
                    try {
                        if (this.remoteConfig != null) break block7;
                        this.setErrorMessage(UIText.PushBranchPage_ChooseRemoteError);
                    }
                    catch (Throwable throwable) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw throwable;
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                branchName = this.remoteBranchNameText.getText();
                if (branchName.length() != 0) break block8;
                this.setErrorMessage(UIText.PushBranchPage_ChooseBranchNameError);
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (Repository.isValidRefName((String)("refs/heads/" + branchName))) break block9;
            this.setErrorMessage(UIText.PushBranchPage_InvalidBranchNameError);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (this.isConfigureUpstreamSelected() && this.hasDifferentUpstreamConfiguration()) {
            this.setMessage(UIText.PushBranchPage_UpstreamConfigOverwriteWarning, 2);
        } else {
            this.setMessage(UIText.PushBranchPage_PageMessage);
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    void setSelectedRemote(String remoteName, URIish urIish) {
        try {
            RemoteConfig config = new RemoteConfig((Config)this.repository.getConfig(), remoteName);
            config.addURI(urIish);
            this.remoteSelectionCombo.setItems(Arrays.asList(config));
            this.remoteConfig = config;
            this.remoteSelectionCombo.setEnabled(false);
            this.setRefAssist(this.remoteConfig);
            this.checkPage();
        }
        catch (URISyntaxException e) {
            this.handleError(e);
        }
    }

    private String getSuggestedBranchName() {
        if (this.ref != null) {
            StoredConfig config = this.repository.getConfig();
            String branchName = Repository.shortenRefName((String)this.ref.getName());
            BranchConfig branchConfig = new BranchConfig((Config)config, branchName);
            String merge = branchConfig.getMerge();
            if (!branchConfig.isRemoteLocal() && merge != null && merge.startsWith("refs/heads/")) {
                return Repository.shortenRefName((String)merge);
            }
            return branchName;
        }
        return "";
    }

    private void setRefAssist(RemoteConfig config) {
        if (config != null && config.getURIs().size() > 0) {
            this.assist = new RefContentAssistProvider(this.repository, (URIish)config.getURIs().get(0), this.getShell());
        }
    }

    private boolean hasDifferentUpstreamConfiguration() {
        String branchName = Repository.shortenRefName((String)this.ref.getName());
        BranchConfig branchConfig = new BranchConfig((Config)this.repository.getConfig(), branchName);
        String remote = branchConfig.getRemote();
        if (remote == null) {
            return false;
        }
        if (!remote.equals(this.remoteConfig.getName())) {
            return true;
        }
        String merge = branchConfig.getMerge();
        if (merge == null || !merge.equals(this.getFullRemoteReference())) {
            return true;
        }
        boolean rebase = branchConfig.isRebase();
        return rebase != this.isRebaseSelected();
    }

    private void handleError(URISyntaxException e) {
        Activator.handleError(e.getMessage(), e, false);
        this.setErrorMessage(e.getMessage());
    }

    public void dispose() {
        super.dispose();
        for (Resource disposable : this.disposables) {
            disposable.dispose();
        }
    }
}

