/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.CreateBranchPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class CreateBranchWizard
extends Wizard {
    private String newBranchName;
    private CreateBranchPage myPage;

    public CreateBranchWizard(Repository repository) {
        this(repository, null);
    }

    public CreateBranchWizard(Repository repository, String base) {
        try {
            if (base == null) {
                this.myPage = new CreateBranchPage(repository, null);
            } else if (ObjectId.isId((String)base)) {
                RevCommit commit = new RevWalk(repository).parseCommit((AnyObjectId)ObjectId.fromString((String)base));
                this.myPage = new CreateBranchPage(repository, commit);
            } else if (base.startsWith("refs/heads/") || base.startsWith("refs/remotes/") || base.startsWith("refs/tags/")) {
                Ref currentBranch = repository.getRef(base);
                this.myPage = new CreateBranchPage(repository, currentBranch);
            } else {
                RevCommit commit = new RevWalk(repository).parseCommit((AnyObjectId)repository.resolve(String.valueOf(base) + "^{commit}"));
                this.myPage = new CreateBranchPage(repository, commit);
            }
        }
        catch (IOException iOException) {
            this.myPage = new CreateBranchPage(repository, null);
        }
        this.setWindowTitle(UIText.CreateBranchWizard_NewBranchTitle);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myPage);
    }

    public boolean performFinish() {
        final CreateBranchPage cp = (CreateBranchPage)this.getPages()[0];
        this.newBranchName = cp.getBranchName();
        final boolean checkoutNewBranch = cp.checkoutNewBranch();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        cp.createBranch(CreateBranchWizard.this.newBranchName, checkoutNewBranch, monitor);
                    }
                    catch (CoreException ce) {
                        throw new InvocationTargetException(ce);
                    }
                    catch (IOException ioe) {
                        throw new InvocationTargetException(ioe);
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            Activator.handleError(UIText.CreateBranchWizard_CreationFailed, ite.getCause(), true);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public String getNewBranchName() {
        return this.newBranchName;
    }
}

