/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class TagOperation
implements IEGitOperation {
    private final TagBuilder tag;
    private final Repository repo;
    private final boolean shouldMoveTag;

    public TagOperation(Repository repo, TagBuilder tag, boolean shouldMoveTag) {
        this.tag = tag;
        this.repo = repo;
        this.shouldMoveTag = shouldMoveTag;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        try {
            monitor.beginTask(NLS.bind((String)CoreText.TagOperation_performingTagging, (Object)this.tag.getTag()), 3);
            ObjectId tagId = this.updateTagObject();
            monitor.worked(1);
            this.updateRepo(tagId);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private void updateRepo(ObjectId tagId) throws TeamException {
        String refName = "refs/tags/" + this.tag.getTag();
        try {
            RefUpdate tagRef = this.repo.updateRef(refName);
            tagRef.setNewObjectId((AnyObjectId)tagId);
            tagRef.setForceUpdate(this.shouldMoveTag);
            RefUpdate.Result updateResult = tagRef.update();
            if (updateResult != RefUpdate.Result.NEW && updateResult != RefUpdate.Result.FORCED) {
                throw new TeamException(NLS.bind((String)CoreText.TagOperation_taggingFailure, (Object)this.tag.getTag(), (Object)updateResult));
            }
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.TagOperation_taggingFailure, (Object)this.tag.getTag(), (Object)e.getMessage()), (Throwable)e);
        }
    }

    private ObjectId updateTagObject() throws TeamException {
        ObjectId startPointRef = this.tag.getObjectId();
        try {
            ObjectId tagId;
            this.repo.open((AnyObjectId)startPointRef);
            ObjectInserter inserter = this.repo.newObjectInserter();
            try {
                tagId = inserter.insert(this.tag);
                inserter.flush();
            }
            finally {
                inserter.release();
            }
            return tagId;
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.TagOperation_objectIdNotFound, (Object)this.tag.getTag(), (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

