/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.internal.runtime.PlatformLogWriter;
import org.eclipse.core.internal.runtime.PlatformURLConfigConnection;
import org.eclipse.core.internal.runtime.PlatformURLConverter;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLMetaConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Map<String, ServiceTracker<Object, URLConverter>> urlTrackers = new HashMap<String, ServiceTracker<Object, URLConverter>>();
    private static BundleContext bundleContext;
    private static Activator singleton;
    private ServiceRegistration<URLConverter> platformURLConverterService = null;
    private ServiceRegistration<IAdapterManager> adapterManagerService = null;
    private ServiceTracker<Object, Location> installLocationTracker = null;
    private ServiceTracker<Object, Location> instanceLocationTracker = null;
    private ServiceTracker<Object, Location> configLocationTracker = null;
    private ServiceTracker<Object, PackageAdmin> bundleTracker = null;
    private ServiceTracker<Object, DebugOptions> debugTracker = null;
    private ServiceTracker<Object, FrameworkLog> logTracker = null;
    private ServiceTracker<Object, BundleLocalization> localizationTracker = null;

    public static Activator getDefault() {
        return singleton;
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        singleton = this;
        RuntimeLog.setLogWriter(this.getPlatformWriter(context));
        Hashtable<String, String> urlProperties = new Hashtable<String, String>();
        ((Dictionary)urlProperties).put("protocol", "platform");
        this.platformURLConverterService = context.registerService(URLConverter.class, (Object)new PlatformURLConverter(), urlProperties);
        this.adapterManagerService = context.registerService(IAdapterManager.class, (Object)AdapterManager.getDefault(), null);
        this.installPlatformURLSupport();
    }

    private PlatformLogWriter getPlatformWriter(BundleContext context) {
        ServiceReference logRef = context.getServiceReference(ExtendedLogService.class);
        ServiceReference readerRef = context.getServiceReference(ExtendedLogReaderService.class);
        ServiceReference packageAdminRef = context.getServiceReference(PackageAdmin.class);
        if (logRef == null || readerRef == null || packageAdminRef == null) {
            return null;
        }
        ExtendedLogService logService = (ExtendedLogService)context.getService(logRef);
        ExtendedLogReaderService readerService = (ExtendedLogReaderService)context.getService(readerRef);
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(packageAdminRef);
        if (logService == null || readerService == null || packageAdmin == null) {
            return null;
        }
        PlatformLogWriter writer = new PlatformLogWriter(logService, packageAdmin, context.getBundle());
        readerService.addLogListener((LogListener)writer, (LogFilter)writer);
        return writer;
    }

    public Location getConfigurationLocation() {
        if (this.configLocationTracker == null) {
            Filter filter = null;
            try {
                filter = bundleContext.createFilter(Location.CONFIGURATION_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.configLocationTracker = new ServiceTracker(bundleContext, filter, null);
            this.configLocationTracker.open();
        }
        return (Location)this.configLocationTracker.getService();
    }

    public DebugOptions getDebugOptions() {
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(bundleContext, DebugOptions.class.getName(), null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    public FrameworkLog getFrameworkLog() {
        if (this.logTracker == null) {
            this.logTracker = new ServiceTracker(bundleContext, FrameworkLog.class.getName(), null);
            this.logTracker.open();
        }
        return (FrameworkLog)this.logTracker.getService();
    }

    public Location getInstanceLocation() {
        if (this.instanceLocationTracker == null) {
            Filter filter = null;
            try {
                filter = bundleContext.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.instanceLocationTracker = new ServiceTracker(bundleContext, filter, null);
            this.instanceLocationTracker.open();
        }
        return (Location)this.instanceLocationTracker.getService();
    }

    public Bundle getBundle(String symbolicName) {
        PackageAdmin admin = this.getBundleAdmin();
        if (admin == null) {
            return null;
        }
        Bundle[] bundles = admin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private PackageAdmin getBundleAdmin() {
        if (this.bundleTracker == null) {
            this.bundleTracker = new ServiceTracker(Activator.getContext(), PackageAdmin.class.getName(), null);
            this.bundleTracker.open();
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    public Bundle[] getFragments(Bundle host) {
        PackageAdmin admin = this.getBundleAdmin();
        if (admin == null) {
            return new Bundle[0];
        }
        return admin.getFragments(host);
    }

    public Location getInstallLocation() {
        if (this.installLocationTracker == null) {
            Filter filter = null;
            try {
                filter = bundleContext.createFilter(Location.INSTALL_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.installLocationTracker = new ServiceTracker(bundleContext, filter, null);
            this.installLocationTracker.open();
        }
        return (Location)this.installLocationTracker.getService();
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    public ResourceBundle getLocalization(Bundle bundle, String locale) throws MissingResourceException {
        if (this.localizationTracker == null) {
            BundleContext context = Activator.getContext();
            if (context == null) {
                throw new MissingResourceException(CommonMessages.activator_resourceBundleNotStarted, bundle.getSymbolicName(), "");
            }
            this.localizationTracker = new ServiceTracker(context, BundleLocalization.class.getName(), null);
            this.localizationTracker.open();
        }
        BundleLocalization location = (BundleLocalization)this.localizationTracker.getService();
        ResourceBundle result = null;
        if (location != null) {
            result = location.getLocalization(bundle, locale);
        }
        if (result == null) {
            throw new MissingResourceException(NLS.bind((String)CommonMessages.activator_resourceBundleNotFound, (Object)locale), bundle.getSymbolicName(), "");
        }
        return result;
    }

    public void stop(BundleContext context) throws Exception {
        Activator.closeURLTrackerServices();
        if (this.platformURLConverterService != null) {
            this.platformURLConverterService.unregister();
            this.platformURLConverterService = null;
        }
        if (this.adapterManagerService != null) {
            this.adapterManagerService.unregister();
            this.adapterManagerService = null;
        }
        if (this.installLocationTracker != null) {
            this.installLocationTracker.close();
            this.installLocationTracker = null;
        }
        if (this.configLocationTracker != null) {
            this.configLocationTracker.close();
            this.configLocationTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.instanceLocationTracker != null) {
            this.instanceLocationTracker.close();
            this.instanceLocationTracker = null;
        }
        if (this.localizationTracker != null) {
            this.localizationTracker.close();
            this.localizationTracker = null;
        }
        RuntimeLog.setLogWriter(null);
        bundleContext = null;
        singleton = null;
    }

    static BundleContext getContext() {
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeURLTrackerServices() {
        Map<String, ServiceTracker<Object, URLConverter>> map = urlTrackers;
        synchronized (map) {
            if (!urlTrackers.isEmpty()) {
                for (String key : urlTrackers.keySet()) {
                    ServiceTracker<Object, URLConverter> tracker = urlTrackers.get(key);
                    tracker.close();
                }
                urlTrackers = new HashMap<String, ServiceTracker<Object, URLConverter>>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URLConverter getURLConverter(URL url) {
        String protocol = url.getProtocol();
        Map<String, ServiceTracker<Object, URLConverter>> map = urlTrackers;
        synchronized (map) {
            ServiceTracker tracker = urlTrackers.get(protocol);
            if (tracker == null) {
                String FILTER_PREFIX = "(&(objectClass=" + URLConverter.class.getName() + ")(protocol=";
                String FILTER_POSTFIX = "))";
                Filter filter = null;
                try {
                    filter = Activator.getContext().createFilter(String.valueOf(FILTER_PREFIX) + protocol + FILTER_POSTFIX);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    return null;
                }
                tracker = new ServiceTracker(Activator.getContext(), filter, null);
                tracker.open();
                urlTrackers.put(protocol, (ServiceTracker<Object, URLConverter>)tracker);
            }
            return (URLConverter)tracker.getService();
        }
    }

    private void installPlatformURLSupport() {
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
        PlatformURLMetaConnection.startup();
        PlatformURLConfigConnection.startup();
        Location service = this.getInstallLocation();
        if (service != null) {
            PlatformURLBaseConnection.startup(service.getURL());
        }
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
        properties.put("url.handler.protocol", new String[]{"platform"});
        Activator.getContext().registerService(URLStreamHandlerService.class.getName(), (Object)new PlatformURLHandler(), properties);
    }
}

