/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.swt.CSSRenderingUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarContributionRecord;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolControlContribution;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolItemUpdater;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;

public class ToolBarManagerRenderer
extends SWTPartRenderer {
    private static final Selector ALL_SELECTOR = new Selector(){

        public boolean select(MApplicationElement element) {
            return true;
        }
    };
    public static final String POST_PROCESSING_FUNCTION = "ToolBarManagerRenderer.postProcess.func";
    public static final String POST_PROCESSING_DISPOSE = "ToolBarManagerRenderer.postProcess.dispose";
    public static final String UPDATE_VARS = "ToolBarManagerRenderer.updateVars";
    private static final String DISPOSE_ADDED = "ToolBarManagerRenderer.disposeAdded";
    private Map<MToolBar, ToolBarManager> modelToManager = new HashMap<MToolBar, ToolBarManager>();
    private Map<ToolBarManager, MToolBar> managerToModel = new HashMap<ToolBarManager, MToolBar>();
    private Map<MToolBarElement, IContributionItem> modelToContribution = new HashMap<MToolBarElement, IContributionItem>();
    private Map<IContributionItem, MToolBarElement> contributionToModel = new HashMap<IContributionItem, MToolBarElement>();
    private Map<MToolBarElement, ToolBarContributionRecord> modelContributionToRecord = new HashMap<MToolBarElement, ToolBarContributionRecord>();
    private Map<MToolBarElement, ArrayList<ToolBarContributionRecord>> sharedElementToRecord = new HashMap<MToolBarElement, ArrayList<ToolBarContributionRecord>>();
    private ToolItemUpdater enablementUpdater = new ToolItemUpdater();
    @Inject
    private MApplication application;
    @Inject
    EModelService modelService;
    private HashSet<String> updateVariables = new HashSet();

    @Inject
    @Optional
    private void subscribeTopicUpdateItems(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UILabel/*") Event event) {
        if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
            return;
        }
        MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
        IContributionItem ici = this.getContribution(itemModel);
        if (ici == null) {
            return;
        }
        String attName = (String)event.getProperty("AttName");
        if ("label".equals(attName) || "localizedLabel".equals(attName)) {
            ici.update();
        } else if ("iconURI".equals(attName)) {
            ici.update();
        } else if ("tooltip".equals(attName) || "localizedTooltip".equals(attName)) {
            ici.update();
        }
    }

    @Inject
    @Optional
    private void subscribeTopicUpdateToBeRendered(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/*") Event event) {
        if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
            return;
        }
        MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
        String attName = (String)event.getProperty("AttName");
        if ("toBeRendered".equals(attName)) {
            MElementContainer obj = itemModel.getParent();
            if (!(obj instanceof MToolBar)) {
                return;
            }
            ToolBarManager parent = this.getManager((MToolBar)obj);
            if (itemModel.isToBeRendered()) {
                if (parent != null) {
                    this.modelProcessSwitch(parent, itemModel);
                    parent.update(true);
                    ToolBar tb = parent.getControl();
                    if (tb != null && !tb.isDisposed()) {
                        tb.pack(true);
                        tb.getShell().layout(new Control[]{tb}, 4);
                    }
                }
            } else {
                IContributionItem ici = this.modelToContribution.remove(itemModel);
                if (ici != null && parent != null) {
                    parent.remove(ici);
                }
                if (ici != null) {
                    ici.dispose();
                }
            }
        } else if ("visible".equals(attName)) {
            IContributionItem ici = this.getContribution(itemModel);
            if (ici == null) {
                return;
            }
            ToolBarManager parent = null;
            if (ici instanceof MenuManager) {
                parent = (ToolBarManager)((MenuManager)ici).getParent();
            } else if (ici instanceof ContributionItem) {
                parent = (ToolBarManager)((ContributionItem)ici).getParent();
            }
            if (parent == null) {
                ici.setVisible(itemModel.isVisible());
                return;
            }
            IContributionManagerOverrides ov = parent.getOverrides();
            if (ov == null) {
                ici.setVisible(itemModel.isVisible());
            } else {
                Boolean visible = ov.getVisible(ici);
                if (visible == null) {
                    ici.setVisible(itemModel.isVisible());
                }
            }
            parent.markDirty();
            parent.update(true);
            ToolBar tb = parent.getControl();
            if (tb != null && !tb.isDisposed()) {
                tb.pack(true);
                if (tb.getParent() != null) {
                    tb.getParent().pack(true);
                }
                tb.getShell().layout(new Control[]{tb}, 4);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicUpdateSelection(@UIEventTopic(value="org/eclipse/e4/ui/model/menu/Item/selected/*") Event event) {
        if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
            return;
        }
        MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
        IContributionItem ici = this.getContribution(itemModel);
        if (ici != null) {
            ici.update();
        }
    }

    @Inject
    @Optional
    private void subscribeTopicUpdateEnablement(@UIEventTopic(value="org/eclipse/e4/ui/model/menu/Item/enabled/*") Event event) {
        if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
            return;
        }
        MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
        IContributionItem ici = this.getContribution(itemModel);
        if (ici != null) {
            ici.update();
        }
    }

    @Inject
    @Optional
    private void subscribeTopicChildAdded(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        if (!(event.getProperty("ChangedElement") instanceof MToolBar)) {
            return;
        }
        MToolBar toolbarModel = (MToolBar)event.getProperty("ChangedElement");
        if (UIEvents.isADD((Event)event)) {
            MToolBar obj = toolbarModel;
            this.processContents((MElementContainer<MUIElement>)((MElementContainer)obj));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicDirtyChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*") Event eventData) {
        this.getUpdater().updateContributionItems(ALL_SELECTOR);
    }

    @Inject
    @Optional
    private void subscribeTopicUpdateToolbarEnablement(@UIEventTopic(value="org/eclipse/e4/ui/renderer/requestEnablementUpdate") Event eventData) {
        final Object v = eventData.getProperty("org.eclipse.e4.data");
        Selector s = v instanceof Selector ? (Selector)v : (v == null || "ALL".equals(v) ? ALL_SELECTOR : new Selector(){

            public boolean select(MApplicationElement element) {
                return v.equals(element.getElementId());
            }
        });
        this.getUpdater().updateContributionItems(s);
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MToolBar)) {
            return;
        }
        MUIElement changedElement = (MUIElement)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"HIDDEN_EXPLICITLY")) {
                changedElement.setVisible(false);
                changedElement.setToBeRendered(false);
            }
        } else if (UIEvents.isREMOVE((Event)event) && UIEvents.contains((Event)event, (String)"OldValue", (Object)"HIDDEN_EXPLICITLY")) {
            changedElement.setVisible(true);
            changedElement.setToBeRendered(true);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicAppStartup(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        List toolBars = this.modelService.findElements((MUIElement)this.application, null, MToolBar.class, null);
        for (MToolBar mToolBar : toolBars) {
            if (!mToolBar.getTags().contains("HIDDEN_EXPLICITLY")) continue;
            mToolBar.setVisible(false);
            mToolBar.setToBeRendered(false);
        }
    }

    @PostConstruct
    public void init() {
        this.context.set(ToolBarManagerRenderer.class, (Object)this);
        String[] vars = new String[]{"org.eclipse.ui.internal.services.EvaluationService.evaluate", "activeContexts", "e4ActivePart", "org.eclipse.ui.selection", "activeShell"};
        this.updateVariables.addAll(Arrays.asList(vars));
        this.context.set(UPDATE_VARS, this.updateVariables);
        RunAndTrack enablementUpdater = new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                for (String var : ToolBarManagerRenderer.this.updateVariables) {
                    context.get(var);
                }
                ToolBarManagerRenderer.this.getUpdater().updateContributionItems(ALL_SELECTOR);
                return true;
            }
        };
        this.context.runAndTrack(enablementUpdater);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        MToolBar toolbarModel = (MToolBar)element;
        ToolBar newTB = this.createToolbar((MUIElement)toolbarModel, (Composite)parent);
        this.bindWidget(element, newTB);
        this.processContribution(toolbarModel, toolbarModel.getElementId());
        ToolBar renderedCtrl = newTB;
        MElementContainer parentElement = element.getParent();
        if (parentElement instanceof MTrimBar) {
            element.getTags().add("Draggable");
            this.setCSSInfo(element, newTB);
            boolean vertical = false;
            MTrimBar bar = (MTrimBar)parentElement;
            vertical = bar.getSide() == SideValue.LEFT || bar.getSide() == SideValue.RIGHT;
            IEclipseContext parentContext = this.getContextForParent(element);
            CSSRenderingUtils cssUtils = (CSSRenderingUtils)parentContext.get(CSSRenderingUtils.class);
            if (cssUtils != null) {
                renderedCtrl = cssUtils.frameMeIfPossible((Control)newTB, null, vertical, true);
            }
        }
        return renderedCtrl;
    }

    public void processContribution(MToolBar toolbarModel, String elementId) {
        ToolBarManager manager = this.getManager(toolbarModel);
        if (manager != null && manager.getControl() != null) {
            this.addCleanupDisposeListener(toolbarModel, manager.getControl());
        }
        ArrayList<MToolBarContribution> toContribute = new ArrayList<MToolBarContribution>();
        ContributionsAnalyzer.XXXgatherToolBarContributions((MToolBar)toolbarModel, (List)this.application.getToolBarContributions(), (String)elementId, toContribute);
        this.generateContributions(toolbarModel, toContribute);
    }

    private void addCleanupDisposeListener(final MToolBar toolbarModel, ToolBar control) {
        final Map transientData = toolbarModel.getTransientData();
        if (!transientData.containsKey(DISPOSE_ADDED)) {
            transientData.put(DISPOSE_ADDED, Boolean.TRUE);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ToolBarManagerRenderer.this.cleanUp(toolbarModel);
                    Object dispose = transientData.get(ToolBarManagerRenderer.POST_PROCESSING_DISPOSE);
                    if (dispose instanceof Runnable) {
                        ((Runnable)dispose).run();
                    }
                    transientData.remove(ToolBarManagerRenderer.POST_PROCESSING_DISPOSE);
                    transientData.remove(ToolBarManagerRenderer.DISPOSE_ADDED);
                }
            });
        }
    }

    private void generateContributions(MToolBar toolbarModel, List<MToolBarContribution> toContribute) {
        ToolBarManager manager = this.getManager(toolbarModel);
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MToolBarContribution> curList = new ArrayList<MToolBarContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MToolBarContribution contribution : curList) {
                if (this.processAddition(toolbarModel, manager, contribution)) continue;
                toContribute.add(contribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private boolean processAddition(final MToolBar toolbarModel, final ToolBarManager manager, MToolBarContribution contribution) {
        final ToolBarContributionRecord record = new ToolBarContributionRecord(toolbarModel, contribution, this);
        if (!record.mergeIntoModel()) {
            return false;
        }
        if (record.anyVisibleWhen()) {
            ExpressionInfo info = new ExpressionInfo();
            record.collectInfo(info);
            this.updateVariables.addAll(Arrays.asList(info.getAccessedVariableNames()));
            final IEclipseContext parentContext = this.getContext((MUIElement)toolbarModel);
            parentContext.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    if (ToolBarManagerRenderer.this.getManager(toolbarModel) == null) {
                        return false;
                    }
                    record.updateVisibility(parentContext.getActiveLeaf());
                    this.runExternalCode(new Runnable(){

                        @Override
                        public void run() {
                            manager.update(false);
                            ToolBarManagerRenderer.this.getUpdater().updateContributionItems(ALL_SELECTOR);
                        }
                    });
                    return true;
                }
            });
        }
        return true;
    }

    private ToolBar createToolbar(MUIElement element, Composite parent) {
        int orientation = this.getOrientation(element);
        int style = orientation | 0x40 | 0x800000 | 0x20000;
        ToolBarManager manager = this.getManager((MToolBar)element);
        if (manager == null) {
            manager = new ToolBarManager(style);
            IContributionManagerOverrides overrides = null;
            MElementContainer parentElement = element.getParent();
            if (parentElement == null) {
                parentElement = (MApplicationElement)((EObject)element).eContainer();
            }
            if (parentElement != null) {
                overrides = (IContributionManagerOverrides)parentElement.getTransientData().get(IContributionManagerOverrides.class.getName());
            }
            manager.setOverrides(overrides);
            this.linkModelToManager((MToolBar)element, manager);
        } else {
            ToolBar toolBar = manager.getControl();
            if (toolBar != null && !toolBar.isDisposed() && (toolBar.getStyle() & orientation) == 0) {
                toolBar.dispose();
            }
            manager.setStyle(style);
        }
        ToolBar bar = manager.createControl(parent);
        bar.setData((Object)manager);
        bar.setData("modelElement", (Object)element);
        bar.getShell().layout(new Control[]{bar}, 4);
        return bar;
    }

    protected void cleanUp(MToolBar toolbarModel) {
        Collection<ToolBarContributionRecord> vals = this.modelContributionToRecord.values();
        ToolBarContributionRecord[] toolBarContributionRecordArray = vals.toArray(new ToolBarContributionRecord[vals.size()]);
        int n = toolBarContributionRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolBarContributionRecord record = toolBarContributionRecordArray[n2];
            if (record.toolbarModel == toolbarModel) {
                record.dispose();
                for (MToolBarElement copy : record.generatedElements) {
                    this.cleanUpCopy(record, copy);
                }
                for (MToolBarElement copy : record.sharedElements) {
                    this.cleanUpCopy(record, copy);
                }
                record.generatedElements.clear();
                record.sharedElements.clear();
            }
            ++n2;
        }
    }

    public void cleanUpCopy(ToolBarContributionRecord record, MToolBarElement copy) {
        this.modelContributionToRecord.remove(copy);
        IContributionItem ici = this.getContribution(copy);
        this.clearModelToContribution(copy, ici);
        if (ici != null) {
            record.getManagerForModel().remove(ici);
        }
    }

    int getOrientation(MUIElement element) {
        MTrimBar trimContainer;
        SideValue side;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        MElementContainer<MUIElement> obj = container;
        ToolBarManager parentManager = this.getManager((MToolBar)obj);
        if (parentManager == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                this.modelProcessSwitch(parentManager, (MToolBarElement)childME);
                ++i;
            }
        }
        parentManager.update(true);
        ToolBar tb = this.getToolbarFrom(container.getWidget());
        if (tb != null) {
            tb.pack(true);
            tb.getShell().layout(new Control[]{tb}, 4);
        }
    }

    private ToolBar getToolbarFrom(Object widget) {
        Composite intermediate;
        if (widget instanceof ToolBar) {
            return (ToolBar)widget;
        }
        if (widget instanceof Composite && !(intermediate = (Composite)widget).isDisposed()) {
            Control[] children;
            Control[] controlArray = children = intermediate.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control.getData() instanceof ToolBarManager) {
                    return (ToolBar)control;
                }
                ++n2;
            }
        }
        return null;
    }

    boolean hasOnlySeparators(ToolBar toolbar) {
        ToolItem[] children;
        ToolItem[] toolItemArray = children = toolbar.getItems();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if ((toolItem.getStyle() & 2) == 0) {
                return false;
            }
            if (toolItem.getControl() != null && toolItem.getControl().getData("modelElement") instanceof MToolControl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        if (child.getRenderer() != null) {
            ToolBar toolbar;
            Widget widget = (Widget)child.getWidget();
            if (widget != null && !widget.isDisposed()) {
                widget.dispose();
            }
            if ((toolbar = (ToolBar)this.getUIContainer(child)) != null && !toolbar.isDisposed()) {
                toolbar.pack(true);
                toolbar.getShell().layout(new Control[]{toolbar}, 4);
            }
        }
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        this.processContents(parentElement);
        ToolBar toolbar = (ToolBar)this.getUIContainer(element);
        if (toolbar != null && !toolbar.isDisposed()) {
            toolbar.pack(true);
            toolbar.getShell().layout(new Control[]{toolbar}, 4);
        }
    }

    public Object getUIContainer(MUIElement childElement) {
        Composite intermediate = (Composite)super.getUIContainer(childElement);
        if (intermediate == null || intermediate.isDisposed()) {
            return null;
        }
        if (intermediate instanceof ToolBar) {
            return intermediate;
        }
        ToolBar toolbar = this.findToolbar(intermediate);
        if (toolbar == null) {
            toolbar = this.createToolbar((MUIElement)childElement.getParent(), intermediate);
        }
        return toolbar;
    }

    private ToolBar findToolbar(Composite intermediate) {
        Control[] controlArray = intermediate.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData() instanceof ToolBarManager) {
                return (ToolBar)child;
            }
            ++n2;
        }
        return null;
    }

    private void modelProcessSwitch(ToolBarManager parentManager, MToolBarElement childME) {
        if (OpaqueElementUtil.isOpaqueToolItem((MUIElement)childME)) {
            MToolItem itemModel = (MToolItem)childME;
            this.processOpaqueItem(parentManager, itemModel);
        } else if (childME instanceof MHandledToolItem) {
            MHandledToolItem itemModel = (MHandledToolItem)childME;
            this.processHandledItem(parentManager, itemModel);
        } else if (childME instanceof MDirectToolItem) {
            MDirectToolItem itemModel = (MDirectToolItem)childME;
            this.processDirectItem(parentManager, itemModel);
        } else if (childME instanceof MToolBarSeparator) {
            MToolBarSeparator itemModel = (MToolBarSeparator)childME;
            this.processSeparator(parentManager, itemModel);
        } else if (childME instanceof MToolControl) {
            MToolControl itemModel = (MToolControl)childME;
            this.processToolControl(parentManager, itemModel);
        }
    }

    private void processSeparator(ToolBarManager parentManager, MToolBarSeparator itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        Separator marker = null;
        if (itemModel.isVisible() && !itemModel.getTags().contains("org.eclipse.jface.action.GroupMarker.GroupMarker(String)")) {
            marker = new Separator();
            marker.setId(itemModel.getElementId());
        } else if (itemModel.getElementId() != null) {
            marker = new GroupMarker(itemModel.getElementId());
        }
        if (marker != null) {
            this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)marker);
            this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)marker);
        }
    }

    private void processToolControl(ToolBarManager parentManager, MToolControl itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        ToolControlContribution ci = (ToolControlContribution)((Object)ContextInjectionFactory.make(ToolControlContribution.class, (IEclipseContext)lclContext));
        ci.setModel(itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    private void processDirectItem(ToolBarManager parentManager, MDirectToolItem itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        DirectContributionItem ci = (DirectContributionItem)((Object)ContextInjectionFactory.make(DirectContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    private void processHandledItem(ToolBarManager parentManager, MHandledToolItem itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        HandledContributionItem ci = (HandledContributionItem)((Object)ContextInjectionFactory.make(HandledContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MHandledItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MToolBarElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    void processOpaqueItem(ToolBarManager parentManager, MToolItem itemModel) {
        IContributionItem ici = this.getContribution((MToolBarElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        Object obj = OpaqueElementUtil.getOpaqueItem((MUIElement)itemModel);
        if (!(obj instanceof IContributionItem)) {
            return;
        }
        ici = (IContributionItem)obj;
        ici.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MToolBarElement)itemModel, ici);
        this.linkModelToContribution((MToolBarElement)itemModel, ici);
    }

    private void addToManager(ToolBarManager parentManager, MToolBarElement model, IContributionItem ci) {
        MElementContainer parent = model.getParent();
        if (parent == null) {
            parentManager.add(ci);
        } else {
            int index = parent.getChildren().indexOf(model);
            if (index > parentManager.getSize() || index == -1) {
                parentManager.add(ci);
            } else {
                parentManager.insert(index, ci);
            }
        }
    }

    public ToolBarManager getManager(MToolBar model) {
        return this.modelToManager.get(model);
    }

    public MToolBar getToolBarModel(ToolBarManager manager) {
        return this.managerToModel.get(manager);
    }

    public void linkModelToManager(MToolBar model, ToolBarManager manager) {
        this.modelToManager.put(model, manager);
        this.managerToModel.put(manager, model);
    }

    public void clearModelToManager(MToolBar model, ToolBarManager manager) {
        this.modelToManager.remove(model);
        this.managerToModel.remove(manager);
    }

    public IContributionItem getContribution(MToolBarElement element) {
        return this.modelToContribution.get(element);
    }

    public MToolBarElement getToolElement(IContributionItem item) {
        return this.contributionToModel.get(item);
    }

    public void linkModelToContribution(MToolBarElement model, IContributionItem item) {
        this.modelToContribution.put(model, item);
        this.contributionToModel.put(item, model);
    }

    public void clearModelToContribution(MToolBarElement model, IContributionItem item) {
        this.modelToContribution.remove(model);
        this.contributionToModel.remove(item);
    }

    public ArrayList<ToolBarContributionRecord> getList(MToolBarElement item) {
        ArrayList<ToolBarContributionRecord> tmp = this.sharedElementToRecord.get(item);
        if (tmp == null) {
            tmp = new ArrayList();
            this.sharedElementToRecord.put(item, tmp);
        }
        return tmp;
    }

    public void linkElementToContributionRecord(MToolBarElement element, ToolBarContributionRecord record) {
        this.modelContributionToRecord.put(element, record);
    }

    public ToolBarContributionRecord getContributionRecord(MToolBarElement element) {
        return this.modelContributionToRecord.get(element);
    }

    public void reconcileManagerToModel(IToolBarManager menuManager, MToolBar toolBar) {
        List modelChildren = toolBar.getChildren();
        HashSet<MToolItem> oldModelItems = new HashSet<MToolItem>();
        for (MToolBarElement itemModel : modelChildren) {
            if (!OpaqueElementUtil.isOpaqueToolItem((MUIElement)itemModel)) continue;
            oldModelItems.add((MToolItem)itemModel);
        }
        IContributionItem[] items = menuManager.getItems();
        int src = 0;
        int dest = 0;
        while (src < items.length) {
            MToolItem legacyItem;
            IContributionItem item = items[src];
            MToolBarElement element = this.getToolElement(item);
            if (element == null) {
                legacyItem = OpaqueElementUtil.createOpaqueToolItem();
                legacyItem.setElementId(item.getId());
                legacyItem.setVisible(item.isVisible());
                OpaqueElementUtil.setOpaqueItem((MUIElement)legacyItem, (Object)item);
                this.linkModelToContribution((MToolBarElement)legacyItem, item);
                modelChildren.add(dest, legacyItem);
            } else if (OpaqueElementUtil.isOpaqueToolItem((MUIElement)element)) {
                legacyItem = (MToolItem)element;
                oldModelItems.remove(legacyItem);
                if (modelChildren.size() > dest) {
                    if (modelChildren.get(dest) != legacyItem) {
                        modelChildren.remove(legacyItem);
                        modelChildren.add(dest, legacyItem);
                    }
                } else {
                    modelChildren.add(legacyItem);
                }
            }
            ++src;
            ++dest;
        }
        if (!oldModelItems.isEmpty()) {
            modelChildren.removeAll(oldModelItems);
            for (MToolItem model : oldModelItems) {
                Object obj = OpaqueElementUtil.getOpaqueItem((MUIElement)model);
                this.clearModelToContribution((MToolBarElement)model, (IContributionItem)obj);
            }
        }
    }

    public void postProcess(MUIElement element) {
        Object obj;
        MToolBar toolbarModel;
        if (element instanceof MToolBar && (toolbarModel = (MToolBar)element).getTransientData().containsKey(POST_PROCESSING_FUNCTION) && (obj = toolbarModel.getTransientData().get(POST_PROCESSING_FUNCTION)) instanceof IContextFunction) {
            IContextFunction func = (IContextFunction)obj;
            IEclipseContext ctx = this.getContext((MUIElement)toolbarModel);
            toolbarModel.getTransientData().put(POST_PROCESSING_DISPOSE, func.compute(ctx, null));
        }
    }

    public IEclipseContext getContext(MUIElement el) {
        return super.getContext(el);
    }

    ToolItemUpdater getUpdater() {
        return this.enablementUpdater;
    }
}

