/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

public class ExceptionOccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String ID = "ExceptionOccurrencesFinder";
    public static final String IS_EXCEPTION = "isException";
    private CompilationUnit fASTRoot;
    private ASTNode fSelectedNode;
    private ITypeBinding fException;
    private ASTNode fStart;
    private TryStatement fTryStatement;
    private List<IOccurrencesFinder.OccurrenceLocation> fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
    private String fDescription;
    private List<ITypeBinding> fCaughtExceptions;

    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        this.fASTRoot = root;
        if (node == null) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        MethodDeclaration method = ASTResolving.findParentMethodDeclaration(node);
        if (method == null) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        if (node instanceof Name) {
            node = ASTNodes.getTopMostName((Name)node);
        }
        ASTNode parent = node.getParent();
        if (node.getLocationInParent() == TagElement.FRAGMENTS_PROPERTY) {
            TagElement tagElement = (TagElement)parent;
            String tagName = tagElement.getTagName();
            if (node instanceof Name && node == tagElement.fragments().get(0) && ("@exception".equals(tagName) || "@throws".equals(tagName))) {
                this.fSelectedNode = node;
                this.fException = ((Name)node).resolveTypeBinding();
                this.fStart = method;
            }
        } else {
            Type type = ASTNodes.getTopMostType(node);
            if (type == null) {
                return SearchMessages.ExceptionOccurrencesFinder_no_exception;
            }
            if (type.getLocationInParent() == MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY) {
                this.fSelectedNode = type;
                this.fException = type.resolveBinding();
                this.fStart = method;
            }
            Type topType = type;
            if (type.getLocationInParent() == UnionType.TYPES_PROPERTY) {
                topType = (Type)type.getParent();
            }
            if (topType.getLocationInParent() == SingleVariableDeclaration.TYPE_PROPERTY && topType.getParent().getLocationInParent() == CatchClause.EXCEPTION_PROPERTY) {
                this.fSelectedNode = type;
                this.fException = type.resolveBinding();
                this.fTryStatement = (TryStatement)topType.getParent().getParent().getParent();
                this.fStart = this.fTryStatement.getBody();
            }
        }
        if (this.fException == null || this.fStart == null) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        this.fDescription = Messages.format(SearchMessages.ExceptionOccurrencesFinder_occurrence_description, BasicElementLabels.getJavaElementName(this.fException.getName()));
        return null;
    }

    private void performSearch() {
        this.fCaughtExceptions = new ArrayList<ITypeBinding>();
        this.fStart.accept((ASTVisitor)this);
        if (this.fTryStatement != null) {
            this.handleResourceDeclarations(this.fTryStatement);
        }
        if (this.fSelectedNode != null) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.fSelectedNode.getStartPosition(), this.fSelectedNode.getLength(), 8, this.fDescription));
        }
    }

    private void handleResourceDeclarations(TryStatement tryStatement) {
        List resources = tryStatement.resources();
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            ((VariableDeclarationExpression)iterator.next()).accept((ASTVisitor)this);
        }
        boolean exitMarked = false;
        for (VariableDeclarationExpression variable : resources) {
            Type type = variable.getType();
            IMethodBinding methodBinding = Bindings.findMethodInHierarchy(type.resolveBinding(), "close", new ITypeBinding[0]);
            if (methodBinding == null) continue;
            ITypeBinding[] exceptionTypes = methodBinding.getExceptionTypes();
            int j = 0;
            while (j < exceptionTypes.length) {
                if (this.matches(exceptionTypes[j])) {
                    for (VariableDeclarationFragment fragment : variable.fragments()) {
                        SimpleName name = fragment.getName();
                        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fDescription));
                    }
                    if (!exitMarked) {
                        exitMarked = true;
                        Block body = tryStatement.getBody();
                        int offset = body.getStartPosition() + body.getLength() - 1;
                        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, 1, 0, Messages.format(SearchMessages.ExceptionOccurrencesFinder_occurrence_implicit_close_description, BasicElementLabels.getJavaElementName(this.fException.getName()))));
                    }
                }
                ++j;
            }
        }
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.performSearch();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    public int getSearchKind() {
        return 6;
    }

    public CompilationUnit getASTRoot() {
        return this.fASTRoot;
    }

    public String getJobLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_searchfor;
    }

    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString(this.fSelectedNode);
        }
        return null;
    }

    public String getUnformattedPluralLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_plural;
    }

    public String getUnformattedSingularLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_label_singular;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(CastExpression node) {
        if ("java.lang.ClassCastException".equals(this.fException.getQualifiedName())) {
            Type type = node.getType();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(type.getStartPosition(), type.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            Type type = node.getType();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(type.getStartPosition(), type.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 4, 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(LambdaExpression node) {
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        Javadoc javadoc = node.getJavadoc();
        if (javadoc != null) {
            List tags = javadoc.tags();
            for (TagElement tag : tags) {
                ASTNode name;
                String tagName = tag.getTagName();
                if (!"@exception".equals(tagName) && !"@throws".equals(tagName) || !((name = (ASTNode)tag.fragments().get(0)) instanceof Name) || name == this.fSelectedNode || !Bindings.equals((IBinding)this.fException, ((Name)name).resolveBinding())) continue;
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fDescription));
            }
        }
        List thrownExceptionTypes = node.thrownExceptionTypes();
        for (Type type : thrownExceptionTypes) {
            if (type == this.fSelectedNode || !Bindings.equals((IBinding)this.fException, (IBinding)type.resolveBinding())) continue;
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(type.getStartPosition(), type.getLength(), 0, this.fDescription));
        }
        Block body = node.getBody();
        if (body != null) {
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            SimpleName name = node.getName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 5, 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            SimpleName name = node.getName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStartPosition(), name.getLength(), 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        if (this.matches(node.getExpression().resolveTypeBinding())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), 5, 0, this.fDescription));
        }
        return super.visit(node);
    }

    public boolean visit(TryStatement node) {
        int toRemove;
        int currentSize = this.fCaughtExceptions.size();
        List catchClauses = node.catchClauses();
        Iterator iter = catchClauses.iterator();
        while (iter.hasNext()) {
            Type type = ((CatchClause)iter.next()).getException().getType();
            if (type instanceof UnionType) {
                List types = ((UnionType)type).types();
                Iterator iterator = types.iterator();
                while (iterator.hasNext()) {
                    this.addCaughtException((Type)iterator.next());
                }
                continue;
            }
            this.addCaughtException(type);
        }
        node.getBody().accept((ASTVisitor)this);
        this.handleResourceDeclarations(node);
        int i = toRemove = this.fCaughtExceptions.size() - currentSize;
        while (i > 0) {
            this.fCaughtExceptions.remove(currentSize);
            --i;
        }
        Iterator iter2 = catchClauses.iterator();
        while (iter2.hasNext()) {
            ((CatchClause)iter2.next()).accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    private void addCaughtException(Type type) {
        ITypeBinding typeBinding = type.resolveBinding();
        if (typeBinding != null) {
            this.fCaughtExceptions.add(typeBinding);
        }
    }

    public boolean visit(TypeDeclarationStatement node) {
        return false;
    }

    private boolean matches(IMethodBinding binding) {
        if (binding == null) {
            return false;
        }
        ITypeBinding[] exceptions = binding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            ITypeBinding exception = exceptions[i];
            if (this.matches(exception)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean matches(ITypeBinding exception) {
        if (exception == null) {
            return false;
        }
        if (!this.isCaught(exception)) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (Bindings.equals((IBinding)this.fException, (IBinding)exception)) {
                return true;
            }
            exception = exception.getSuperclass();
lbl8:
            // 2 sources

            ** while (exception != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    private boolean isCaught(ITypeBinding binding) {
        for (ITypeBinding catchException : this.fCaughtExceptions) {
            if (!this.catches(catchException, binding)) continue;
            return true;
        }
        return false;
    }

    private boolean catches(ITypeBinding catchTypeBinding, ITypeBinding throwTypeBinding) {
        while (throwTypeBinding != null) {
            if (throwTypeBinding == catchTypeBinding) {
                return true;
            }
            throwTypeBinding = throwTypeBinding.getSuperclass();
        }
        return false;
    }

    public IOccurrencesFinder getNewInstance() {
        return new ExceptionOccurrencesFinder();
    }

    public String getID() {
        return ID;
    }
}

