/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.DontCareFieldPosition;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.SimpleCache;
import com.ibm.icu.impl.SimplePatternFormatter;
import com.ibm.icu.text.CurrencyFormat;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.text.PluralRanges;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.QuantityFormatter;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.TimeUnitFormat;
import com.ibm.icu.text.UFieldPosition;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.Measure;
import com.ibm.icu.util.MeasureUnit;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureFormat
extends UFormat {
    static final long serialVersionUID = -7182021401701778240L;
    private final transient ImmutableNumberFormat numberFormat;
    private final transient FormatWidth formatWidth;
    private final transient PluralRules rules;
    private final transient Map<MeasureUnit, EnumMap<FormatWidth, QuantityFormatter>> unitToStyleToCountToFormat;
    private final transient NumericFormatters numericFormatters;
    private final transient ImmutableNumberFormat currencyFormat;
    private final transient ImmutableNumberFormat integerFormat;
    private final transient Map<MeasureUnit, EnumMap<FormatWidth, SimplePatternFormatter>> unitToStyleToPerUnitPattern;
    private final transient EnumMap<FormatWidth, SimplePatternFormatter> styleToPerPattern;
    private static final SimpleCache<ULocale, MeasureFormatData> localeMeasureFormatData = new SimpleCache();
    private static final SimpleCache<ULocale, NumericFormatters> localeToNumericDurationFormatters = new SimpleCache();
    private static final Map<MeasureUnit, Integer> hmsTo012 = new HashMap<MeasureUnit, Integer>();
    private static final int MEASURE_FORMAT = 0;
    private static final int TIME_UNIT_FORMAT = 1;
    private static final int CURRENCY_FORMAT = 2;
    static final Map<ULocale, SimplePatternFormatter> localeIdToRangeFormat;

    static {
        hmsTo012.put(MeasureUnit.HOUR, 0);
        hmsTo012.put(MeasureUnit.MINUTE, 1);
        hmsTo012.put(MeasureUnit.SECOND, 2);
        localeIdToRangeFormat = new ConcurrentHashMap<ULocale, SimplePatternFormatter>();
    }

    public static MeasureFormat getInstance(ULocale locale, FormatWidth formatWidth) {
        return MeasureFormat.getInstance(locale, formatWidth, NumberFormat.getInstance(locale));
    }

    public static MeasureFormat getInstance(Locale locale, FormatWidth formatWidth) {
        return MeasureFormat.getInstance(ULocale.forLocale(locale), formatWidth);
    }

    public static MeasureFormat getInstance(ULocale locale, FormatWidth formatWidth, NumberFormat format) {
        PluralRules rules = PluralRules.forLocale(locale);
        NumericFormatters formatters = null;
        MeasureFormatData data = localeMeasureFormatData.get(locale);
        if (data == null) {
            data = MeasureFormat.loadLocaleData(locale);
            localeMeasureFormatData.put(locale, data);
        }
        if (formatWidth == FormatWidth.NUMERIC && (formatters = localeToNumericDurationFormatters.get(locale)) == null) {
            formatters = MeasureFormat.loadNumericFormatters(locale);
            localeToNumericDurationFormatters.put(locale, formatters);
        }
        NumberFormat intFormat = NumberFormat.getInstance(locale);
        intFormat.setMaximumFractionDigits(0);
        intFormat.setMinimumFractionDigits(0);
        intFormat.setRoundingMode(1);
        return new MeasureFormat(locale, formatWidth, new ImmutableNumberFormat(format), rules, data.unitToStyleToCountToFormat, formatters, new ImmutableNumberFormat(NumberFormat.getInstance(locale, formatWidth.getCurrencyStyle())), new ImmutableNumberFormat(intFormat), data.unitToStyleToPerUnitPattern, data.styleToPerPattern);
    }

    public static MeasureFormat getInstance(Locale locale, FormatWidth formatWidth, NumberFormat format) {
        return MeasureFormat.getInstance(ULocale.forLocale(locale), formatWidth, format);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        int prevLength = toAppendTo.length();
        FieldPosition fpos = new FieldPosition(pos.getFieldAttribute(), pos.getField());
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            Measure[] measures = new Measure[coll.size()];
            int idx = 0;
            for (Object o : coll) {
                if (!(o instanceof Measure)) {
                    throw new IllegalArgumentException(obj.toString());
                }
                measures[idx++] = (Measure)o;
            }
            toAppendTo.append((CharSequence)this.formatMeasures(new StringBuilder(), fpos, measures));
        } else if (obj instanceof Measure[]) {
            toAppendTo.append((CharSequence)this.formatMeasures(new StringBuilder(), fpos, (Measure[])obj));
        } else if (obj instanceof Measure) {
            toAppendTo.append((CharSequence)this.formatMeasure((Measure)obj, this.numberFormat, new StringBuilder(), fpos));
        } else {
            throw new IllegalArgumentException(obj.toString());
        }
        if (fpos.getBeginIndex() != 0 || fpos.getEndIndex() != 0) {
            pos.setBeginIndex(fpos.getBeginIndex() + prevLength);
            pos.setEndIndex(fpos.getEndIndex() + prevLength);
        }
        return toAppendTo;
    }

    @Override
    public Measure parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    public final String formatMeasures(Measure ... measures) {
        return this.formatMeasures(new StringBuilder(), DontCareFieldPosition.INSTANCE, measures).toString();
    }

    @Deprecated
    public final String formatMeasureRange(Measure lowValue, Measure highValue) {
        MeasureUnit unit = lowValue.getUnit();
        if (!unit.equals(highValue.getUnit())) {
            throw new IllegalArgumentException("Units must match: " + unit + " \u2260 " + highValue.getUnit());
        }
        Number lowNumber = lowValue.getNumber();
        Number highNumber = highValue.getNumber();
        boolean isCurrency = unit instanceof Currency;
        UFieldPosition lowFpos = new UFieldPosition();
        UFieldPosition highFpos = new UFieldPosition();
        StringBuffer lowFormatted = null;
        StringBuffer highFormatted = null;
        if (isCurrency) {
            Currency currency = (Currency)unit;
            int fracDigits = currency.getDefaultFractionDigits();
            int maxFrac = this.numberFormat.nf.getMaximumFractionDigits();
            int minFrac = this.numberFormat.nf.getMinimumFractionDigits();
            if (fracDigits != maxFrac || fracDigits != minFrac) {
                DecimalFormat currentNumberFormat = (DecimalFormat)this.numberFormat.get();
                currentNumberFormat.setMaximumFractionDigits(fracDigits);
                currentNumberFormat.setMinimumFractionDigits(fracDigits);
                lowFormatted = currentNumberFormat.format(lowNumber, new StringBuffer(), (FieldPosition)lowFpos);
                highFormatted = currentNumberFormat.format(highNumber, new StringBuffer(), (FieldPosition)highFpos);
            }
        }
        if (lowFormatted == null) {
            lowFormatted = this.numberFormat.format(lowNumber, new StringBuffer(), (FieldPosition)lowFpos);
            highFormatted = this.numberFormat.format(highNumber, new StringBuffer(), (FieldPosition)highFpos);
        }
        double lowDouble = lowNumber.doubleValue();
        String keywordLow = this.rules.select(new PluralRules.FixedDecimal(lowDouble, lowFpos.getCountVisibleFractionDigits(), lowFpos.getFractionDigits()));
        double highDouble = highNumber.doubleValue();
        String keywordHigh = this.rules.select(new PluralRules.FixedDecimal(highDouble, highFpos.getCountVisibleFractionDigits(), highFpos.getFractionDigits()));
        PluralRanges pluralRanges = PluralRules.Factory.getDefaultFactory().getPluralRanges(this.getLocale());
        PluralRules.StandardPluralCategories resolvedCategory = pluralRanges.get(PluralRules.StandardPluralCategories.valueOf(keywordLow), PluralRules.StandardPluralCategories.valueOf(keywordHigh));
        SimplePatternFormatter rangeFormatter = MeasureFormat.getRangeFormat(this.getLocale(), this.formatWidth);
        String formattedNumber = rangeFormatter.format(lowFormatted, highFormatted);
        if (isCurrency) {
            this.currencyFormat.format(1.0);
            Currency currencyUnit = (Currency)unit;
            StringBuilder result = new StringBuilder();
            this.appendReplacingCurrency(this.currencyFormat.getPrefix(lowDouble >= 0.0), currencyUnit, resolvedCategory, result);
            result.append(formattedNumber);
            this.appendReplacingCurrency(this.currencyFormat.getSuffix(highDouble >= 0.0), currencyUnit, resolvedCategory, result);
            return result.toString();
        }
        Map styleToCountToFormat = this.unitToStyleToCountToFormat.get(lowValue.getUnit());
        QuantityFormatter countToFormat = (QuantityFormatter)styleToCountToFormat.get((Object)this.formatWidth);
        SimplePatternFormatter formatter = countToFormat.getByVariant(resolvedCategory.toString());
        return formatter.format(formattedNumber);
    }

    private void appendReplacingCurrency(String affix, Currency unit, PluralRules.StandardPluralCategories resolvedCategory, StringBuilder result) {
        String replacement = "\u00a4";
        int pos = affix.indexOf(replacement);
        if (pos < 0) {
            replacement = "XXX";
            pos = affix.indexOf(replacement);
        }
        if (pos < 0) {
            result.append(affix);
        } else {
            result.append(affix.substring(0, pos));
            int currentStyle = this.formatWidth.getCurrencyStyle();
            if (currentStyle == 5) {
                result.append(unit.getCurrencyCode());
            } else {
                result.append(unit.getName(this.currencyFormat.nf.getLocale(ULocale.ACTUAL_LOCALE), currentStyle == 1 ? 0 : 2, resolvedCategory.toString(), null));
            }
            result.append(affix.substring(pos + replacement.length()));
        }
    }

    @Deprecated
    public StringBuilder formatMeasuresPer(StringBuilder appendTo, FieldPosition fieldPosition, MeasureUnit perUnit, Measure ... measures) {
        FieldPosition fpos = new FieldPosition(fieldPosition.getFieldAttribute(), fieldPosition.getField());
        int offset = this.withPerUnit(this.formatMeasures(new StringBuilder(), fpos, measures), perUnit, appendTo);
        if (fpos.getBeginIndex() != 0 || fpos.getEndIndex() != 0) {
            fieldPosition.setBeginIndex(fpos.getBeginIndex() + offset);
            fieldPosition.setEndIndex(fpos.getEndIndex() + offset);
        }
        return appendTo;
    }

    public StringBuilder formatMeasures(StringBuilder appendTo, FieldPosition fieldPosition, Measure ... measures) {
        Number[] hms;
        if (measures.length == 0) {
            return appendTo;
        }
        if (measures.length == 1) {
            return this.formatMeasure(measures[0], this.numberFormat, appendTo, fieldPosition);
        }
        if (this.formatWidth == FormatWidth.NUMERIC && (hms = MeasureFormat.toHMS(measures)) != null) {
            return this.formatNumeric(hms, appendTo);
        }
        ListFormatter listFormatter = ListFormatter.getInstance(this.getLocale(), this.formatWidth.getListFormatterStyle());
        if (fieldPosition != DontCareFieldPosition.INSTANCE) {
            return this.formatMeasuresSlowTrack(listFormatter, appendTo, fieldPosition, measures);
        }
        Object[] results = new String[measures.length];
        int i = 0;
        while (i < measures.length) {
            results[i] = this.formatMeasure(measures[i], i == measures.length - 1 ? this.numberFormat : this.integerFormat);
            ++i;
        }
        return appendTo.append(listFormatter.format(results));
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MeasureFormat)) {
            return false;
        }
        MeasureFormat rhs = (MeasureFormat)other;
        return this.getWidth() == rhs.getWidth() && this.getLocale().equals(rhs.getLocale()) && this.getNumberFormat().equals(rhs.getNumberFormat());
    }

    public final int hashCode() {
        return (this.getLocale().hashCode() * 31 + this.getNumberFormat().hashCode()) * 31 + this.getWidth().hashCode();
    }

    public FormatWidth getWidth() {
        return this.formatWidth;
    }

    public final ULocale getLocale() {
        return this.getLocale(ULocale.VALID_LOCALE);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat.get();
    }

    public static MeasureFormat getCurrencyFormat(ULocale locale) {
        return new CurrencyFormat(locale);
    }

    public static MeasureFormat getCurrencyFormat(Locale locale) {
        return MeasureFormat.getCurrencyFormat(ULocale.forLocale(locale));
    }

    public static MeasureFormat getCurrencyFormat() {
        return MeasureFormat.getCurrencyFormat(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    MeasureFormat withLocale(ULocale locale) {
        return MeasureFormat.getInstance(locale, this.getWidth());
    }

    MeasureFormat withNumberFormat(NumberFormat format) {
        return new MeasureFormat(this.getLocale(), this.formatWidth, new ImmutableNumberFormat(format), this.rules, this.unitToStyleToCountToFormat, this.numericFormatters, this.currencyFormat, this.integerFormat, this.unitToStyleToPerUnitPattern, this.styleToPerPattern);
    }

    private MeasureFormat(ULocale locale, FormatWidth formatWidth, ImmutableNumberFormat format, PluralRules rules, Map<MeasureUnit, EnumMap<FormatWidth, QuantityFormatter>> unitToStyleToCountToFormat, NumericFormatters formatters, ImmutableNumberFormat currencyFormat, ImmutableNumberFormat integerFormat, Map<MeasureUnit, EnumMap<FormatWidth, SimplePatternFormatter>> unitToStyleToPerUnitPattern, EnumMap<FormatWidth, SimplePatternFormatter> styleToPerPattern) {
        this.setLocale(locale, locale);
        this.formatWidth = formatWidth;
        this.numberFormat = format;
        this.rules = rules;
        this.unitToStyleToCountToFormat = unitToStyleToCountToFormat;
        this.numericFormatters = formatters;
        this.currencyFormat = currencyFormat;
        this.integerFormat = integerFormat;
        this.unitToStyleToPerUnitPattern = unitToStyleToPerUnitPattern;
        this.styleToPerPattern = styleToPerPattern;
    }

    MeasureFormat() {
        this.formatWidth = null;
        this.numberFormat = null;
        this.rules = null;
        this.unitToStyleToCountToFormat = null;
        this.numericFormatters = null;
        this.currencyFormat = null;
        this.integerFormat = null;
        this.unitToStyleToPerUnitPattern = null;
        this.styleToPerPattern = null;
    }

    private static NumericFormatters loadNumericFormatters(ULocale locale) {
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt54b", locale);
        return new NumericFormatters(MeasureFormat.loadNumericDurationFormat(r, "hm"), MeasureFormat.loadNumericDurationFormat(r, "ms"), MeasureFormat.loadNumericDurationFormat(r, "hms"));
    }

    private static MeasureFormatData loadLocaleData(ULocale locale) {
        QuantityFormatter.Builder builder = new QuantityFormatter.Builder();
        HashMap<MeasureUnit, EnumMap<FormatWidth, QuantityFormatter>> unitToStyleToCountToFormat = new HashMap<MeasureUnit, EnumMap<FormatWidth, QuantityFormatter>>();
        HashMap<MeasureUnit, EnumMap<FormatWidth, SimplePatternFormatter>> unitToStyleToPerUnitPattern = new HashMap<MeasureUnit, EnumMap<FormatWidth, SimplePatternFormatter>>();
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt54b/unit", locale);
        EnumMap<FormatWidth, SimplePatternFormatter> styleToPerPattern = new EnumMap<FormatWidth, SimplePatternFormatter>(FormatWidth.class);
        FormatWidth[] formatWidthArray = FormatWidth.values();
        int n = formatWidthArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormatWidth styleItem = formatWidthArray[n2];
            try {
                ICUResourceBundle unitTypeRes = resource.getWithFallback(styleItem.resourceKey);
                ICUResourceBundle compoundRes = unitTypeRes.getWithFallback("compound");
                ICUResourceBundle perRes = compoundRes.getWithFallback("per");
                styleToPerPattern.put(styleItem, SimplePatternFormatter.compile(perRes.getString()));
            }
            catch (MissingResourceException missingResourceException) {}
            ++n2;
        }
        MeasureFormat.fillInStyleMap(styleToPerPattern);
        for (MeasureUnit unit : MeasureUnit.getAvailable()) {
            if (unit instanceof Currency) continue;
            EnumMap<FormatWidth, QuantityFormatter> styleToCountToFormat = (EnumMap<FormatWidth, QuantityFormatter>)unitToStyleToCountToFormat.get(unit);
            if (styleToCountToFormat == null) {
                styleToCountToFormat = new EnumMap<FormatWidth, QuantityFormatter>(FormatWidth.class);
                unitToStyleToCountToFormat.put(unit, styleToCountToFormat);
            }
            EnumMap<FormatWidth, SimplePatternFormatter> styleToPerUnitPattern = new EnumMap<FormatWidth, SimplePatternFormatter>(FormatWidth.class);
            unitToStyleToPerUnitPattern.put(unit, styleToPerUnitPattern);
            FormatWidth[] formatWidthArray2 = FormatWidth.values();
            int n3 = formatWidthArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                FormatWidth styleItem = formatWidthArray2[n4];
                try {
                    ICUResourceBundle unitTypeRes = resource.getWithFallback(styleItem.resourceKey);
                    ICUResourceBundle unitsRes = unitTypeRes.getWithFallback(unit.getType());
                    ICUResourceBundle oneUnitRes = unitsRes.getWithFallback(unit.getSubtype());
                    builder.reset();
                    boolean havePluralItem = false;
                    int len = oneUnitRes.getSize();
                    int i = 0;
                    while (i < len) {
                        block15: {
                            UResourceBundle countBundle;
                            try {
                                countBundle = oneUnitRes.get(i);
                            }
                            catch (MissingResourceException missingResourceException) {
                                break block15;
                            }
                            String resKey = countBundle.getKey();
                            if (!resKey.equals("dnam")) {
                                if (resKey.equals("per")) {
                                    styleToPerUnitPattern.put(styleItem, SimplePatternFormatter.compile(countBundle.getString()));
                                } else {
                                    havePluralItem = true;
                                    builder.add(resKey, countBundle.getString());
                                }
                            }
                        }
                        ++i;
                    }
                    if (havePluralItem) {
                        styleToCountToFormat.put(styleItem, builder.build());
                    }
                }
                catch (MissingResourceException missingResourceException) {}
                ++n4;
            }
            MeasureFormat.fillInStyleMap(styleToCountToFormat);
            MeasureFormat.fillInStyleMap(styleToPerUnitPattern);
        }
        return new MeasureFormatData(unitToStyleToCountToFormat, unitToStyleToPerUnitPattern, styleToPerPattern);
    }

    private static <T> boolean fillInStyleMap(Map<FormatWidth, T> styleMap) {
        if (styleMap.size() == FormatWidth.values().length) {
            return true;
        }
        T fallback = styleMap.get((Object)FormatWidth.SHORT);
        if (fallback == null) {
            fallback = styleMap.get((Object)FormatWidth.WIDE);
        }
        if (fallback == null) {
            return false;
        }
        FormatWidth[] formatWidthArray = FormatWidth.values();
        int n = formatWidthArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormatWidth styleItem = formatWidthArray[n2];
            T item = styleMap.get((Object)styleItem);
            if (item == null) {
                styleMap.put(styleItem, fallback);
            }
            ++n2;
        }
        return true;
    }

    private int withPerUnit(CharSequence formatted, MeasureUnit perUnit, StringBuilder appendTo) {
        int[] offsets = new int[1];
        Map styleToPerUnitPattern = this.unitToStyleToPerUnitPattern.get(perUnit);
        SimplePatternFormatter perUnitPattern = (SimplePatternFormatter)styleToPerUnitPattern.get((Object)this.formatWidth);
        if (perUnitPattern != null) {
            perUnitPattern.format(appendTo, offsets, formatted);
            return offsets[0];
        }
        SimplePatternFormatter perPattern = this.styleToPerPattern.get((Object)this.formatWidth);
        Map styleToCountToFormat = this.unitToStyleToCountToFormat.get(perUnit);
        QuantityFormatter countToFormat = (QuantityFormatter)styleToCountToFormat.get((Object)this.formatWidth);
        String perUnitString = countToFormat.getByVariant("one").getPatternWithNoPlaceholders().trim();
        perPattern.format(appendTo, offsets, formatted, perUnitString);
        return offsets[0];
    }

    private String formatMeasure(Measure measure, ImmutableNumberFormat nf) {
        return this.formatMeasure(measure, nf, new StringBuilder(), DontCareFieldPosition.INSTANCE).toString();
    }

    private StringBuilder formatMeasure(Measure measure, ImmutableNumberFormat nf, StringBuilder appendTo, FieldPosition fieldPosition) {
        if (measure.getUnit() instanceof Currency) {
            return appendTo.append(this.currencyFormat.format(new CurrencyAmount(measure.getNumber(), (Currency)measure.getUnit()), new StringBuffer(), fieldPosition));
        }
        Number n = measure.getNumber();
        MeasureUnit unit = measure.getUnit();
        UFieldPosition fpos = new UFieldPosition(fieldPosition.getFieldAttribute(), fieldPosition.getField());
        StringBuffer formattedNumber = nf.format(n, new StringBuffer(), (FieldPosition)fpos);
        String keyword = this.rules.select(new PluralRules.FixedDecimal(n.doubleValue(), fpos.getCountVisibleFractionDigits(), fpos.getFractionDigits()));
        Map styleToCountToFormat = this.unitToStyleToCountToFormat.get(unit);
        QuantityFormatter countToFormat = (QuantityFormatter)styleToCountToFormat.get((Object)this.formatWidth);
        SimplePatternFormatter formatter = countToFormat.getByVariant(keyword);
        int[] offsets = new int[1];
        formatter.format(appendTo, offsets, formattedNumber);
        if (offsets[0] != -1 && (fpos.getBeginIndex() != 0 || fpos.getEndIndex() != 0)) {
            fieldPosition.setBeginIndex(fpos.getBeginIndex() + offsets[0]);
            fieldPosition.setEndIndex(fpos.getEndIndex() + offsets[0]);
        }
        return appendTo;
    }

    Object toTimeUnitProxy() {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.numberFormat.get(), 1);
    }

    Object toCurrencyProxy() {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.numberFormat.get(), 2);
    }

    private StringBuilder formatMeasuresSlowTrack(ListFormatter listFormatter, StringBuilder appendTo, FieldPosition fieldPosition, Measure ... measures) {
        String[] results = new String[measures.length];
        FieldPosition fpos = new FieldPosition(fieldPosition.getFieldAttribute(), fieldPosition.getField());
        int fieldPositionFoundIndex = -1;
        int i = 0;
        while (i < measures.length) {
            ImmutableNumberFormat nf;
            ImmutableNumberFormat immutableNumberFormat = nf = i == measures.length - 1 ? this.numberFormat : this.integerFormat;
            if (fieldPositionFoundIndex == -1) {
                results[i] = this.formatMeasure(measures[i], nf, new StringBuilder(), fpos).toString();
                if (fpos.getBeginIndex() != 0 || fpos.getEndIndex() != 0) {
                    fieldPositionFoundIndex = i;
                }
            } else {
                results[i] = this.formatMeasure(measures[i], nf);
            }
            ++i;
        }
        ListFormatter.FormattedListBuilder builder = listFormatter.format(Arrays.asList(results), fieldPositionFoundIndex);
        if (builder.getOffset() != -1) {
            fieldPosition.setBeginIndex(fpos.getBeginIndex() + builder.getOffset() + appendTo.length());
            fieldPosition.setEndIndex(fpos.getEndIndex() + builder.getOffset() + appendTo.length());
        }
        return appendTo.append(builder.toString());
    }

    private static DateFormat loadNumericDurationFormat(ICUResourceBundle r, String type) {
        r = r.getWithFallback(String.format("durationUnits/%s", type));
        SimpleDateFormat result = new SimpleDateFormat(r.getString().replace("h", "H"));
        result.setTimeZone(TimeZone.GMT_ZONE);
        return result;
    }

    private static Number[] toHMS(Measure[] measures) {
        Number[] result = new Number[3];
        int lastIdx = -1;
        Measure[] measureArray = measures;
        int n = measures.length;
        int n2 = 0;
        while (n2 < n) {
            Measure m = measureArray[n2];
            if (m.getNumber().doubleValue() < 0.0) {
                return null;
            }
            Integer idxObj = hmsTo012.get(m.getUnit());
            if (idxObj == null) {
                return null;
            }
            int idx = idxObj;
            if (idx <= lastIdx) {
                return null;
            }
            lastIdx = idx;
            result[idx] = m.getNumber();
            ++n2;
        }
        return result;
    }

    private StringBuilder formatNumeric(Number[] hms, StringBuilder appendable) {
        int startIndex = -1;
        int endIndex = -1;
        int i = 0;
        while (i < hms.length) {
            if (hms[i] != null) {
                endIndex = i;
                if (startIndex == -1) {
                    startIndex = endIndex;
                }
            } else {
                hms[i] = 0;
            }
            ++i;
        }
        long millis = (long)(((Math.floor(hms[0].doubleValue()) * 60.0 + Math.floor(hms[1].doubleValue())) * 60.0 + Math.floor(hms[2].doubleValue())) * 1000.0);
        Date d = new Date(millis);
        if (startIndex == 0 && endIndex == 2) {
            return this.formatNumeric(d, this.numericFormatters.getHourMinuteSecond(), DateFormat.Field.SECOND, hms[endIndex], appendable);
        }
        if (startIndex == 1 && endIndex == 2) {
            return this.formatNumeric(d, this.numericFormatters.getMinuteSecond(), DateFormat.Field.SECOND, hms[endIndex], appendable);
        }
        if (startIndex == 0 && endIndex == 1) {
            return this.formatNumeric(d, this.numericFormatters.getHourMinute(), DateFormat.Field.MINUTE, hms[endIndex], appendable);
        }
        throw new IllegalStateException();
    }

    private StringBuilder formatNumeric(Date duration, DateFormat formatter, DateFormat.Field smallestField, Number smallestAmount, StringBuilder appendTo) {
        FieldPosition intFieldPosition = new FieldPosition(0);
        String smallestAmountFormatted = this.numberFormat.format(smallestAmount, new StringBuffer(), intFieldPosition).toString();
        if (intFieldPosition.getBeginIndex() == 0 && intFieldPosition.getEndIndex() == 0) {
            throw new IllegalStateException();
        }
        FieldPosition smallestFieldPosition = new FieldPosition(smallestField);
        String draft = formatter.format(duration, new StringBuffer(), smallestFieldPosition).toString();
        if (smallestFieldPosition.getBeginIndex() != 0 || smallestFieldPosition.getEndIndex() != 0) {
            appendTo.append(draft, 0, smallestFieldPosition.getBeginIndex());
            appendTo.append(smallestAmountFormatted, 0, intFieldPosition.getBeginIndex());
            appendTo.append(draft, smallestFieldPosition.getBeginIndex(), smallestFieldPosition.getEndIndex());
            appendTo.append(smallestAmountFormatted, intFieldPosition.getEndIndex(), smallestAmountFormatted.length());
            appendTo.append(draft, smallestFieldPosition.getEndIndex(), draft.length());
        } else {
            appendTo.append(draft);
        }
        return appendTo;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.numberFormat.get(), 0);
    }

    private static FormatWidth fromFormatWidthOrdinal(int ordinal) {
        FormatWidth[] values = FormatWidth.values();
        if (ordinal < 0 || ordinal >= values.length) {
            return FormatWidth.WIDE;
        }
        return values[ordinal];
    }

    @Deprecated
    public static SimplePatternFormatter getRangeFormat(ULocale forLocale, FormatWidth width) {
        if (forLocale.getLanguage().equals("fr")) {
            return MeasureFormat.getRangeFormat(ULocale.ROOT, width);
        }
        SimplePatternFormatter result = localeIdToRangeFormat.get(forLocale);
        if (result == null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt54b", forLocale);
            ULocale realLocale = rb.getULocale();
            if (!forLocale.equals(realLocale) && (result = localeIdToRangeFormat.get(forLocale)) != null) {
                localeIdToRangeFormat.put(forLocale, result);
                return result;
            }
            NumberingSystem ns = NumberingSystem.getInstance(forLocale);
            String resultString = null;
            try {
                resultString = rb.getStringWithFallback("NumberElements/" + ns.getName() + "/miscPatterns/range");
            }
            catch (MissingResourceException missingResourceException) {
                resultString = rb.getStringWithFallback("NumberElements/latn/patterns/range");
            }
            result = SimplePatternFormatter.compile(resultString);
            localeIdToRangeFormat.put(forLocale, result);
            if (!forLocale.equals(realLocale)) {
                localeIdToRangeFormat.put(realLocale, result);
            }
        }
        return result;
    }

    @Deprecated
    public static String getRangePattern(ULocale forLocale, FormatWidth width) {
        return MeasureFormat.getRangeFormat(forLocale, width).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormatWidth {
        WIDE("units", ListFormatter.Style.DURATION, 6),
        SHORT("unitsShort", ListFormatter.Style.DURATION_SHORT, 5),
        NARROW("unitsNarrow", ListFormatter.Style.DURATION_NARROW, 1),
        NUMERIC("unitsNarrow", ListFormatter.Style.DURATION_NARROW, 1);

        final String resourceKey;
        private final ListFormatter.Style listFormatterStyle;
        private final int currencyStyle;

        private FormatWidth(String resourceKey, ListFormatter.Style style, int currencyStyle) {
            this.resourceKey = resourceKey;
            this.listFormatterStyle = style;
            this.currencyStyle = currencyStyle;
        }

        ListFormatter.Style getListFormatterStyle() {
            return this.listFormatterStyle;
        }

        int getCurrencyStyle() {
            return this.currencyStyle;
        }
    }

    private static final class ImmutableNumberFormat {
        private NumberFormat nf;

        public ImmutableNumberFormat(NumberFormat nf) {
            this.nf = (NumberFormat)nf.clone();
        }

        public synchronized NumberFormat get() {
            return (NumberFormat)this.nf.clone();
        }

        public synchronized StringBuffer format(Number n, StringBuffer buffer, FieldPosition pos) {
            return this.nf.format(n, buffer, pos);
        }

        public synchronized StringBuffer format(CurrencyAmount n, StringBuffer buffer, FieldPosition pos) {
            return this.nf.format(n, buffer, pos);
        }

        public synchronized String format(Number number) {
            return this.nf.format(number);
        }

        public String getPrefix(boolean positive) {
            return positive ? ((DecimalFormat)this.nf).getPositivePrefix() : ((DecimalFormat)this.nf).getNegativePrefix();
        }

        public String getSuffix(boolean positive) {
            return positive ? ((DecimalFormat)this.nf).getPositiveSuffix() : ((DecimalFormat)this.nf).getPositiveSuffix();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MeasureFormatData {
        final Map<MeasureUnit, EnumMap<FormatWidth, QuantityFormatter>> unitToStyleToCountToFormat;
        final Map<MeasureUnit, EnumMap<FormatWidth, SimplePatternFormatter>> unitToStyleToPerUnitPattern;
        final EnumMap<FormatWidth, SimplePatternFormatter> styleToPerPattern;

        MeasureFormatData(Map<MeasureUnit, EnumMap<FormatWidth, QuantityFormatter>> unitToStyleToCountToFormat, Map<MeasureUnit, EnumMap<FormatWidth, SimplePatternFormatter>> unitToStyleToPerUnitPattern, EnumMap<FormatWidth, SimplePatternFormatter> styleToPerPattern) {
            this.unitToStyleToCountToFormat = unitToStyleToCountToFormat;
            this.unitToStyleToPerUnitPattern = unitToStyleToPerUnitPattern;
            this.styleToPerPattern = styleToPerPattern;
        }
    }

    static class MeasureProxy
    implements Externalizable {
        private static final long serialVersionUID = -6033308329886716770L;
        private ULocale locale;
        private FormatWidth formatWidth;
        private NumberFormat numberFormat;
        private int subClass;
        private HashMap<Object, Object> keyValues;

        public MeasureProxy(ULocale locale, FormatWidth width, NumberFormat numberFormat, int subClass) {
            this.locale = locale;
            this.formatWidth = width;
            this.numberFormat = numberFormat;
            this.subClass = subClass;
            this.keyValues = new HashMap();
        }

        public MeasureProxy() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(0);
            out.writeUTF(this.locale.toLanguageTag());
            out.writeByte(this.formatWidth.ordinal());
            out.writeObject(this.numberFormat);
            out.writeByte(this.subClass);
            out.writeObject(this.keyValues);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            in.readByte();
            this.locale = ULocale.forLanguageTag(in.readUTF());
            this.formatWidth = MeasureFormat.fromFormatWidthOrdinal(in.readByte() & 0xFF);
            this.numberFormat = (NumberFormat)in.readObject();
            if (this.numberFormat == null) {
                throw new InvalidObjectException("Missing number format.");
            }
            this.subClass = in.readByte() & 0xFF;
            this.keyValues = (HashMap)in.readObject();
            if (this.keyValues == null) {
                throw new InvalidObjectException("Missing optional values map.");
            }
        }

        private TimeUnitFormat createTimeUnitFormat() throws InvalidObjectException {
            int style;
            if (this.formatWidth == FormatWidth.WIDE) {
                style = 0;
            } else if (this.formatWidth == FormatWidth.SHORT) {
                style = 1;
            } else {
                throw new InvalidObjectException("Bad width: " + (Object)((Object)this.formatWidth));
            }
            TimeUnitFormat result = new TimeUnitFormat(this.locale, style);
            result.setNumberFormat(this.numberFormat);
            return result;
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.subClass) {
                case 0: {
                    return MeasureFormat.getInstance(this.locale, this.formatWidth, this.numberFormat);
                }
                case 1: {
                    return this.createTimeUnitFormat();
                }
                case 2: {
                    return new CurrencyFormat(this.locale);
                }
            }
            throw new InvalidObjectException("Unknown subclass: " + this.subClass);
        }
    }

    static class NumericFormatters {
        private DateFormat hourMinute;
        private DateFormat minuteSecond;
        private DateFormat hourMinuteSecond;

        public NumericFormatters(DateFormat hourMinute, DateFormat minuteSecond, DateFormat hourMinuteSecond) {
            this.hourMinute = hourMinute;
            this.minuteSecond = minuteSecond;
            this.hourMinuteSecond = hourMinuteSecond;
        }

        public DateFormat getHourMinute() {
            return this.hourMinute;
        }

        public DateFormat getMinuteSecond() {
            return this.minuteSecond;
        }

        public DateFormat getHourMinuteSecond() {
            return this.hourMinuteSecond;
        }
    }

    static final class PatternData {
        final String prefix;
        final String suffix;

        public PatternData(String pattern) {
            int pos = pattern.indexOf("{0}");
            if (pos < 0) {
                this.prefix = pattern;
                this.suffix = null;
            } else {
                this.prefix = pattern.substring(0, pos);
                this.suffix = pattern.substring(pos + 3);
            }
        }

        public String toString() {
            return String.valueOf(this.prefix) + "; " + this.suffix;
        }
    }
}

