/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class RepositoryActionHandler
extends AbstractHandler {
    private IEvaluationContext evaluationContext;
    private IStructuredSelection mySelection;

    RepositoryActionHandler() {
    }

    public void setSelection(ISelection selection) {
        this.mySelection = SelectionUtils.getStructuredSelection(selection);
    }

    private IProject[] getProjectsForSelectedResources(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        IResource[] iResourceArray = (IResource[])this.getSelectedAdaptables((ISelection)selection, IResource.class);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping == null || !(mapping.getContainer() instanceof IProject)) {
                return new IProject[0];
            }
            ret.add((IProject)mapping.getContainer());
            ++n2;
        }
        ret.addAll(this.extractProjectsFromMappings(selection));
        return ret.toArray(new IProject[ret.size()]);
    }

    private Set<IProject> extractProjectsFromMappings(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        ResourceMapping[] resourceMappingArray = (ResourceMapping[])this.getSelectedAdaptables((ISelection)selection, ResourceMapping.class);
        int n = resourceMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            IProject[] mappedProjects = mapping.getProjects();
            if (mappedProjects != null && mappedProjects.length != 0) {
                ArrayList<IProject> projects = new ArrayList<IProject>(Arrays.asList(mappedProjects));
                Collections.sort(projects, CommonUtils.RESOURCE_NAME_COMPARATOR);
                ret.addAll(projects);
            }
            ++n2;
        }
        return ret;
    }

    protected IProject[] getProjectsForSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return this.getProjectsForSelectedResources(selection);
    }

    protected IProject[] getProjectsForSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getProjectsForSelectedResources(selection);
    }

    protected Repository[] getRepositoriesFor(IProject[] projects) {
        LinkedHashSet<Repository> ret = new LinkedHashSet<Repository>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IProject)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
            ++n2;
        }
        return ret.toArray(new Repository[ret.size()]);
    }

    protected IProject[] getProjectsInRepositoryOfSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getProjectsInRepositoryOfSelectedResources(selection);
    }

    private IProject[] getProjectsInRepositoryOfSelectedResources(IStructuredSelection selection) {
        IProject[] projects;
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        Repository[] repositories = this.getRepositoriesFor(this.getProjectsForSelectedResources(selection));
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)project);
            Repository[] repositoryArray = repositories;
            int n3 = repositories.length;
            int n4 = 0;
            while (n4 < n3) {
                Repository repository = repositoryArray[n4];
                if (mapping != null && mapping.getRepository() == repository) {
                    ret.add(project);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    protected Repository getRepository(boolean warn, ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        if (warn) {
            Shell shell = this.getShell(event);
            return SelectionUtils.getRepositoryOrWarn(selection, shell);
        }
        return SelectionUtils.getRepository(selection);
    }

    protected Repository getRepository() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getRepository(selection);
    }

    protected Repository[] getRepositories(ExecutionEvent event) throws ExecutionException {
        IProject[] selectedProjects = this.getProjectsForSelectedResources(event);
        if (selectedProjects.length > 0) {
            return this.getRepositoriesFor(selectedProjects);
        }
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        if (!selection.isEmpty()) {
            LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository repo;
                Object o = objectArray[n2];
                if (o instanceof Repository) {
                    repos.add((Repository)o);
                } else if (o instanceof PlatformObject && (repo = CommonUtils.getAdapter((IAdaptable)((PlatformObject)o), Repository.class)) != null) {
                    repos.add(repo);
                }
                ++n2;
            }
            return repos.toArray(new Repository[repos.size()]);
        }
        return new Repository[0];
    }

    protected Repository[] getRepositories() {
        IProject[] selectedProjects = this.getProjectsForSelectedResources();
        if (selectedProjects.length > 0) {
            return this.getRepositoriesFor(selectedProjects);
        }
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository repo;
                Object o = objectArray[n2];
                if (o instanceof Repository) {
                    repos.add((Repository)o);
                } else if (o instanceof PlatformObject && (repo = CommonUtils.getAdapter((IAdaptable)((PlatformObject)o), Repository.class)) != null) {
                    repos.add(repo);
                }
                ++n2;
            }
            return repos.toArray(new Repository[repos.size()]);
        }
        return new Repository[0];
    }

    protected static IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        if (event == null) {
            throw new IllegalArgumentException("event must not be NULL");
        }
        Object context = event.getApplicationContext();
        if (context instanceof IEvaluationContext) {
            return SelectionUtils.getSelection((IEvaluationContext)context);
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getSelection() {
        if (this.mySelection != null) {
            return this.mySelection;
        }
        return SelectionUtils.getSelection(this.evaluationContext);
    }

    public void setEnabled(Object evaluationContext) {
        this.evaluationContext = (IEvaluationContext)evaluationContext;
    }

    private Object[] getSelectedAdaptables(ISelection selection, Class c) {
        ArrayList<Object> result = null;
        if (selection != null && !selection.isEmpty()) {
            result = new ArrayList<Object>();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = AdapterUtils.adapt(elements.next(), (Class)c);
                if (!c.isInstance(adapter)) continue;
                result.add(adapter);
            }
        }
        if (result != null && !result.isEmpty()) {
            return result.toArray((Object[])Array.newInstance(c, result.size()));
        }
        return (Object[])Array.newInstance(c, 0);
    }

    protected IResource[] getSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getSelectedResources(selection);
    }

    protected IPath[] getSelectedLocations(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getSelectedLocations(selection);
    }

    protected IResource[] getSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getSelectedResources(selection);
    }

    protected IPath[] getSelectedLocations() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getSelectedLocations(selection);
    }

    protected boolean selectionMapsToSingleRepository() {
        return this.getRepository() != null;
    }

    protected Shell getShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    protected IWorkbenchPage getPartPage(ExecutionEvent event) throws ExecutionException {
        return this.getPart(event).getSite().getPage();
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    protected boolean containsHead(Repository repository) {
        try {
            return repository != null ? repository.resolve("HEAD") != null : false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isLocalBranchCheckedout(Repository repository) {
        try {
            return repository.getFullBranch().startsWith("refs/heads/");
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getPreviousPath(Repository repository, ObjectReader reader, RevCommit headCommit, RevCommit previousCommit, String path) throws IOException {
        DiffEntry diffEntry = CompareCoreUtils.getChangeDiffEntry((Repository)repository, (String)path, (RevCommit)headCommit, (RevCommit)previousCommit, (ObjectReader)reader);
        if (diffEntry != null) {
            return diffEntry.getOldPath();
        }
        return path;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<PreviousCommit> findPreviousCommits() throws IOException {
        ArrayList<PreviousCommit> result = new ArrayList<PreviousCommit>();
        Repository repository = this.getRepository();
        IResource resource = this.getSelectedResources()[0];
        String path = RepositoryMapping.getMapping((IProject)resource.getProject()).getRepoRelativePath(resource);
        RevWalk rw = new RevWalk(repository);
        rw.sort(RevSort.COMMIT_TIME_DESC, true);
        rw.sort(RevSort.BOUNDARY, true);
        try {
            block10: {
                RevCommit previousCommit;
                List<RevCommit> directParents;
                RevCommit headCommit;
                block9: {
                    if (path.length() > 0) {
                        DiffConfig diffConfig = (DiffConfig)repository.getConfig().get(DiffConfig.KEY);
                        FollowFilter filter = FollowFilter.create((String)path, (DiffConfig)diffConfig);
                        rw.setTreeFilter((TreeFilter)filter);
                    }
                    headCommit = rw.parseCommit((AnyObjectId)repository.getRef("HEAD").getObjectId());
                    rw.markStart(headCommit);
                    headCommit = rw.next();
                    if (headCommit == null) {
                        ArrayList<PreviousCommit> arrayList = result;
                        return arrayList;
                    }
                    directParents = Arrays.asList(headCommit.getParents());
                    previousCommit = rw.next();
                    if (!true) break block9;
                    if (previousCommit == null) return result;
                    if (result.size() >= directParents.size()) break block10;
                }
                do {
                    if (directParents.contains(previousCommit)) {
                        String previousPath = this.getPreviousPath(repository, rw.getObjectReader(), headCommit, previousCommit, path);
                        result.add(new PreviousCommit(previousCommit, previousPath));
                    }
                    previousCommit = rw.next();
                    if (previousCommit == null) return result;
                } while (result.size() < directParents.size());
            }
            return result;
        }
        finally {
            rw.dispose();
        }
    }

    public boolean isEnabled() {
        return this.getProjectsForSelectedResources().length > 0;
    }

    protected static final class PreviousCommit {
        final RevCommit commit;
        final String path;

        PreviousCommit(RevCommit commit, String path) {
            this.commit = commit;
            this.path = path;
        }
    }
}

