/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public class SynchronizeWorkspaceActionHandler
extends RepositoryActionHandler {
    @Override
    public boolean isEnabled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] resources = this.getSelectedResources(event);
        Map<Repository, Set<IResource>> containerMap = this.mapContainerResources(resources);
        if (containerMap.isEmpty()) {
            return null;
        }
        boolean launchFetch = Activator.getDefault().getPreferenceStore().getBoolean("sync_view_fetch_before_launch");
        GitSynchronizeDataSet gsdSet = new GitSynchronizeDataSet();
        for (Map.Entry<Repository, Set<IResource>> entry : containerMap.entrySet()) {
            try {
                Repository repo = entry.getKey();
                String dstRef = this.getDstRef(repo, launchFetch);
                GitSynchronizeData data = new GitSynchronizeData(repo, "HEAD", dstRef, true);
                Set<IResource> containers = entry.getValue();
                if (!containers.isEmpty()) {
                    data.setIncludedResources(containers);
                }
                gsdSet.add(data);
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        GitModelSynchronize.launch(gsdSet, this.getSelectedResources(event));
        return null;
    }

    private Map<Repository, Set<IResource>> mapContainerResources(IResource[] resources) {
        HashMap<Repository, Set<IResource>> result = new HashMap<Repository, Set<IResource>>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping rm = RepositoryMapping.getMapping((IResource)resource);
            if (rm != null) {
                if (resource instanceof IProject) {
                    result.put(rm.getRepository(), new HashSet());
                } else if (resource instanceof IContainer) {
                    HashSet<IResource> containers = (HashSet<IResource>)result.get(rm.getRepository());
                    if (containers == null) {
                        containers = new HashSet<IResource>();
                        result.put(rm.getRepository(), containers);
                        containers.add(resource);
                    } else if (containers.size() > 0) {
                        containers.add(resource);
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    private String getDstRef(Repository repo, boolean launchFetch) {
        if (launchFetch) {
            String realName = this.getRealBranchName(repo);
            String name = GitSynchronizeData.BRANCH_NAME_PATTERN.matcher(realName).replaceAll("");
            StoredConfig config = repo.getConfig();
            String remote = config.getString("branch", name, "remote");
            String merge = config.getString("branch", name, "merge");
            if (remote == null || merge == null) {
                return "HEAD";
            }
            String mergeBranchName = merge.replace("refs/heads/", "");
            return "refs/remotes/" + remote + "/" + mergeBranchName;
        }
        return "HEAD";
    }

    private String getRealBranchName(Repository repo) {
        Ref ref;
        try {
            ref = repo.getRef("HEAD");
        }
        catch (IOException iOException) {
            ref = null;
        }
        if (ref != null && ref.isSymbolic()) {
            return ref.getTarget().getName();
        }
        return "HEAD";
    }
}

