/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class LaunchConfigurationComparator
extends WorkbenchViewerComparator {
    private static Map<ILaunchConfigurationType, Integer> fgCategories;

    public int category(Object element) {
        Map<ILaunchConfigurationType, Integer> map = this.getCategories();
        if (element instanceof ILaunchConfiguration) {
            ILaunchConfiguration configuration = (ILaunchConfiguration)element;
            try {
                Integer i = map.get(configuration.getType());
                if (i != null) {
                    return i;
                }
            }
            catch (CoreException coreException) {}
        }
        return map.size();
    }

    private Map<ILaunchConfigurationType, Integer> getCategories() {
        if (fgCategories == null) {
            fgCategories = new HashMap<ILaunchConfigurationType, Integer>();
            List<ILaunchConfigurationType> types = Arrays.asList(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes());
            Collections.sort(types, new Comparator<ILaunchConfigurationType>(){

                @Override
                public int compare(ILaunchConfigurationType o1, ILaunchConfigurationType o2) {
                    ILaunchConfigurationType t1 = o1;
                    ILaunchConfigurationType t2 = o2;
                    return t1.getName().compareTo(t2.getName());
                }
            });
            Iterator<ILaunchConfigurationType> iterator = types.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                fgCategories.put(iterator.next(), new Integer(i));
                ++i;
            }
        }
        return fgCategories;
    }
}

