/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.ReferenceExpression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class MenuItemRenderer
extends SWTPartRenderer {
    private HashMap<MMenuItem, Expression> menuItemToExpression = new HashMap();
    private HashMap<MMenuItem, VisibleRAT> menuItemToRAT = new HashMap();
    @Inject
    Logger logger;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            MenuItem menuItem = (MenuItem)itemModel.getWidget();
            if (menuItem == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName) || "localizedLabel".equals(attName)) {
                MenuItemRenderer.this.setItemText(itemModel, menuItem);
            } else if ("iconURI".equals(attName)) {
                menuItem.setImage(MenuItemRenderer.this.getImage((MUILabel)itemModel));
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            MenuItem menuItem = (MenuItem)itemModel.getWidget();
            if (menuItem != null) {
                menuItem.setSelection(itemModel.isSelected());
            }
        }
    };
    private EventHandler enabledUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            MenuItem menuItem = (MenuItem)itemModel.getWidget();
            if (menuItem != null) {
                menuItem.setEnabled(itemModel.isEnabled());
            }
        }
    };

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.itemUpdater);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/menu/Item/selected/*", this.selectionUpdater);
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/menu/Item/enabled/*", this.enabledUpdater);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
        this.eventBroker.unsubscribe(this.enabledUpdater);
    }

    protected void processVisible(MMenuItem item) {
        if (this.menuItemToExpression.get(item) != null) {
            return;
        }
        MCoreExpression exp = (MCoreExpression)item.getVisibleWhen();
        Expression ref = null;
        if (exp.getCoreExpression() instanceof Expression) {
            ref = (Expression)exp.getCoreExpression();
        } else {
            ref = new ReferenceExpression(exp.getCoreExpressionId());
            exp.setCoreExpression((Object)ref);
        }
        this.menuItemToExpression.put(item, ref);
        IEclipseContext itemContext = this.getContext((MUIElement)item);
        VisibleRAT rat = new VisibleRAT(item, ref, itemContext);
        this.menuItemToRAT.put(item, rat);
        itemContext.runAndTrack((RunAndTrack)rat);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
        this.menuItemToExpression.remove(child);
        VisibleRAT rat = this.menuItemToRAT.remove(child);
        if (rat != null) {
            rat.participating = false;
        }
    }

    protected void setItemText(MMenuItem model, MenuItem item) {
        String text = model.getLocalizedLabel();
        if (text == null) {
            text = "";
        }
        item.setText(text);
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        MItem item;
        if (me instanceof MItem && ((item = (MItem)me).getType() == ItemType.CHECK || item.getType() == ItemType.RADIO)) {
            MenuItem ti = (MenuItem)me.getWidget();
            ti.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    item.setSelected(((MenuItem)e.widget).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    item.setSelected(((MenuItem)e.widget).getSelection());
                }
            });
        }
    }

    static class VisibleRAT
    extends RunAndTrack {
        Expression exp;
        MMenuItem item;
        ExpressionContext ec;
        boolean participating = true;

        public VisibleRAT(MMenuItem i, Expression e, IEclipseContext c) {
            this.exp = e;
            this.item = i;
            this.ec = new ExpressionContext(c);
        }

        public boolean changed(IEclipseContext context) {
            try {
                this.item.setVisible(EvaluationResult.FALSE != this.exp.evaluate((IEvaluationContext)this.ec));
            }
            catch (CoreException e) {
                this.item.setVisible(false);
                WorkbenchSWTActivator.trace((String)"/trace/menus", (String)"VisibleRAT failed", (Throwable)e);
            }
            return this.participating;
        }
    }
}

