/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring.preferences;

import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.internal.monitoring.preferences.FilterInputDialog;

public class FilterListEditor
extends ListEditor {
    private String dialogMessage;

    FilterListEditor(String name, String label, String addButtonLabel, String removeButtonLabel, String dialogMessage, Composite parent) {
        super(name, label, parent);
        this.dialogMessage = dialogMessage;
        this.setButtonLabel(this.getAddButton(), addButtonLabel);
        this.setButtonLabel(this.getRemoveButton(), removeButtonLabel);
        this.getUpButton().setVisible(false);
        this.getDownButton().setVisible(false);
    }

    private void setButtonLabel(Button button, String label) {
        button.setText(label);
        GridDataFactory.fillDefaults().applyTo((Control)button);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        List list = this.getListControl(parent);
        GridDataFactory.defaultsFor((Control)list).applyTo((Control)list);
        GridDataFactory.fillDefaults().applyTo((Control)this.getButtonBoxControl(parent));
    }

    protected String createList(String[] items) {
        StringBuilder mergedItems = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            item.trim();
            if (mergedItems.length() != 0) {
                mergedItems.append(',');
            }
            mergedItems.append(item);
            ++n2;
        }
        return mergedItems.toString();
    }

    protected String getNewInputObject() {
        FilterInputDialog dialog = new FilterInputDialog(this.getShell(), this.dialogMessage);
        if (dialog.open() == 0) {
            String filter = dialog.getFilter();
            List list = this.getList();
            if (list.getItemCount() != 0) {
                int pos = Arrays.binarySearch(list.getItems(), filter);
                if (pos >= 0) {
                    return null;
                }
                list.setSelection(-pos - 2);
            }
            return filter;
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        if (stringList.isEmpty()) {
            return new String[0];
        }
        Object[] items = stringList.split(",");
        Arrays.sort(items);
        return items;
    }

    protected void refreshValidState() {
        this.selectionChanged();
    }
}

