/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.Supplementer;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.equinox.weaving.aspectj.AspectConfiguration;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectResolver {
    private final AspectAdmin aspectAdmin;
    private final State state;
    private final ISupplementerRegistry supplementerRegistry;
    private final BundleContext weavingBundleContext;

    public AspectResolver(State state, ISupplementerRegistry iSupplementerRegistry, AspectAdmin aspectAdmin, BundleContext bundleContext) {
        this.state = state;
        this.supplementerRegistry = iSupplementerRegistry;
        this.aspectAdmin = aspectAdmin;
        this.weavingBundleContext = bundleContext;
    }

    public AspectConfiguration resolveAspectsFor(Bundle bundle, BundleDescription bundleDescription) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Definition> list = this.resolveAspectsForBundle(arrayList, bundle, bundleDescription);
        Definition[] definitionArray = list.toArray(new Definition[list.size()]);
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        return new AspectConfiguration(bundle, definitionArray, stringBuilder.toString());
    }

    private int getApplyAspectsPolicy(ManifestElement[] manifestElementArray, String string) {
        int n = 0;
        if (manifestElementArray != null) {
            int n2 = 0;
            while (n2 < manifestElementArray.length) {
                if (manifestElementArray[n2].getValue().equals(string)) {
                    String string2 = manifestElementArray[n2].getDirective("apply-aspects");
                    if ("true".equals(string2)) {
                        n = 1;
                    } else if ("false".equals(string2)) {
                        n = 2;
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    private String getBundleVersion(Bundle bundle) {
        return this.state.getBundle(bundle.getBundleId()).getVersion().toString();
    }

    private List<Definition> resolveAspectsForBundle(List<String> list, Bundle bundle, BundleDescription bundleDescription) {
        ArrayList<Definition> arrayList = new ArrayList<Definition>();
        if (this.weavingBundleContext != null) {
            String string;
            int n;
            ManifestElement[] manifestElementArray;
            ManifestElement[] manifestElementArray2;
            Definition definition = null;
            BundleDescription[] bundleDescriptionArray = bundleDescription.getFragments();
            int n2 = 0;
            while (n2 < bundleDescriptionArray.length) {
                manifestElementArray2 = this.weavingBundleContext.getBundle(bundleDescriptionArray[n2].getBundleId());
                if (manifestElementArray2 != null && (definition = this.aspectAdmin.getAspectDefinition((Bundle)manifestElementArray2)) != null) {
                    arrayList.add(definition);
                    list.add(String.valueOf(manifestElementArray2.getSymbolicName()) + ":" + bundleDescriptionArray[n2].getVersion().toString());
                }
                ++n2;
            }
            BundleDescription[] bundleDescriptionArray2 = bundleDescription.getResolvedRequires();
            manifestElementArray2 = null;
            if (bundleDescriptionArray2.length > 0) {
                try {
                    manifestElementArray2 = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders().get("Require-Bundle")));
                }
                catch (BundleException bundleException) {}
            }
            int n3 = 0;
            while (n3 < bundleDescriptionArray2.length) {
                manifestElementArray = this.weavingBundleContext.getBundle(bundleDescriptionArray2[n3].getBundleId());
                if (manifestElementArray != null && (definition = this.aspectAdmin.resolveRequiredBundle((Bundle)manifestElementArray, n = this.getApplyAspectsPolicy(manifestElementArray2, manifestElementArray.getSymbolicName()))) != null) {
                    arrayList.add(definition);
                    list.add(String.valueOf(manifestElementArray.getSymbolicName()) + ":" + bundleDescriptionArray2[n3].getVersion().toString());
                }
                ++n3;
            }
            ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getResolvedImports();
            manifestElementArray = null;
            if (exportPackageDescriptionArray.length > 0) {
                try {
                    manifestElementArray = ManifestElement.parseHeader((String)"Import-Package", (String)((String)bundle.getHeaders().get("Import-Package")));
                }
                catch (BundleException bundleException) {}
            }
            n = 0;
            while (n < exportPackageDescriptionArray.length) {
                int n4;
                String string2;
                Bundle bundle2 = this.weavingBundleContext.getBundle(exportPackageDescriptionArray[n].getExporter().getBundleId());
                if (bundle2 != null && (definition = this.aspectAdmin.resolveImportedPackage(bundle2, string2 = exportPackageDescriptionArray[n].getName(), n4 = this.getApplyAspectsPolicy(manifestElementArray, string2))) != null) {
                    arrayList.add(definition);
                    list.add(String.valueOf(string2) + ":" + exportPackageDescriptionArray[n].getVersion().toString());
                }
                ++n;
            }
            Supplementer[] supplementerArray = this.supplementerRegistry.getSupplementers(bundleDescription.getBundleId());
            int n5 = 0;
            while (n5 < supplementerArray.length) {
                definition = this.aspectAdmin.getExportedAspectDefinitions(supplementerArray[n5].getSupplementerBundle());
                if (definition != null) {
                    arrayList.add(definition);
                    list.add(String.valueOf(supplementerArray[n5].getSymbolicName()) + ":" + this.getBundleVersion(supplementerArray[n5].getSupplementerBundle()));
                }
                ++n5;
            }
            definition = this.aspectAdmin.getAspectDefinition(bundle);
            if (!(definition == null || (string = (String)bundle.getHeaders().get("Eclipse-AspectBundle")) != null && "finished".equals(string))) {
                arrayList.add(definition);
                list.add(String.valueOf(bundle.getSymbolicName()) + ":" + bundleDescription.getVersion().toString());
            }
        }
        return arrayList;
    }
}

