/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rcptt.ui.editors.ecl.ColorManager;
import org.eclipse.rcptt.ui.editors.ecl.EditorToolkit;
import org.eclipse.rcptt.ui.editors.ecl.EnhancedRuleScanner;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class EnhancedSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected ColorManager colorManager = new ColorManager();
    protected EditorToolkit toolkit;
    private EnhancedRuleScanner[] scanners;

    public EnhancedSourceViewerConfiguration(EditorToolkit toolkit) {
        super(toolkit.getPreferenceStore());
        this.toolkit = toolkit;
    }

    public EditorToolkit getEditorToolkit() {
        return this.toolkit;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.toolkit.getContentTypes();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        String[] contentTypes = this.toolkit.getContentTypes();
        this.scanners = new EnhancedRuleScanner[contentTypes.length];
        int i = 0;
        while (i < contentTypes.length) {
            String ct = contentTypes[i];
            this.scanners[i] = this.toolkit.getScanner(ct);
            this.scanners[i].initialize();
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.scanners[i]);
            reconciler.setDamager((IPresentationDamager)dr, ct);
            reconciler.setRepairer((IPresentationRepairer)dr, ct);
            ++i;
        }
        return reconciler;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        EnhancedRuleScanner[] enhancedRuleScannerArray = this.scanners;
        int n = this.scanners.length;
        int n2 = 0;
        while (n2 < n) {
            EnhancedRuleScanner s = enhancedRuleScannerArray[n2];
            if (s.affectsBehavior(event)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        EnhancedRuleScanner[] enhancedRuleScannerArray = this.scanners;
        int n = this.scanners.length;
        int n2 = 0;
        while (n2 < n) {
            EnhancedRuleScanner s = enhancedRuleScannerArray[n2];
            if (s.affectsBehavior(event)) {
                s.adaptToPreferenceChange(event);
            }
            ++n2;
        }
    }
}

