/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.debug.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugElement;
import org.eclipse.rcptt.ecl.internal.debug.core.EclDebugTarget;

public class EclDebugThread
extends EclDebugElement
implements IThread {
    private EclDebugTarget target;
    private IBreakpoint[] breakpoints;

    public EclDebugThread(EclDebugTarget target) {
        this.target = target;
    }

    public IDebugTarget getDebugTarget() {
        return this.target;
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canStepOver() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canStepReturn() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean isStepping() {
        return this.target.isStepping();
    }

    public void stepInto() throws DebugException {
        this.target.step();
    }

    public void stepOver() throws DebugException {
        this.target.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.target.stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.target.getFrames();
    }

    public boolean hasStackFrames() throws DebugException {
        return this.getStackFrames().length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return "ECL Thread";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.breakpoints;
    }

    public void setBreakpoints(IBreakpoint[] breakpoints) {
        this.breakpoints = breakpoints;
    }
}

