/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.BlockList;

public class PackBitmapIndexBuilder
extends BasePackBitmapIndex {
    private static final int MAX_XOR_OFFSET_SEARCH = 10;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final ObjectToPack[] byOffset;
    private final BlockList<BasePackBitmapIndex.StoredBitmap> byAddOrder = new BlockList();
    private final ObjectIdOwnerMap<PositionEntry> positionEntries = new ObjectIdOwnerMap();

    public PackBitmapIndexBuilder(List<ObjectToPack> byName) {
        super(new ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap>());
        this.byOffset = this.sortByOffset(byName);
        int sizeInWords = Math.max(this.byOffset.length / 64, 4);
        this.commits = new EWAHCompressedBitmap(sizeInWords);
        this.trees = new EWAHCompressedBitmap(sizeInWords);
        this.blobs = new EWAHCompressedBitmap(sizeInWords);
        this.tags = new EWAHCompressedBitmap(sizeInWords);
        block6: for (int i = 0; i < this.byOffset.length; ++i) {
            int type = this.byOffset[i].getType();
            switch (type) {
                case 1: {
                    this.commits.set(i);
                    continue block6;
                }
                case 2: {
                    this.trees.set(i);
                    continue block6;
                }
                case 3: {
                    this.blobs.set(i);
                    continue block6;
                }
                case 4: {
                    this.tags.set(i);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, String.valueOf(type)));
                }
            }
        }
    }

    private ObjectToPack[] sortByOffset(List<ObjectToPack> entries) {
        int i;
        ObjectToPack[] result = new ObjectToPack[entries.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = entries.get(i);
            this.positionEntries.add(new PositionEntry(result[i], i));
        }
        Arrays.sort(result, new Comparator<ObjectToPack>(){

            @Override
            public int compare(ObjectToPack a, ObjectToPack b) {
                return Long.signum(a.getOffset() - b.getOffset());
            }
        });
        for (i = 0; i < result.length; ++i) {
            this.positionEntries.get(result[i]).offsetPosition = i;
        }
        return result;
    }

    public void addBitmap(AnyObjectId objectId, BitmapIndex.Bitmap bitmap, int flags) {
        if (bitmap instanceof BitmapIndex.BitmapBuilder) {
            bitmap = ((BitmapIndex.BitmapBuilder)bitmap).build();
        }
        if (!(bitmap instanceof BitmapIndexImpl.CompressedBitmap)) {
            throw new IllegalArgumentException(bitmap.getClass().toString());
        }
        EWAHCompressedBitmap compressed = ((BitmapIndexImpl.CompressedBitmap)bitmap).getEwahCompressedBitmap();
        this.addBitmap(objectId, compressed, flags);
    }

    public void addBitmap(AnyObjectId objectId, EWAHCompressedBitmap bitmap, int flags) {
        BasePackBitmapIndex.StoredBitmap result = new BasePackBitmapIndex.StoredBitmap(objectId, bitmap, null, flags);
        this.getBitmaps().add(result);
        this.byAddOrder.add(result);
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type) {
        switch (type) {
            case 3: {
                return this.getBlobs().and(bitmap);
            }
            case 2: {
                return this.getTrees().and(bitmap);
            }
            case 1: {
                return this.getCommits().and(bitmap);
            }
            case 4: {
                return this.getTags().and(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        PositionEntry entry = this.positionEntries.get(objectId);
        if (entry == null) {
            return -1;
        }
        return entry.offsetPosition;
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        ObjectToPack objectId = this.byOffset[position];
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    public EWAHCompressedBitmap getCommits() {
        return this.commits;
    }

    public EWAHCompressedBitmap getTrees() {
        return this.trees;
    }

    public EWAHCompressedBitmap getBlobs() {
        return this.blobs;
    }

    public EWAHCompressedBitmap getTags() {
        return this.tags;
    }

    public int getOptions() {
        return 1;
    }

    public int getBitmapCount() {
        return this.getBitmaps().size();
    }

    public void clearBitmaps() {
        this.byAddOrder.clear();
        this.getBitmaps().clear();
    }

    @Override
    public int getObjectCount() {
        return this.byOffset.length;
    }

    public Iterable<StoredEntry> getCompressedBitmaps() {
        return new Iterable<StoredEntry>(){

            @Override
            public Iterator<StoredEntry> iterator() {
                return new Iterator<StoredEntry>(){
                    private int index;
                    {
                        this.index = PackBitmapIndexBuilder.this.byAddOrder.size() - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index >= 0;
                    }

                    @Override
                    public StoredEntry next() {
                        int curr;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        BasePackBitmapIndex.StoredBitmap item = (BasePackBitmapIndex.StoredBitmap)PackBitmapIndexBuilder.this.byAddOrder.get(this.index);
                        int bestXorOffset = 0;
                        EWAHCompressedBitmap bestBitmap = item.getBitmap();
                        for (int i = 1; i <= 10 && (curr = i + this.index) < PackBitmapIndexBuilder.this.byAddOrder.size(); ++i) {
                            BasePackBitmapIndex.StoredBitmap other = (BasePackBitmapIndex.StoredBitmap)PackBitmapIndexBuilder.this.byAddOrder.get(curr);
                            EWAHCompressedBitmap bitmap = other.getBitmap().xor(item.getBitmap());
                            if (bitmap.sizeInBytes() >= bestBitmap.sizeInBytes()) continue;
                            bestBitmap = bitmap;
                            bestXorOffset = i;
                        }
                        --this.index;
                        PositionEntry entry = (PositionEntry)PackBitmapIndexBuilder.this.positionEntries.get(item);
                        if (entry == null) {
                            throw new IllegalStateException();
                        }
                        return new StoredEntry(entry.namePosition, bestBitmap, bestXorOffset, item.getFlags());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static final class PositionEntry
    extends ObjectIdOwnerMap.Entry {
        private final int namePosition;
        private int offsetPosition;

        private PositionEntry(AnyObjectId objectId, int namePosition) {
            super(objectId);
            this.namePosition = namePosition;
        }
    }

    public static final class StoredEntry {
        private final long objectId;
        private final EWAHCompressedBitmap bitmap;
        private final int xorOffset;
        private final int flags;

        private StoredEntry(long objectId, EWAHCompressedBitmap bitmap, int xorOffset, int flags) {
            this.objectId = objectId;
            this.bitmap = bitmap;
            this.xorOffset = xorOffset;
            this.flags = flags;
        }

        public EWAHCompressedBitmap getBitmap() {
            return this.bitmap;
        }

        public int getXorOffset() {
            return this.xorOffset;
        }

        public int getFlags() {
            return this.flags;
        }

        public long getObjectId() {
            return this.objectId;
        }
    }
}

