/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.expressions;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class EnableWatchExpressionAction
implements IViewActionDelegate,
IActionDelegate2,
IDebugEventSetListener {
    private ISelection fSelection;
    private IAction fAction;
    protected boolean fEnable = true;

    public void init(IViewPart view) {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)this.fSelection).iterator();
            while (iter.hasNext()) {
                IWatchExpression expression = this.getWatchExpression(iter.next());
                if (expression == null) continue;
                expression.setEnabled(this.fEnable);
                this.fireWatchExpressionChanged(expression);
            }
        } else if (this.fSelection instanceof IWatchExpression) {
            IWatchExpression expression = (IWatchExpression)this.fSelection;
            expression.setEnabled(this.fEnable);
            this.fireWatchExpressionChanged(expression);
        }
    }

    private void fireWatchExpressionChanged(IWatchExpression expression) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)expression, 16)});
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (this.fSelection instanceof IStructuredSelection) {
            boolean enabled = false;
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                IWatchExpression expression = this.getWatchExpression(iter.next());
                if (expression == null || expression.isEnabled() == this.fEnable) continue;
                enabled = true;
                break;
            }
            action.setEnabled(enabled);
        } else if (this.fSelection instanceof IWatchExpression) {
            action.setEnabled(((IWatchExpression)this.fSelection).isEnabled() ^ this.fEnable);
        } else {
            action.setEnabled(false);
        }
    }

    private IWatchExpression getWatchExpression(Object element) {
        if (element instanceof IWatchExpression) {
            return (IWatchExpression)element;
        }
        if (element instanceof IAdaptable) {
            return (IWatchExpression)((IAdaptable)element).getAdapter(IWatchExpression.class);
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() instanceof IWatchExpression && event.getKind() == 16) {
                this.selectionChanged(this.fAction, this.fSelection);
            }
            ++i;
        }
    }
}

