/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFix;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PotentialProgrammingProblemsCleanUp
extends AbstractMultiFix {
    public PotentialProgrammingProblemsCleanUp(Map<String, String> options) {
        super(options);
    }

    public PotentialProgrammingProblemsCleanUp() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        boolean addSUID = this.isEnabled("cleanup.add_serial_version_id");
        if (!addSUID) {
            return false;
        }
        return this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_default_serial_version_id");
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean addSUID = this.isEnabled("cleanup.add_serial_version_id");
        if (!addSUID) {
            return null;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_default_serial_version_id"));
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id"));
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            result.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id")) {
            result.add(MultiFixMessages.SerialVersionCleanUp_Generated_description);
        }
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_addDefaultSerialVersionId_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class E implements java.io.Serializable {\n");
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id")) {
            buf.append("    private static final long serialVersionUID = -391484377137870342L;\n");
        } else if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            buf.append("    private static final long serialVersionUID = 1L;\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() == 0x20000060) {
            return this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id");
        }
        return false;
    }

    @Override
    public RefactoringStatus checkPreConditions(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        RefactoringStatus superStatus = super.checkPreConditions(project, compilationUnits, monitor);
        if (superStatus.hasFatalError()) {
            return superStatus;
        }
        return PotentialProgrammingProblemsFix.checkPreConditions(project, compilationUnits, monitor, this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id"), this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id"), false);
    }

    @Override
    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        return PotentialProgrammingProblemsFix.checkPostConditions(monitor);
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        if (this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_generated_serial_version_id") || this.isEnabled("cleanup.add_serial_version_id") && this.isEnabled("cleanup.add_default_serial_version_id")) {
            return PotentialProgrammingProblemsCleanUp.getNumberOfProblems(compilationUnit.getProblems(), 0x20000060);
        }
        return 0;
    }
}

