/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.NetUtil;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class ConfigureGerritAfterCloneTask
implements CloneOperation.PostCloneTask {
    private static final String GIT_ECLIPSE_ORG = "git.eclipse.org";
    private static final String GERRIT_CONTEXT_ROOT = "/r/";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SSH = "ssh";
    private static final String GERRIT_CONFIG_SERVER_VERSION_API = "/config/server/version";
    private static final String GERRIT_XSSI_MAGIC_STRING = ")]}'\n";
    private final String uri;
    private final String remoteName;
    private int timeout;

    public ConfigureGerritAfterCloneTask(String uri, String remoteName, int timeout) {
        this.uri = uri;
        this.remoteName = remoteName;
        this.timeout = timeout;
    }

    @Override
    public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.isGerrit(repository)) {
                Activator.logInfo(String.valueOf(this.uri) + " was detected to be hosted by a Gerrit server");
                this.configureGerrit(repository);
            }
        }
        catch (Exception e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    private boolean isGerrit(Repository repo) throws MalformedURLException, IOException, URISyntaxException {
        URIish u = new URIish(this.uri);
        String s = u.getScheme();
        String host = u.getHost();
        String path = u.getPath();
        if (host != null && host.equals(GIT_ECLIPSE_ORG)) {
            if (HTTPS.equals(s) && (u.getPort() == 443 || u.getPort() == -1) && path != null && path.startsWith(GERRIT_CONTEXT_ROOT)) {
                return true;
            }
            if (SSH.equals(s) && u.getPort() == 29418) {
                return true;
            }
        }
        if (path != null && (HTTP.equals(s) || HTTPS.equals(s))) {
            String baseURL = u.setPath("/").toString();
            baseURL = baseURL.substring(0, baseURL.length() - 1);
            String tmpPath = "";
            HttpURLConnection httpConnection = null;
            try {
                int slash = 1;
                block16: while (true) {
                    InputStream in = null;
                    try {
                        httpConnection = (HttpURLConnection)new URL(String.valueOf(baseURL) + tmpPath + GERRIT_CONFIG_SERVER_VERSION_API).openConnection();
                        NetUtil.setSslVerification(repo, httpConnection);
                        httpConnection.setRequestMethod("GET");
                        httpConnection.setReadTimeout(1000 * this.timeout);
                        int responseCode = httpConnection.getResponseCode();
                        switch (responseCode) {
                            case 200: {
                                in = httpConnection.getInputStream();
                                String response = this.readFully(in, "UTF-8");
                                return response.startsWith(GERRIT_XSSI_MAGIC_STRING);
                                {
                                }
                            }
                            case 404: {
                                if (slash > path.length()) {
                                    return false;
                                }
                                if ((slash = path.indexOf(47, slash)) == -1) {
                                    slash = path.length();
                                }
                                tmpPath = path.substring(0, slash);
                                ++slash;
                                continue block16;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
        }
        return false;
    }

    private String readFully(InputStream inputStream, String encoding) throws IOException {
        return new String(this.readFully(inputStream), encoding);
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
        return os.toByteArray();
    }

    private void configureGerrit(Repository repository) throws URISyntaxException, IOException {
        StoredConfig config = repository.getConfig();
        RemoteConfig remoteConfig = GerritUtil.findRemoteConfig((Config)config, this.remoteName);
        if (remoteConfig == null) {
            return;
        }
        GerritUtil.configurePushURI(remoteConfig, new URIish(this.uri));
        GerritUtil.configurePushRefSpec(remoteConfig, "master");
        GerritUtil.configureFetchNotes(remoteConfig);
        GerritUtil.setCreateChangeId((Config)config);
        remoteConfig.update((Config)config);
        config.save();
    }
}

