/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rcptt.tesla.internal.ui.player.ChildrenCollector;
import org.eclipse.rcptt.tesla.internal.ui.player.IChildrenCollectingExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPartReference;

public class ChildrenCollectingSession {
    public final SWTUIPlayer player;
    public final ChildrenCollector collector;
    public final SWTUIElement w;
    public final SWTUIElement[] ignores;
    public final boolean goIntoComposites;
    private final boolean menuIsShown;
    public final Class<?>[] classes;
    private boolean started = false;
    private final List<SWTUIElement> results = new ArrayList<SWTUIElement>();

    public ChildrenCollectingSession(SWTUIPlayer player, ChildrenCollector collector, SWTUIElement w, SWTUIElement[] ignores, boolean goIntoComposites, boolean menuIsShown, Class<?> ... classes) {
        this.player = player;
        this.collector = collector;
        this.w = w;
        this.ignores = ignores;
        this.goIntoComposites = goIntoComposites;
        this.menuIsShown = menuIsShown;
        this.classes = classes;
    }

    public SWTUIElement[] collect() {
        TreeItem item;
        TreeItem treeItem;
        TreeItem[] treeItemArray;
        TreeItem[] items;
        Tree tree;
        Composite c;
        SWTUIElement[] cc;
        ToolItem[] children;
        SWTUIElement[] cc2;
        SWTUIElement wrap;
        CTabItem[] cTabItemArray;
        CTabItem[] items2;
        CTabFolder tabFolder;
        Widget widget;
        int n;
        if (this.started) {
            throw new IllegalStateException("collect() should be called once only");
        }
        this.started = true;
        for (ISWTUIPlayerExtension ext : SWTUIPlayer.extensions) {
            IChildrenCollectingExtension cce = ext.getChildrenCollectingExtension(this);
            if (cce == null) continue;
            cce.collect();
        }
        if (this.w == null) {
            Shell[] shells;
            Shell[] shellArray = shells = this.player.display.getShells();
            n = shells.length;
            int cce = 0;
            while (cce < n) {
                Shell shell = shellArray[cce];
                this.addItem(this.wrap(shell));
                ++cce;
            }
        }
        if (this.w instanceof WorkbenchUIElement && this.w.isView()) {
            WorkbenchUIElement wbelement = (WorkbenchUIElement)this.w;
            if (this.needToCollectMenuItems()) {
                this.collectMenuItems(wbelement.getViewMenu(), null);
            }
        }
        if ((widget = PlayerWrapUtils.unwrapWidget(this.w)) != null && widget.isDisposed()) {
            return new SWTUIElement[0];
        }
        if (widget instanceof Shell) {
            Shell[] shells;
            Shell[] shellArray = shells = ((Shell)widget).getShells();
            int n2 = shells.length;
            n = 0;
            while (n < n2) {
                Shell shell = shellArray[n];
                this.addItem(this.wrap(shell));
                ++n;
            }
        }
        if (this.w instanceof WorkbenchUIElement) {
            WorkbenchPartReference reference = (WorkbenchPartReference)((WorkbenchUIElement)this.w).getReference();
            Control toolBar = EclipseWorkbenchProvider.getProvider().getToolbar((IWorkbenchPartReference)reference);
            if (toolBar != null) {
                this.addItem(this.wrap(toolBar));
                SWTUIElement[] children2 = this.collector.collectFor(this.wrap(toolBar), this.ignores, this.goIntoComposites, this.classes);
                this.results.addAll(Arrays.asList(children2));
            }
        }
        if ((widget instanceof TreeColumn || widget instanceof TableColumn) && this.needToCollectMenuItems()) {
            Control tableOrTree = (Control)TableTreeUtil.getParent((Widget)widget);
            Rectangle bounds = TableTreeUtil.getColumnBounds((Widget)widget);
            Point point = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
            point = tableOrTree.getDisplay().map(tableOrTree, null, point);
            this.player.getEvents().sendFocus((Widget)tableOrTree);
            this.player.getEvents().sendEvent((Widget)tableOrTree, 35, point.x, point.y, 3);
            this.collectMenuItems(tableOrTree.getMenu(), point);
        }
        if (widget instanceof CTabFolder) {
            tabFolder = (CTabFolder)widget;
            items2 = tabFolder.getItems();
            if (PlayerWidgetUtils.isVisible((Control)tabFolder)) {
                cTabItemArray = items2;
                int n3 = items2.length;
                int n4 = 0;
                while (n4 < n3) {
                    CTabItem control = cTabItemArray[n4];
                    wrap = this.wrap(control);
                    this.addItem(wrap);
                    if (this.goIntoComposites) {
                        cc2 = this.collector.collectFor(new SWTUIElement((Widget)control, this.player), this.ignores, true, this.classes);
                        this.results.addAll(Arrays.asList(cc2));
                    }
                    ++n4;
                }
            }
        }
        if (widget instanceof TabFolder) {
            tabFolder = (TabFolder)widget;
            items2 = tabFolder.getItems();
            if (PlayerWidgetUtils.isVisible((Control)tabFolder)) {
                cTabItemArray = items2;
                int n5 = items2.length;
                int n6 = 0;
                while (n6 < n5) {
                    CTabItem control = cTabItemArray[n6];
                    wrap = this.wrap(control);
                    this.addItem(wrap);
                    if (this.goIntoComposites) {
                        cc2 = this.collector.collectFor(new SWTUIElement((Widget)control, this.player), this.ignores, true, this.classes);
                        this.results.addAll(Arrays.asList(cc2));
                    }
                    ++n6;
                }
            }
        }
        if (widget instanceof ToolBar) {
            ToolBar tb = (ToolBar)widget;
            children = tb.getItems();
            cTabItemArray = children;
            int n7 = children.length;
            int n8 = 0;
            while (n8 < n7) {
                CTabItem item2 = cTabItemArray[n8];
                if ((item2.getStyle() & 2) == 0) {
                    this.addItem(this.wrap(item2));
                    if (this.goIntoComposites) {
                        cc = this.collector.collectFor(new SWTUIElement((Widget)item2, this.player), this.ignores, true, this.classes);
                        this.results.addAll(Arrays.asList(cc));
                    }
                }
                ++n8;
            }
        }
        if (widget instanceof Composite) {
            c = (Composite)widget;
            children = c.getChildren();
            cTabItemArray = children;
            int n9 = children.length;
            int n10 = 0;
            while (n10 < n9) {
                CTabItem control = cTabItemArray[n10];
                if (PlayerWidgetUtils.isVisible((Control)control)) {
                    this.addItem(this.wrap(control));
                    if (this.goIntoComposites) {
                        cc = this.collector.collectFor(new SWTUIElement((Widget)control, this.player), this.ignores, true, this.classes);
                        this.results.addAll(Arrays.asList(cc));
                    }
                }
                ++n10;
            }
        }
        if (widget instanceof Control) {
            c = (Control)widget;
            if (this.needToCollectMenuItems()) {
                Point xy = this.player.getMousePos((Widget)c);
                Point p = c.getDisplay().map((Control)c, null, xy);
                if (c instanceof Tree || c instanceof Table) {
                    this.player.getEvents().sendFocus((Widget)c);
                }
                this.player.getEvents().sendEvent((Widget)c, 35, p.x, p.y, 0x100000);
                this.collectMenuItems(c.getMenu(), p);
            }
        }
        if (widget instanceof Decorations) {
            Decorations d = (Decorations)widget;
            if (this.needToCollectMenuItems()) {
                this.collectMenuItems(d.getMenuBar(), null);
            }
        }
        if (widget instanceof Menu) {
            this.collectMenuItems((Menu)widget, null);
        }
        if (widget instanceof MenuItem) {
            MenuItem item3 = (MenuItem)widget;
            this.collectMenuItems(item3.getMenu(), null);
        }
        List popupMenus = TeslaEventManager.getManager().getPopupMenus();
        for (WeakReference menuWR : popupMenus) {
            Menu menu = (Menu)menuWR.get();
            if (menu == null || menu.isDisposed()) continue;
            Control control = (Control)TeslaEventManager.getManager().getPopupMenuParents().get(menu);
            if ((menu.getParent() == null || !menu.getParent().equals(widget)) && (widget == null || !widget.equals(control))) continue;
            this.collectMenuItems(menu, null);
        }
        if (widget instanceof Scrollable) {
            Scrollable s = (Scrollable)widget;
            ScrollBar horizontalBar = s.getHorizontalBar();
            ScrollBar verticalBar = s.getVerticalBar();
            if (horizontalBar != null) {
                this.addItem(this.wrap(horizontalBar));
            }
            if (verticalBar != null) {
                this.addItem(this.wrap(verticalBar));
            }
        }
        if (widget instanceof Tree) {
            tree = (Tree)widget;
            treeItemArray = items = tree.getItems();
            int n11 = items.length;
            int n12 = 0;
            while (n12 < n11) {
                treeItem = treeItemArray[n12];
                this.addItem(this.wrap(treeItem));
                if (this.goIntoComposites) {
                    cc2 = this.collector.collectFor(new SWTUIElement((Widget)treeItem, this.player), this.ignores, true, this.classes);
                    this.results.addAll(Arrays.asList(cc2));
                }
                ++n12;
            }
        }
        if (widget instanceof TreeItem && (item = (TreeItem)widget).getExpanded()) {
            treeItemArray = items = item.getItems();
            int n13 = items.length;
            int n14 = 0;
            while (n14 < n13) {
                treeItem = treeItemArray[n14];
                this.addItem(this.wrap(treeItem));
                if (this.goIntoComposites) {
                    cc2 = this.collector.collectFor(new SWTUIElement((Widget)treeItem, this.player), this.ignores, true, this.classes);
                    this.results.addAll(Arrays.asList(cc2));
                }
                ++n14;
            }
        }
        if (widget instanceof Table) {
            tree = (Table)widget;
            treeItemArray = items = tree.getItems();
            int n15 = items.length;
            int n16 = 0;
            while (n16 < n15) {
                treeItem = treeItemArray[n16];
                this.addItem(this.wrap(treeItem));
                if (this.goIntoComposites) {
                    cc2 = this.collector.collectFor(new SWTUIElement((Widget)treeItem, this.player), this.ignores, true, this.classes);
                    this.results.addAll(Arrays.asList(cc2));
                }
                ++n16;
            }
        }
        return this.results.toArray(new SWTUIElement[this.results.size()]);
    }

    private SWTUIElement wrap(Object s) {
        return this.player.wrap(s);
    }

    public void addItem(SWTUIElement control) {
        ChildrenCollector.addItem(this.results, control, this.ignores, this.classes);
    }

    private static boolean containClass(Class<?> cl, Class<?>[] classes) {
        if (classes != null) {
            boolean instanceOf = false;
            Class<?>[] classArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> class1 = classArray[n2];
                if (class1.equals(cl)) {
                    return true;
                }
                ++n2;
            }
            return instanceOf;
        }
        return false;
    }

    public boolean needToCollectMenuItems() {
        return ChildrenCollectingSession.containClass(Menu.class, this.classes) || ChildrenCollectingSession.containClass(MenuItem.class, this.classes);
    }

    public void collectMenuItems(Menu menu, Point point) {
        if (menu != null) {
            MenuItem[] items;
            boolean oldHasLocation = TeslaSWTAccess.getHasLocation(menu);
            if (point != null) {
                menu.setLocation(point);
            }
            SWTUIElement wrappedMenu = this.wrap(menu);
            this.addItem(wrappedMenu);
            if (!this.menuIsShown) {
                this.player.show(wrappedMenu, point != null ? point.x : -1, point != null ? point.y : -1);
            }
            MenuItem[] menuItemArray = items = menu.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem control = menuItemArray[n2];
                this.addItem(this.wrap(control));
                if (this.goIntoComposites) {
                    SWTUIElement[] cc = this.collector.collectFor(new SWTUIElement((Widget)control, this.player), this.ignores, true, this.classes);
                    this.results.addAll(Arrays.asList(cc));
                }
                ++n2;
            }
            if (point != null) {
                TeslaSWTAccess.setHasLocation(menu, oldHasLocation);
            }
        }
    }
}

