/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.dnd;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.swt.aspects.SWTAspectActivator;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalClipboard {
    private static final Integer SELECTION_CLIPBOARD = 2;
    private static final Integer CLIPBOARD = 1;
    private static boolean useLocalClipboard = false;
    private static Map<Integer, ContentEntry> contents = new HashMap<Integer, ContentEntry>();

    public static boolean isEnabled() {
        return useLocalClipboard;
    }

    public static synchronized void setContents(Object[] data, Transfer[] dataTypes, int type) {
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error((int)5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !LocalClipboard.validate(data, dataTypes, i)) {
                DND.error((int)5);
            }
            ++i;
        }
        if ((type & 1) != 0) {
            contents.put(CLIPBOARD, new ContentEntry(data, dataTypes));
        }
        if ((type & 2) != 0) {
            contents.put(SELECTION_CLIPBOARD, new ContentEntry(data, dataTypes));
        }
    }

    private static boolean validate(Object[] data, Transfer[] dataTypes, int i) {
        try {
            Method validateMethod = Transfer.class.getDeclaredMethod("validate", Object.class);
            validateMethod.setAccessible(true);
            return (Boolean)validateMethod.invoke((Object)dataTypes[i], data[i]);
        }
        catch (Throwable e) {
            SWTAspectActivator.log(e);
            return false;
        }
    }

    private static synchronized Object convert(Transfer tr, Object original) {
        try {
            TransferData[] types;
            Method javaToNative = Transfer.class.getDeclaredMethod("javaToNative", Object.class, TransferData.class);
            javaToNative.setAccessible(true);
            Method nativeToJava = Transfer.class.getDeclaredMethod("nativeToJava", TransferData.class);
            nativeToJava.setAccessible(true);
            TransferData[] transferDataArray = types = tr.getSupportedTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TransferData transferData = transferDataArray[n2];
                try {
                    javaToNative.invoke((Object)tr, original, transferData);
                    Object result = nativeToJava.invoke((Object)tr, transferData);
                    if (result != null) {
                        return result;
                    }
                }
                catch (Throwable throwable) {}
                ++n2;
            }
            if (original instanceof EObject) {
                return EcoreUtil.copy((EObject)((EObject)original));
            }
            if (original instanceof Object[]) {
                Object[] o = (Object[])original;
                Object[] result = new Object[o.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = o[i];
                    if (result[i] instanceof EObject) {
                        result[i] = EcoreUtil.copy((EObject)((EObject)result[i]));
                    }
                    ++i;
                }
                return result;
            }
            return original;
        }
        catch (Throwable e) {
            SWTAspectActivator.log(e);
            return null;
        }
    }

    public static synchronized Object getContents(Transfer tr, int type) {
        int i;
        ContentEntry entry;
        Object result = null;
        if ((type & 1) != 0) {
            entry = contents.get(CLIPBOARD);
            if (entry != null) {
                i = 0;
                while (i < entry.transfers.length) {
                    if (entry.transfers[i].equals(tr)) {
                        result = entry.objects[i];
                    }
                    ++i;
                }
            }
            if (result != null) {
                return LocalClipboard.convert(tr, result);
            }
        }
        if ((type & 2) != 0) {
            entry = contents.get(SELECTION_CLIPBOARD);
            if (entry != null) {
                i = 0;
                while (i < entry.transfers.length) {
                    if (entry.transfers[i].equals(tr)) {
                        result = entry.objects[i];
                    }
                    ++i;
                }
            }
            if (result != null) {
                return LocalClipboard.convert(tr, result);
            }
        }
        return result;
    }

    public static synchronized TransferData[] getAvailableTypes(int type) {
        HashSet<TransferData> result = new HashSet<TransferData>();
        if ((type & 1) != 0) {
            result.addAll(LocalClipboard.getClipboardTypes(CLIPBOARD));
        }
        if ((type & 2) != 0) {
            result.addAll(LocalClipboard.getClipboardTypes(SELECTION_CLIPBOARD));
        }
        return result.toArray(new TransferData[result.size()]);
    }

    private static synchronized Set<TransferData> getClipboardTypes(Integer clipboard2) {
        ContentEntry contentEntry = contents.get(clipboard2);
        HashSet<TransferData> result = new HashSet<TransferData>();
        if (contentEntry != null && contentEntry.transfers != null) {
            int i = 0;
            while (i < contentEntry.transfers.length) {
                TransferData[] types = contentEntry.transfers[i].getSupportedTypes();
                if (types != null) {
                    result.addAll((Collection<TransferData>)Arrays.asList(types));
                }
                ++i;
            }
        }
        return result;
    }

    private static synchronized Set<Transfer> getClipboardTransfers(Integer clipboard2) {
        ContentEntry contentEntry = contents.get(clipboard2);
        HashSet<Transfer> result = new HashSet<Transfer>();
        if (contentEntry != null && contentEntry.transfers != null) {
            result.addAll((Collection<Transfer>)Arrays.asList(contentEntry.transfers));
        }
        return result;
    }

    public static synchronized String[] getAvailableTypeNames(int type) {
        HashSet<Transfer> result = new HashSet<Transfer>();
        if ((type & 1) != 0) {
            result.addAll(LocalClipboard.getClipboardTransfers(CLIPBOARD));
        }
        if ((type & 2) != 0) {
            result.addAll(LocalClipboard.getClipboardTransfers(SELECTION_CLIPBOARD));
        }
        HashSet names = new HashSet();
        for (Transfer transferData : result) {
            try {
                String[] values = LocalClipboard.getTypeNames(transferData);
                if (values == null) continue;
                names.addAll(Arrays.asList(values));
            }
            catch (Throwable e) {
                SWTAspectActivator.log(e);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private static synchronized String[] getTypeNames(Transfer transferData) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = TransferData.class.getDeclaredMethod("getTypeNames", new Class[0]);
        method.setAccessible(true);
        String[] values = (String[])method.invoke((Object)transferData, new Object[0]);
        return values;
    }

    public static synchronized void clearContents(int type) {
        if ((type & 1) != 0) {
            contents.remove(CLIPBOARD);
        }
        if ((type & 2) != 0) {
            contents.remove(SELECTION_CLIPBOARD);
        }
    }

    public static void setEnabled(boolean useInternalClipboard) {
        useLocalClipboard = useInternalClipboard;
    }

    private static class ContentEntry {
        Object[] objects;
        Transfer[] transfers;

        public ContentEntry(Object[] objs, Transfer[] tr) {
            this.objects = objs;
            this.transfers = tr;
        }
    }
}

