/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.MergeActionHandler;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.MergeTargetSelectionDialog;
import org.eclipse.egit.ui.internal.merge.MergeResultDialog;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MergeCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MergeOperation op;
        String targetRef;
        String refName;
        Repository repository;
        block9: {
            RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
            repository = node.getRepository();
            BasicConfigurationDialog.show(repository);
            if (!MergeActionHandler.checkMergeIsPossible(repository, this.getShell(event))) {
                return null;
            }
            if (node instanceof RefNode) {
                refName = ((Ref)((RefNode)node).getObject()).getName();
                try {
                    if (repository.getFullBranch().equals(refName)) {
                        targetRef = null;
                        break block9;
                    }
                    targetRef = refName;
                }
                catch (IOException iOException) {
                    targetRef = null;
                }
            } else {
                targetRef = node instanceof TagNode ? ((Ref)((TagNode)node).getObject()).getName() : null;
            }
        }
        if (targetRef != null) {
            refName = targetRef;
            op = new MergeOperation(repository, refName);
        } else {
            MergeTargetSelectionDialog mergeTargetSelectionDialog = new MergeTargetSelectionDialog(this.getShell(event), repository);
            if (mergeTargetSelectionDialog.open() != 0) {
                return null;
            }
            refName = mergeTargetSelectionDialog.getRefName();
            op = new MergeOperation(repository, refName);
            op.setSquash(mergeTargetSelectionDialog.isMergeSquash());
            op.setFastForwardMode(mergeTargetSelectionDialog.getFastForwardMode());
            op.setCommit(mergeTargetSelectionDialog.isCommit());
        }
        String jobname = NLS.bind((String)UIText.MergeAction_JobNameMerge, (Object)refName);
        WorkspaceJob job = new WorkspaceJob(jobname){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent jobEvent) {
                IStatus result = jobEvent.getJob().getResult();
                if (result.getSeverity() == 8) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.MergeAction_MergeCanceledTitle, (String)UIText.MergeAction_MergeCanceledMessage);
                        }
                    });
                } else if (!result.isOK()) {
                    Activator.handleError(result.getMessage(), result.getException(), true);
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MergeResultDialog.getDialog(shell, repository, op.getResult()).open();
                        }
                    });
                }
            }
        });
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        return this.selectedRepositoryHasHead();
    }
}

