/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.gerrit;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class GerritConfigurationPage
extends WizardPage {
    private static final int GERRIT_DEFAULT_SSH_PORT = 29418;
    private String helpContext = null;
    private Text branch;
    private Group pushConfigurationGroup;
    private Group fetchConfigurationGroup;
    private Group uriGroup;
    private Combo scheme;
    private Text uriText;
    private URIish pushURI;
    private Text user;
    private int eventDepth;
    private final Repository repository;
    private final String remoteName;

    public GerritConfigurationPage(Repository repository, String remoteName) {
        super(GerritConfigurationPage.class.getName());
        this.repository = repository;
        this.remoteName = remoteName;
        this.setTitle(UIText.GerritConfigurationPage_title);
        String repositoryName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        this.setDescription(MessageFormat.format(UIText.GerritConfigurationPage_PageDescription, remoteName, repositoryName));
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        this.createURIGroup(panel);
        this.createPushConfigurationGroup(panel);
        this.createFetchConfigurationGroup(panel);
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.uriText.setFocus();
    }

    private void createURIGroup(Composite panel) {
        this.uriGroup = SWTUtils.createHFillGroup(panel, UIText.GerritConfigurationPage_pushUri, -1, 2);
        this.scheme = new Combo((Composite)this.uriGroup, 12);
        this.uriText = SWTUtils.createText((Composite)this.uriGroup);
        new Label((Composite)this.uriGroup, 0).setText(UIText.GerritConfigurationPage_UserLabel);
        this.user = SWTUtils.createText((Composite)this.uriGroup);
        this.user.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritConfigurationPage gerritConfigurationPage = GerritConfigurationPage.this;
                gerritConfigurationPage.eventDepth = gerritConfigurationPage.eventDepth + 1;
                try {
                    if (GerritConfigurationPage.this.eventDepth == 1 && GerritConfigurationPage.this.pushURI != null) {
                        GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setUser(GerritConfigurationPage.this.user.getText());
                        GerritConfigurationPage.this.uriText.setText(GerritConfigurationPage.this.pushURI.toString());
                        GerritConfigurationPage.this.checkPage();
                    }
                }
                finally {
                    GerritConfigurationPage gerritConfigurationPage2 = GerritConfigurationPage.this;
                    gerritConfigurationPage2.eventDepth = gerritConfigurationPage2.eventDepth - 1;
                }
            }
        });
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                block6: {
                    GerritConfigurationPage gerritConfigurationPage = GerritConfigurationPage.this;
                    gerritConfigurationPage.eventDepth = gerritConfigurationPage.eventDepth + 1;
                    try {
                        try {
                            if (GerritConfigurationPage.this.eventDepth == 1) {
                                URIish u = new URIish(GerritConfigurationPage.this.uriText.getText());
                                String newUser = u.getUser();
                                GerritConfigurationPage.this.user.setText(newUser != null ? newUser : "");
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            GerritConfigurationPage gerritConfigurationPage2 = GerritConfigurationPage.this;
                            gerritConfigurationPage2.eventDepth = gerritConfigurationPage2.eventDepth - 1;
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        GerritConfigurationPage gerritConfigurationPage3 = GerritConfigurationPage.this;
                        gerritConfigurationPage3.eventDepth = gerritConfigurationPage3.eventDepth - 1;
                        throw throwable;
                    }
                    GerritConfigurationPage gerritConfigurationPage4 = GerritConfigurationPage.this;
                    gerritConfigurationPage4.eventDepth = gerritConfigurationPage4.eventDepth - 1;
                }
                GerritConfigurationPage.this.checkPage();
            }
        });
        RepositorySelectionPage.Protocol[] protocolArray = RepositorySelectionPage.Protocol.values();
        int n = protocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            RepositorySelectionPage.Protocol p = protocolArray[n2];
            this.scheme.add(p.getDefaultScheme());
            ++n2;
        }
        this.scheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = GerritConfigurationPage.this.scheme.getSelectionIndex();
                GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setScheme(GerritConfigurationPage.this.scheme.getItem(idx));
                if (RepositorySelectionPage.Protocol.SSH.handles(GerritConfigurationPage.this.pushURI)) {
                    GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setPort(29418);
                } else {
                    GerritConfigurationPage.this.pushURI = GerritConfigurationPage.this.pushURI.setPort(-1);
                }
                GerritConfigurationPage.this.uriText.setText(GerritConfigurationPage.this.pushURI.toString());
                GerritConfigurationPage.this.scheme.setToolTipText(RepositorySelectionPage.Protocol.values()[idx].getTooltip());
            }
        });
    }

    private void createPushConfigurationGroup(Composite panel) {
        this.pushConfigurationGroup = SWTUtils.createHFillGroup(panel, UIText.GerritConfigurationPage_groupPush, -1, 3);
        Label branchLabel = new Label((Composite)this.pushConfigurationGroup, 0);
        branchLabel.setText(UIText.GerritConfigurationPage_labelDestinationBranch);
        Text prefix = new Text((Composite)this.pushConfigurationGroup, 8);
        prefix.setText("refs/for/");
        prefix.setEnabled(false);
        this.branch = SWTUtils.createText((Composite)this.pushConfigurationGroup);
        this.branch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritConfigurationPage.this.checkPage();
            }
        });
        branchLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                GerritConfigurationPage.this.branch.setFocus();
                GerritConfigurationPage.this.branch.selectAll();
            }
        });
        this.addRefContentProposalToText(this.branch);
    }

    private void createFetchConfigurationGroup(Composite panel) {
        this.fetchConfigurationGroup = SWTUtils.createHFillGroup(panel, UIText.GerritConfigurationPage_groupFetch, -1, 2);
        new Label((Composite)this.fetchConfigurationGroup, 0).setText(UIText.GerritConfigurationPage_ConfigureFetchReviewNotes);
    }

    public URIish getURI() {
        return this.pushURI;
    }

    public String getBranch() {
        return this.branch.getText();
    }

    public void setHelpContext(String id) {
        this.helpContext = id;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
    }

    public void setSelection(URIish uri) {
        this.setSelection(uri, null);
    }

    public void setSelection(URIish uri, String targetBranch) {
        this.setDefaults(uri, targetBranch);
        this.checkPage();
    }

    private void setDefaults(URIish uri, String targetBranch) {
        URIish newPushURI = uri;
        if (RepositorySelectionPage.Protocol.SSH.handles(uri)) {
            newPushURI = newPushURI.setPort(29418);
        } else if (RepositorySelectionPage.Protocol.GIT.handles(uri)) {
            newPushURI = newPushURI.setScheme(RepositorySelectionPage.Protocol.SSH.getDefaultScheme());
            newPushURI = newPushURI.setPort(29418);
        }
        this.uriText.setText(newPushURI.toString());
        String uriScheme = newPushURI.getScheme();
        if (uriScheme != null) {
            this.scheme.select(this.scheme.indexOf(uriScheme));
        }
        this.branch.setText(targetBranch != null ? targetBranch : "master");
    }

    private void checkPage() {
        try {
            this.pushURI = new URIish(this.uriText.getText());
            String uriScheme = this.pushURI.getScheme();
            if (uriScheme != null) {
                this.scheme.select(this.scheme.indexOf(uriScheme));
            }
        }
        catch (URISyntaxException e) {
            this.setErrorMessage(e.getLocalizedMessage());
            this.setPageComplete(false);
            return;
        }
        String branchName = this.branch.getText();
        if (branchName.length() == 0) {
            this.setErrorMessage(UIText.GerritConfigurationPage_errorBranchName);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void addRefContentProposalToText(Text textField) {
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke != null) {
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.GerritConfigurationPage_BranchTooltipHover, (Object)stroke.format()));
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                Pattern pattern;
                ArrayList<BranchContentProposal> resultList = new ArrayList<BranchContentProposal>();
                String patternString = contents;
                while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
                    patternString = patternString.substring(1);
                }
                patternString = Pattern.quote(patternString);
                if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
                    patternString = String.valueOf(patternString) + ".*";
                }
                try {
                    pattern = Pattern.compile(patternString, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    pattern = null;
                }
                TreeSet proposals = new TreeSet();
                try {
                    Set remotes = GerritConfigurationPage.this.repository.getRefDatabase().getRefs("refs/remotes/" + GerritConfigurationPage.this.remoteName + "/").keySet();
                    proposals.addAll(remotes);
                }
                catch (IOException iOException) {}
                for (String proposal : proposals) {
                    if (pattern != null && !pattern.matcher(proposal).matches()) continue;
                    BranchContentProposal propsal = new BranchContentProposal(proposal);
                    resultList.add(propsal);
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    private static final class BranchContentProposal
    implements IContentProposal {
        private final String myString;

        BranchContentProposal(String string) {
            this.myString = string;
        }

        public String getContent() {
            return this.myString;
        }

        public int getCursorPosition() {
            return 0;
        }

        public String getDescription() {
            return this.myString;
        }

        public String getLabel() {
            return this.myString;
        }

        public String toString() {
            return this.getContent();
        }
    }
}

