/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.IMultiFix;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CorrectionMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalHasResolutions(marker);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalGetResolutions(marker);
    }

    private static boolean internalHasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
        return cu != null && JavaCorrectionProcessor.hasCorrections(cu, id, MarkerUtilities.getMarkerType((IMarker)marker));
    }

    private static IMarkerResolution[] internalGetResolutions(IMarker marker) {
        IProblemLocation location;
        IEditorInput input;
        if (!CorrectionMarkerResolutionGenerator.internalHasResolutions(marker)) {
            return NO_RESOLUTIONS;
        }
        ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
        if (cu != null && (input = EditorUtility.getEditorInput(cu)) != null && (location = CorrectionMarkerResolutionGenerator.findProblemLocation(input, marker)) != null) {
            AssistContext context = new AssistContext(cu, location.getOffset(), location.getLength());
            if (!CorrectionMarkerResolutionGenerator.hasProblem(context.getASTRoot().getProblems(), location)) {
                return NO_RESOLUTIONS;
            }
            ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
            JavaCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
            Collections.sort(proposals, new CompletionProposalComparator());
            int nProposals = proposals.size();
            IMarkerResolution[] resolutions = new IMarkerResolution[nProposals];
            int i = 0;
            while (i < nProposals) {
                resolutions[i] = new CorrectionMarkerResolution(context.getCompilationUnit(), location.getOffset(), location.getLength(), proposals.get(i), marker);
                ++i;
            }
            return resolutions;
        }
        return NO_RESOLUTIONS;
    }

    private static boolean hasProblem(IProblem[] problems, IProblemLocation location) {
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            if (problem.getID() == location.getProblemId() && problem.getSourceStart() == location.getOffset()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    private static IProblemLocation findProblemLocation(IEditorInput input, IMarker marker) {
        IAnnotationModel model = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(input);
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                Position pos;
                JavaMarkerAnnotation annot;
                Annotation curr = (Annotation)iter.next();
                if (!(curr instanceof JavaMarkerAnnotation) || !marker.equals((Object)(annot = (JavaMarkerAnnotation)curr).getMarker()) || (pos = model.getPosition((Annotation)annot)) == null) continue;
                return new ProblemLocation(pos.getOffset(), pos.getLength(), annot);
            }
        } else {
            ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
            return CorrectionMarkerResolutionGenerator.createFromMarker(marker, cu);
        }
        return null;
    }

    private static IProblemLocation createFromMarker(IMarker marker, ICompilationUnit cu) {
        try {
            int id = marker.getAttribute("id", -1);
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            int severity = marker.getAttribute("severity", 0);
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            String markerType = marker.getType();
            if (cu != null && id != -1 && start != -1 && end != -1 && arguments != null) {
                boolean isError = severity == 2;
                return new ProblemLocation(start, end - start, id, arguments, isError, markerType);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CorrectionMarkerResolution
    extends WorkbenchMarkerResolution {
        private static final IMarker[] NO_MARKERS = new IMarker[0];
        private ICompilationUnit fCompilationUnit;
        private int fOffset;
        private int fLength;
        private IJavaCompletionProposal fProposal;
        private final IMarker fMarker;

        public CorrectionMarkerResolution(ICompilationUnit cu, int offset, int length, IJavaCompletionProposal proposal, IMarker marker) {
            this.fCompilationUnit = cu;
            this.fOffset = offset;
            this.fLength = length;
            this.fProposal = proposal;
            this.fMarker = marker;
        }

        public String getLabel() {
            return this.fProposal.getDisplayString();
        }

        public void run(IMarker marker) {
            try {
                IEditorPart part = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                if (part == null && (part = JavaUI.openInEditor((IJavaElement)this.fCompilationUnit, true, false)) instanceof ITextEditor) {
                    ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                }
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    IDocument doc = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(input);
                    this.fProposal.apply(doc);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        public void run(IMarker[] markers, IProgressMonitor monitor) {
            if (markers.length == 1) {
                this.run(markers[0]);
                return;
            }
            if (!(this.fProposal instanceof FixCorrectionProposal)) {
                return;
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                try {
                    CleanUpRefactoring.MultiFixTarget[] problems = this.getCleanUpTargets(markers);
                    ((FixCorrectionProposal)this.fProposal).resolve(problems, monitor);
                    IEditorPart part = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                    if (part instanceof ITextEditor) {
                        ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                        part.setFocus();
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        private CleanUpRefactoring.MultiFixTarget[] getCleanUpTargets(IMarker[] markers) {
            Hashtable<ICompilationUnit, ArrayList<IProblemLocation>> problemLocations = new Hashtable<ICompilationUnit, ArrayList<IProblemLocation>>();
            int i = 0;
            while (i < markers.length) {
                IEditorInput input;
                IProblemLocation location;
                IMarker marker = markers[i];
                ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
                if (cu != null && (location = CorrectionMarkerResolutionGenerator.findProblemLocation(input = EditorUtility.getEditorInput(cu), marker)) != null) {
                    ArrayList<IProblemLocation> l = (ArrayList<IProblemLocation>)problemLocations.get(cu.getPrimary());
                    if (l == null) {
                        l = new ArrayList<IProblemLocation>();
                        problemLocations.put(cu.getPrimary(), l);
                    }
                    l.add(location);
                }
                ++i;
            }
            CleanUpRefactoring.MultiFixTarget[] result = new CleanUpRefactoring.MultiFixTarget[problemLocations.size()];
            int i2 = 0;
            for (Map.Entry entry : problemLocations.entrySet()) {
                ICompilationUnit cu = (ICompilationUnit)entry.getKey();
                List locations = (List)entry.getValue();
                result[i2] = new CleanUpRefactoring.MultiFixTarget(cu, locations.toArray(new IProblemLocation[locations.size()]));
                ++i2;
            }
            return result;
        }

        public String getDescription() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            if (!(this.fProposal instanceof FixCorrectionProposal)) {
                return NO_MARKERS;
            }
            FixCorrectionProposal fix = (FixCorrectionProposal)this.fProposal;
            ICleanUp cleanUp = fix.getCleanUp();
            if (!(cleanUp instanceof IMultiFix)) {
                return NO_MARKERS;
            }
            IMultiFix multiFix = (IMultiFix)cleanUp;
            Hashtable<IFile, List<IMarker>> fileMarkerTable = this.getMarkersForFiles(markers);
            if (fileMarkerTable.isEmpty()) {
                return NO_MARKERS;
            }
            ArrayList<IMarker> result = new ArrayList<IMarker>();
            for (Map.Entry<IFile, List<IMarker>> entry : fileMarkerTable.entrySet()) {
                IFile file = entry.getKey();
                List<IMarker> fileMarkers = entry.getValue();
                IJavaElement element = JavaCore.create((IFile)file);
                if (!(element instanceof ICompilationUnit)) continue;
                ICompilationUnit unit = (ICompilationUnit)element;
                int i = 0;
                int size = fileMarkers.size();
                while (i < size) {
                    IMarker marker = fileMarkers.get(i);
                    IProblemLocation problem = CorrectionMarkerResolutionGenerator.createFromMarker(marker, unit);
                    if (problem != null && multiFix.canFix(unit, problem)) {
                        result.add(marker);
                    }
                    ++i;
                }
            }
            if (result.size() == 0) {
                return NO_MARKERS;
            }
            return result.toArray(new IMarker[result.size()]);
        }

        private Hashtable<IFile, List<IMarker>> getMarkersForFiles(IMarker[] markers) {
            String markerType;
            Hashtable<IFile, List<IMarker>> result = new Hashtable<IFile, List<IMarker>>();
            try {
                markerType = this.fMarker.getType();
            }
            catch (CoreException e1) {
                JavaPlugin.log(e1);
                return result;
            }
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                if (!marker.equals((Object)this.fMarker)) {
                    IResource res;
                    String currMarkerType = null;
                    try {
                        currMarkerType = marker.getType();
                    }
                    catch (CoreException e1) {
                        JavaPlugin.log(e1);
                    }
                    if (currMarkerType != null && currMarkerType.equals(markerType) && (res = marker.getResource()) instanceof IFile && res.isAccessible()) {
                        List<IMarker> markerList = result.get(res);
                        if (markerList == null) {
                            markerList = new ArrayList<IMarker>();
                            result.put((IFile)res, markerList);
                        }
                        markerList.add(marker);
                    }
                }
                ++i;
            }
            return result;
        }
    }
}

