/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup.containers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class JavaSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private Map<ISourceContainer, PackageFragmentRootSourceContainer> fDelegateContainers;

    public String getSourceName(Object object) throws CoreException {
        return JavaDebugUtils.getSourceName((Object)object);
    }

    public void dispose() {
        for (ISourceContainer iSourceContainer : this.fDelegateContainers.values()) {
            iSourceContainer.dispose();
        }
        this.fDelegateContainers = null;
        super.dispose();
    }

    protected ISourceContainer getDelegateContainer(ISourceContainer container) {
        ISourceContainer delegate = (ISourceContainer)this.fDelegateContainers.get(container);
        if (delegate == null) {
            return container;
        }
        return delegate;
    }

    public void init(ISourceLookupDirector director) {
        super.init(director);
        this.fDelegateContainers = new HashMap<ISourceContainer, PackageFragmentRootSourceContainer>();
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.fDelegateContainers.clear();
        ISourceContainer[] containers = director.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            IFile file;
            IProject project;
            IJavaProject javaProject;
            ISourceContainer container = containers[i];
            if (container.getType().getId().equals(ArchiveSourceContainer.TYPE_ID) && (javaProject = JavaCore.create((IProject)(project = (file = ((ArchiveSourceContainer)container).getFile()).getProject()))).exists()) {
                try {
                    IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        IPackageFragmentRoot root = roots[j];
                        if (file.equals((Object)root.getUnderlyingResource())) {
                            this.fDelegateContainers.put(container, new PackageFragmentRootSourceContainer(root));
                        } else {
                            IPath path = root.getSourceAttachmentPath();
                            if (path != null && file.getFullPath().equals((Object)path)) {
                                this.fDelegateContainers.put(container, new PackageFragmentRootSourceContainer(root));
                            }
                        }
                        ++j;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            ++i;
        }
    }
}

