/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.workspace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.IQ7Extension;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7Model;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.nature.RcpttNature;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.SuperContext;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.scenario.UnresolvedContext;
import org.eclipse.rcptt.core.scenario.UnresolvedVerification;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.scenario.WorkbenchContext;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.internal.core.Q7ExtensionManager;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7Folder;
import org.eclipse.rcptt.internal.core.model.Q7InternalContext;
import org.eclipse.rcptt.internal.core.model.Q7InternalVerification;
import org.eclipse.rcptt.internal.core.model.Q7Model;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class RcpttCore {
    public static final double SCENARIO_VERSION = 3.0;
    public static final String DEFAULT_WORKBENCH_CONTEXT_ID = "close.modal.dialogs";
    private static RcpttCore instance;
    private static String runtimeVersion;

    static {
        runtimeVersion = null;
    }

    public static synchronized RcpttCore getInstance() {
        if (instance == null) {
            IQ7Extension[] exts;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
            if (bundle == null) {
                RcpttPlugin.log("There is no resources support. Q7Core could not be initialized...", null);
                return null;
            }
            instance = new RcpttCore();
            IQ7Extension[] iQ7ExtensionArray = exts = Q7ExtensionManager.getInstance().getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7Extension ext = iQ7ExtensionArray[n2];
                ext.initialize();
                ++n2;
            }
        }
        return instance;
    }

    public static Version getPlatformVersion() {
        return TeslaCore.getPlatformVersion();
    }

    public IContext[] getContexts(IQ7NamedElement element, IWorkspaceFinder finder, boolean ignoreErrors) {
        if (element instanceof ITestCase) {
            return this.getContexts((ITestCase)element, finder, ignoreErrors);
        }
        if (element instanceof IContext) {
            return this.getContexts((IContext)element, finder, ignoreErrors);
        }
        return new IContext[0];
    }

    public IContext[] getContexts(ITestCase scenario, IWorkspaceFinder finder, boolean ignoreErrors) {
        try {
            String[] contexts = Q7SearchCore.findContextsByDocument(scenario);
            if (contexts == null) {
                contexts = scenario.getContexts();
            }
            return this.getContexts(scenario, Arrays.asList(contexts), finder, ignoreErrors);
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
            return new IContext[0];
        }
    }

    public IContext[] getContexts(IContext context, IWorkspaceFinder finder, boolean ignoreErrors) {
        return this.getContexts(context, this.getContextReferences(context), finder, ignoreErrors);
    }

    public IContext[] getContexts(IQ7NamedElement element, List<String> contextIds, IWorkspaceFinder finder, boolean ignoreErrors) {
        if (finder == null) {
            finder = WorkspaceFinder.getInstance();
        }
        ArrayList<IContext> contexts = new ArrayList<IContext>();
        HashSet<String> projectContexts = new HashSet<String>();
        try {
            if (element instanceof ITestCase) {
                String[] ctxs;
                IQ7ProjectMetadata metadata;
                IQ7Project project = element.getQ7Project();
                IQ7ProjectMetadata iQ7ProjectMetadata = metadata = project == null ? null : project.getMetadata();
                if (metadata != null && metadata.exists() && (ctxs = metadata.getContexts()) != null) {
                    String[] stringArray = ctxs;
                    int n = ctxs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ctx = stringArray[n2];
                        IContext result = this.findContext(element, ignoreErrors, ctx, finder);
                        if (result != null) {
                            contexts.add(result);
                            projectContexts.add(result.getID());
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
        }
        for (String contextId : contextIds) {
            IContext result;
            if (projectContexts.contains(contextId) || (result = this.findContext(element, ignoreErrors, contextId, finder)) == null) continue;
            contexts.add(result);
        }
        this.addDefaultContext(contexts);
        return contexts.toArray(new IContext[contexts.size()]);
    }

    public List<String> getContextReferences(IContext context) {
        if (this.isNotGroupOrSuperContext(context)) {
            return new ArrayList<String>();
        }
        try {
            NamedElement namedElement = context.getNamedElement();
            if (namedElement instanceof GroupContext) {
                return ((GroupContext)namedElement).getContextReferences();
            }
            if (namedElement instanceof SuperContext) {
                return ((SuperContext)namedElement).getContextReferences();
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
        }
        return new ArrayList<String>();
    }

    public IVerification[] getVerifications(ITestCase scenario, IWorkspaceFinder finder, boolean ignoreErrors) {
        try {
            String[] verifications = Q7SearchCore.findVerificationsByDocument(scenario);
            if (verifications == null) {
                verifications = scenario.getVerifications();
            }
            return this.getVerifications(scenario, Arrays.asList(verifications), finder, ignoreErrors);
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
            return new IVerification[0];
        }
    }

    public Map<IQ7NamedElement, IFile> getCopyDestinationMap(IQ7NamedElement[] namedElements, IContainer destination) {
        TreeMap<IQ7NamedElement, IFile> result = new TreeMap<IQ7NamedElement, IFile>(new Comparator<IQ7NamedElement>(){

            @Override
            public int compare(IQ7NamedElement o1, IQ7NamedElement o2) {
                if (o1.getName() == null) {
                    return -1;
                }
                int eo = o1.getName().compareTo(o2.getName());
                if (eo == 0) {
                    return o1.equals(o2) ? 0 : -1;
                }
                return eo;
            }
        });
        IQ7NamedElement[] iQ7NamedElementArray = namedElements;
        int n = namedElements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement element = iQ7NamedElementArray[n2];
            IFile destinationFile = this.getDestinationFile(element, destination);
            result.put(element, destinationFile);
            ++n2;
        }
        return result;
    }

    public void copy(final IQ7NamedElement[] elements, final Map<IQ7NamedElement, IFile> destinations, final Map<IQ7NamedElement, String> newNames) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                EList contextIds;
                HashMap<String, String> updatedIds = new HashMap<String, String>();
                ArrayList<ITestCase> scenarios = new ArrayList<ITestCase>();
                ArrayList<IContext> groups = new ArrayList<IContext>();
                ArrayList<ITestSuite> suites = new ArrayList<ITestSuite>();
                IQ7NamedElement[] iQ7NamedElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    String oldID;
                    IQ7NamedElement iQ7NamedElement = iQ7NamedElementArray[n2];
                    if (iQ7NamedElement instanceof ITestCase) {
                        scenarios.add((ITestCase)iQ7NamedElement);
                    } else if (iQ7NamedElement instanceof IContext) {
                        try {
                            IContext context = (IContext)iQ7NamedElement;
                            oldID = context.getID();
                            IContext contextCopy = RcpttCore.this.copyContext(context, (IFile)destinations.get(context), (String)newNames.get(context));
                            updatedIds.put(oldID, contextCopy.getID());
                            if (contextCopy.getNamedElement() instanceof GroupContext) {
                                groups.add(contextCopy);
                            }
                        }
                        catch (IOException e) {
                            RcpttPlugin.log(e);
                        }
                        catch (CoreException e) {
                            RcpttPlugin.log(e);
                        }
                    } else if (iQ7NamedElement instanceof IVerification) {
                        try {
                            IVerification verification = (IVerification)iQ7NamedElement;
                            oldID = verification.getID();
                            IVerification verificationCopy = RcpttCore.this.copyVerification(verification, (IFile)destinations.get(verification), (String)newNames.get(verification));
                            updatedIds.put(oldID, verificationCopy.getID());
                        }
                        catch (IOException e) {
                            RcpttPlugin.log(e);
                        }
                        catch (CoreException e) {
                            RcpttPlugin.log(e);
                        }
                    } else if (iQ7NamedElement instanceof ITestSuite) {
                        try {
                            ITestSuite suite = (ITestSuite)iQ7NamedElement;
                            oldID = suite.getID();
                            ITestSuite suiteCopy = RcpttCore.this.copySuite(suite, (IFile)destinations.get(suite), (String)newNames.get(suite));
                            updatedIds.put(oldID, suiteCopy.getID());
                            suites.add(suiteCopy);
                        }
                        catch (IOException e) {
                            RcpttPlugin.log(e);
                        }
                        catch (CoreException e) {
                            RcpttPlugin.log(e);
                        }
                    }
                    ++n2;
                }
                for (IContext iContext : groups) {
                    try {
                        IContext copy = (IContext)iContext.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                        try {
                            contextIds = ((GroupContext)copy.getNamedElement()).getContextReferences();
                            int i = 0;
                            while (i < contextIds.size()) {
                                String contextId = (String)contextIds.get(i);
                                String newId = (String)updatedIds.get(contextId);
                                if (newId != null) {
                                    contextIds.set(i, (Object)newId);
                                }
                                ++i;
                            }
                            copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            copy.discardWorkingCopy();
                        }
                    }
                    catch (ModelException e) {
                        RcpttPlugin.log((Throwable)((Object)e));
                    }
                }
                for (ITestSuite iTestSuite : suites) {
                    try {
                        ITestSuite copy = (ITestSuite)iTestSuite.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                        try {
                            contextIds = copy.getTestSuite().getItems();
                            int i = 0;
                            while (i < contextIds.size()) {
                                TestSuiteItem testSuiteItem = (TestSuiteItem)contextIds.get(i);
                                String contextId = testSuiteItem.getNamedElementId();
                                String newId = (String)updatedIds.get(contextId);
                                if (newId != null) {
                                    testSuiteItem.setNamedElementId(newId);
                                }
                                ++i;
                            }
                            copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            copy.discardWorkingCopy();
                        }
                    }
                    catch (ModelException e) {
                        RcpttPlugin.log((Throwable)((Object)e));
                    }
                }
                for (IQ7NamedElement iQ7NamedElement : scenarios) {
                    RcpttCore.this.copyScenario((ITestCase)iQ7NamedElement, updatedIds, (IFile)destinations.get(iQ7NamedElement), (String)newNames.get(iQ7NamedElement));
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    public IVerification[] getVerifications(IQ7NamedElement element, List<String> verificationIds, IWorkspaceFinder finder, boolean ignoreErrors) {
        if (finder == null) {
            finder = WorkspaceFinder.getInstance();
        }
        ArrayList<IVerification> verifications = new ArrayList<IVerification>();
        HashSet<String> projectVerifications = new HashSet<String>();
        try {
            if (element != null && element instanceof ITestCase) {
                String[] defaultVerifications;
                IQ7ProjectMetadata metadata;
                IQ7Project project = element.getQ7Project();
                IQ7ProjectMetadata iQ7ProjectMetadata = metadata = project == null ? null : project.getMetadata();
                if (metadata != null && metadata.exists() && (defaultVerifications = metadata.getVerifications()) != null) {
                    String[] stringArray = defaultVerifications;
                    int n = defaultVerifications.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String v = stringArray[n2];
                        IVerification result = this.findVerification(element, ignoreErrors, v, finder);
                        if (result != null) {
                            verifications.add(result);
                            projectVerifications.add(result.getID());
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
        }
        for (String vid : verificationIds) {
            IVerification result;
            if (projectVerifications.contains(vid) || (result = this.findVerification(element, ignoreErrors, vid, finder)) == null) continue;
            verifications.add(result);
        }
        return verifications.toArray(new IVerification[verifications.size()]);
    }

    public IContext findContext(IQ7NamedElement element, boolean ignoreErrors, String contextId, IWorkspaceFinder finder) {
        IContext[] context = finder.findContext(element, contextId);
        IContext result = null;
        if (context != null && context.length > 0) {
            result = context[0];
        } else {
            RcpttPlugin.log("Failed to get context: " + contextId + " for element:" + element.getName(), null);
            if (!ignoreErrors) {
                UnresolvedContext ctx = ScenarioFactory.eINSTANCE.createUnresolvedContext();
                ctx.setName(contextId);
                result = new Q7InternalContext((Q7Folder)element.getParent(), contextId, (Context)ctx);
            }
        }
        return result;
    }

    private IVerification findVerification(IQ7NamedElement element, boolean ignoreErrors, String verificationId, IWorkspaceFinder finder) {
        IVerification[] verification = finder.findVerification(element, verificationId);
        IVerification result = null;
        if (verification != null && verification.length > 0) {
            result = verification[0];
        } else {
            RcpttPlugin.log("Failed to get verification: " + verificationId + " for element:" + element.getName(), null);
            if (!ignoreErrors) {
                UnresolvedVerification unresolved = ScenarioFactory.eINSTANCE.createUnresolvedVerification();
                unresolved.setName(verificationId);
                result = new Q7InternalVerification((Q7Folder)element.getParent(), verificationId, (Verification)unresolved);
            }
        }
        return result;
    }

    private void addDefaultContext(List<IContext> contexts) {
        WorkbenchContext defaultWorkbenchContext = ScenarioFactory.eINSTANCE.createWorkbenchContext();
        defaultWorkbenchContext.setCloseEditors(false);
        defaultWorkbenchContext.setId(DEFAULT_WORKBENCH_CONTEXT_ID);
        defaultWorkbenchContext.setNoModalDialogs(true);
        defaultWorkbenchContext.setResetPerspective(false);
        defaultWorkbenchContext.setName("Close modal dialogs");
        defaultWorkbenchContext.setDescription("");
        defaultWorkbenchContext.setClearClipboard(false);
        contexts.add(0, new Q7InternalContext(ModelManager.getModelManager().getModel(), defaultWorkbenchContext.getName(), (Context)defaultWorkbenchContext));
    }

    private IContext copyContext(IContext context, IFile destinationFile, String newName) throws IOException, CoreException {
        IContext copy = null;
        try {
            copy = (IContext)this.copyNamedElement(context, destinationFile);
            if (newName != null) {
                copy.setElementName(newName);
            }
            copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
        return copy;
    }

    private IVerification copyVerification(IVerification verification, IFile destinationFile, String newName) throws IOException, CoreException {
        IVerification copy = null;
        try {
            copy = (IVerification)this.copyNamedElement(verification, destinationFile);
            if (newName != null) {
                copy.setElementName(newName);
            }
            copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
        return copy;
    }

    private ITestSuite copySuite(ITestSuite context, IFile destinationFile, String newName) throws IOException, CoreException {
        ITestSuite copy = null;
        try {
            copy = (ITestSuite)this.copyNamedElement(context, destinationFile);
            if (newName != null) {
                copy.setElementName(newName);
            }
            copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
        return copy;
    }

    private void copyScenario(ITestCase scenario, Map<String, String> updatedIds, IFile destinationFile, String newName) throws CoreException {
        ITestCase copy = null;
        try {
            copy = (ITestCase)this.copyNamedElement(scenario, destinationFile);
            if (newName != null) {
                copy.setElementName(newName);
            }
            ArrayList<String> contextIds = new ArrayList<String>(Arrays.asList(copy.getContexts()));
            int i = 0;
            while (i < contextIds.size()) {
                String contextId = (String)contextIds.get(i);
                String newContextId = updatedIds.get(contextId);
                if (newContextId != null) {
                    contextIds.set(i, newContextId);
                }
                ++i;
            }
            copy.setContexts(contextIds.toArray(new String[contextIds.size()]));
            ArrayList<String> verificationIds = new ArrayList<String>(Arrays.asList(copy.getVerifications()));
            int i2 = 0;
            while (i2 < verificationIds.size()) {
                String verificationId = (String)verificationIds.get(i2);
                String newVerificationId = updatedIds.get(verificationId);
                if (newVerificationId != null) {
                    verificationIds.set(i2, newVerificationId);
                }
                ++i2;
            }
            copy.setVerifications(verificationIds.toArray(new String[verificationIds.size()]));
            copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    private IQ7NamedElement copyNamedElement(IQ7NamedElement element, IFile destinationFile) throws CoreException, ModelException {
        if (destinationFile != null) {
            if (destinationFile.exists()) {
                destinationFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            element.getResource().copy(destinationFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            destinationFile = (IFile)element.getResource();
        }
        IQ7NamedElement copyTestcase = (IQ7NamedElement)RcpttCore.create((IResource)destinationFile);
        IQ7NamedElement copy = copyTestcase.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        IQ7Folder folder = (IQ7Folder)copy.getParent();
        do {
            copy.setID(EcoreUtil.generateUUID());
        } while (folder.haveIDConflict(copy.getID()));
        return copy;
    }

    private IFile getDestinationFile(IQ7NamedElement element, IContainer destinationContainer) {
        IFile source = (IFile)element.getResource();
        IPath destinationContainerPath = destinationContainer.getFullPath();
        IWorkspace workspace = source.getWorkspace();
        IPath destinationPath = destinationContainerPath.append(source.getName());
        return workspace.getRoot().getFile(destinationPath);
    }

    private RcpttCore() {
    }

    public static boolean hasRcpttNature(IProject project) {
        try {
            return project.isAccessible() && project.isOpen() && RcpttNature.isRcpttProject(project);
        }
        catch (CoreException e) {
            RcpttPlugin.log(e);
            return false;
        }
    }

    public static IProject[] getQ7Projects() {
        IProject[] projects;
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (RcpttCore.hasRcpttNature(iProject)) {
                result.add(iProject);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public IProject[] getNonQ7Projects() {
        IProject[] projects;
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isAccessible() && iProject.isOpen()) {
                try {
                    if (!RcpttNature.isRcpttProject(iProject)) {
                        result.add(iProject);
                    }
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void rename(IFile file, IPath newPath) {
        try {
            file.move(newPath, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static boolean isQ7File(IPath path) {
        String ext = path.getFileExtension();
        return "ctx".equals(ext) || "verification".equals(ext) || "scenario".equals(ext) || "test".equals(ext) || "suite".equals(ext) || RcpttCore.isQ7ProjectMetadata(path);
    }

    public static boolean isQ7Context(IPath path) {
        String ext = path.getFileExtension();
        return "ctx".equals(ext);
    }

    public static boolean isQ7Verification(IPath path) {
        String ext = path.getFileExtension();
        return "verification".equals(ext);
    }

    public static boolean isQ7TestSuite(IPath path) {
        String ext = path.getFileExtension();
        return "suite".equals(ext);
    }

    public static boolean isQ7ProjectMetadata(IPath path) {
        if (Q7Features.supportQ7OptionsFile) {
            return path.segmentCount() == 2 && path.lastSegment().equals("rcptt.properties");
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized String getRuntimeVersion() {
        if (RcpttCore.runtimeVersion != null) {
            return RcpttCore.runtimeVersion;
        }
        runtimeBundleId = "org.eclipse.rcptt.updates.runtime";
        runtimeBundle = Platform.getBundle((String)runtimeBundleId);
        if (runtimeBundle == null) {
            throw new NullPointerException(String.valueOf(runtimeBundleId) + " plugin is not loaded");
        }
        paths = runtimeBundle.getEntryPaths("q7/plugins/");
        if (paths != null) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            path = (String)paths.nextElement();
            ind = path.indexOf(st = "org.eclipse.rcptt.tesla.swt_");
            if (ind <= 0 || !(version = path.substring(ind + st.length()).trim()).endsWith(".jar")) continue;
            if ((version = version.substring(0, version.length() - 4)).endsWith(shot = "-SNAPSHOT")) {
                version = version.substring(0, version.length() - shot.length());
            }
            RcpttCore.runtimeVersion = version;
            break;
lbl17:
            // 2 sources

            ** while (paths.hasMoreElements())
        }
lbl18:
        // 2 sources

        return RcpttCore.runtimeVersion;
    }

    public static IQ7Project create(IProject project) {
        if (project == null) {
            return null;
        }
        Q7Model model = ModelManager.getModelManager().getModel();
        return model.getProject((IResource)project);
    }

    public static IQ7Element create(IResource resource) {
        return ModelManager.create(resource, null);
    }

    public static IQ7Model create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return ModelManager.getModelManager().getModel();
    }

    private static void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        ModelManager.getModelManager().deltaState.addElementChangedListener(listener, eventMask);
    }

    public static void addElementChangedListener(IElementChangedListener listener) {
        RcpttCore.addElementChangedListener(listener, 5);
    }

    public static void removeElementChangedListener(IElementChangedListener listener) {
        ModelManager.getModelManager().deltaState.removeElementChangedListener(listener);
    }

    public void findAllContexts(IQ7NamedElement element, Set<? super IContext> ctx) {
        IContext[] iContextArray = this.getContexts(element, (IWorkspaceFinder)WorkspaceFinder.getInstance(), true);
        int n = iContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContext cx = iContextArray[n2];
            if (!(cx instanceof Q7InternalContext) && ctx.add(cx)) {
                this.findAllContexts(cx, ctx);
            }
            ++n2;
        }
    }

    public void findAllVerifications(IQ7NamedElement element, Set<? super IVerification> verifications) {
        if (element instanceof ITestCase) {
            IVerification[] result = this.getVerifications((ITestCase)element, WorkspaceFinder.getInstance(), true);
            verifications.addAll(Arrays.asList(result));
        }
    }

    public boolean isNotGroupOrSuperContext(IContext context) {
        String type = Q7SearchCore.findContextTypeByDocument(context);
        if (type == null && context != null) {
            try {
                type = context.getType().getId();
            }
            catch (ModelException e) {
                RcpttPlugin.log((Throwable)((Object)e));
            }
        }
        if (type == null) {
            return false;
        }
        return !"org.eclipse.rcptt.ctx.group".equals(type) && !"org.eclipse.rcptt.ctx.super".equals(type);
    }

    public static String getResourcePath(String id) {
        if (id == null) {
            return null;
        }
        IQ7NamedElement element = Q7SearchCore.findById(id);
        if (element == null) {
            return null;
        }
        return element.getResource().getFullPath().toString();
    }
}

