/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.ValidationErrorLevel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class DSAnnotationPropertyPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private static final int OPTIONS_INDENT = 20;
    private Link workspaceLink;
    private Button projectCheckbox;
    private Control configBlockControl;
    private ControlEnableState configBlockEnableState;
    private Button enableCheckbox;
    private Composite optionBlockControl;
    private ControlEnableState optionBlockEnableState;
    private Text pathText;
    private Combo errorLevelCombo;
    private Combo missingUnbindMethodCombo;
    private Button enableBAPLGeneration;
    private IWorkingCopyManager wcManager;

    public void init(IWorkbench workbench) {
    }

    public void setContainer(IPreferencePageContainer container) {
        super.setContainer(container);
        if (this.wcManager == null) {
            this.wcManager = container instanceof IWorkbenchPreferenceContainer ? ((IWorkbenchPreferenceContainer)container).getWorkingCopyManager() : new WorkingCopyManager();
        }
    }

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.projectCheckbox = new Button(composite, 32);
            this.projectCheckbox.setLayoutData((Object)new GridData(1, 128, true, false));
            this.projectCheckbox.setText(Messages.DSAnnotationPropertyPage_projectCheckbox_text);
            this.projectCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DSAnnotationPropertyPage.this.enableProjectSpecificSettings(DSAnnotationPropertyPage.this.projectCheckbox.getSelection());
                    DSAnnotationPropertyPage.this.refreshWidgets();
                }
            });
            this.workspaceLink = this.createLink(composite, Messages.DSAnnotationPropertyPage_workspaceLink_text);
            this.workspaceLink.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        }
        return super.createDescriptionLabel(parent);
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PreferencesUtil.createPreferenceDialogOn((Shell)DSAnnotationPropertyPage.this.getShell(), (String)"org.eclipse.pde.ds.annotations", (String[])new String[]{"org.eclipse.pde.ds.annotations"}, null).open() == 0) {
                    DSAnnotationPropertyPage.this.refreshWidgets();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return link;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.configBlockControl = this.createPreferenceContent(composite);
        this.configBlockControl.setLayoutData((Object)new GridData(1808));
        if (this.isProjectPreferencePage()) {
            boolean useProjectSettings = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(useProjectSettings);
        }
        this.refreshWidgets();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Control createPreferenceContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        this.enableCheckbox = new Button(composite, 32);
        this.enableCheckbox.setLayoutData((Object)new GridData(1, 128, true, false));
        this.enableCheckbox.setText(Messages.DSAnnotationPropertyPage_enableCheckbox_text);
        this.enableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSAnnotationPropertyPage.this.enableOptions(DSAnnotationPropertyPage.this.enableCheckbox.getSelection());
            }
        });
        this.optionBlockControl = new Composite(composite, 0);
        this.optionBlockControl.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginLeft = 20;
        layout.marginWidth = 0;
        this.optionBlockControl.setLayout((Layout)layout);
        this.optionBlockControl.setFont(composite.getFont());
        Label pathLabel = new Label(this.optionBlockControl, 16384);
        pathLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        pathLabel.setText(Messages.DSAnnotationPropertyPage_pathLabel_text);
        this.pathText = new Text(this.optionBlockControl, 2052);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label errorLevelLabel = new Label(this.optionBlockControl, 16384);
        errorLevelLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        errorLevelLabel.setText(Messages.DSAnnotationPropertyPage_errorLevelLabel_text);
        this.errorLevelCombo = new Combo(this.optionBlockControl, 2060);
        this.errorLevelCombo.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.errorLevelCombo.add(Messages.DSAnnotationPropertyPage_errorLevelError);
        this.errorLevelCombo.add(Messages.DSAnnotationPropertyPage_errorLevelWarning);
        this.errorLevelCombo.add(Messages.DSAnnotationPropertyPage_errorLevelIgnore);
        this.errorLevelCombo.select(0);
        Label missingUnbindMethodLabel = new Label(this.optionBlockControl, 16384);
        missingUnbindMethodLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        missingUnbindMethodLabel.setText(Messages.DSAnnotationPropertyPage_missingUnbindMethodLevelLabel_text);
        this.missingUnbindMethodCombo = new Combo(this.optionBlockControl, 2060);
        this.missingUnbindMethodCombo.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.missingUnbindMethodCombo.add(Messages.DSAnnotationPropertyPage_errorLevelError);
        this.missingUnbindMethodCombo.add(Messages.DSAnnotationPropertyPage_errorLevelWarning);
        this.missingUnbindMethodCombo.add(Messages.DSAnnotationPropertyPage_errorLevelIgnore);
        this.missingUnbindMethodCombo.select(0);
        Label enableBAPLGenerationLabel = new Label(this.optionBlockControl, 16384);
        enableBAPLGenerationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        enableBAPLGenerationLabel.setText(Messages.DSAnnotationPropertyPage_enableBAPLGenerationLabel_text);
        this.enableBAPLGeneration = new Button(this.optionBlockControl, 32);
        this.enableBAPLGeneration.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void refreshWidgets() {
        IEclipsePreferences prefs = this.wcManager.getWorkingCopy(InstanceScope.INSTANCE.getNode("org.eclipse.pde.ds.annotations"));
        boolean enableValue = prefs.getBoolean("enabled", false);
        String pathValue = prefs.get("path", "OSGI-INF");
        String errorLevel = prefs.get("validationErrorLevel", ValidationErrorLevel.error.toString());
        String missingUnbindMethodLevel = prefs.get("validationErrorLevel.missingImplicitUnbindMethod", errorLevel);
        boolean generateBAPL = prefs.getBoolean("generateBundleActivationPolicyLazy", true);
        if (this.useProjectSettings()) {
            ProjectScope scopeContext = new ProjectScope(this.getProject());
            prefs = this.wcManager.getWorkingCopy(scopeContext.getNode("org.eclipse.pde.ds.annotations"));
            enableValue = prefs.getBoolean("enabled", enableValue);
            pathValue = prefs.get("path", pathValue);
            errorLevel = prefs.get("validationErrorLevel", errorLevel);
            missingUnbindMethodLevel = prefs.get("validationErrorLevel.missingImplicitUnbindMethod", missingUnbindMethodLevel);
            generateBAPL = prefs.getBoolean("generateBundleActivationPolicyLazy", generateBAPL);
        }
        this.enableCheckbox.setSelection(enableValue);
        this.enableOptions(enableValue && this.configBlockEnableState == null);
        this.pathText.setText(pathValue);
        this.errorLevelCombo.select(this.getEnumIndex(errorLevel, ValidationErrorLevel.values(), 0));
        this.missingUnbindMethodCombo.select(this.getEnumIndex(missingUnbindMethodLevel, ValidationErrorLevel.values(), 0));
        this.enableBAPLGeneration.setSelection(generateBAPL);
        this.setErrorMessage(null);
    }

    private <E extends Enum<E>> int getEnumIndex(String property, E[] values, int defaultIndex) {
        int i = 1;
        while (i < values.length) {
            if (property.equals(String.valueOf(values[i]))) {
                return i;
            }
            ++i;
        }
        return defaultIndex;
    }

    private boolean hasProjectSpecificOptions(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.pde.ds.annotations").get("enabled", null) != null;
    }

    private boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.projectCheckbox != null && this.projectCheckbox.getSelection();
    }

    private boolean isProjectPreferencePage() {
        return this.getElement() != null;
    }

    private void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.projectCheckbox.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
    }

    private void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.configBlockEnableState != null) {
                this.configBlockEnableState.restore();
                this.configBlockEnableState = null;
            }
        } else if (this.configBlockEnableState == null) {
            this.configBlockEnableState = ControlEnableState.disable((Control)this.configBlockControl, Arrays.asList(this.optionBlockControl));
        }
    }

    private void enableOptions(boolean enable) {
        if (enable) {
            if (this.optionBlockEnableState != null) {
                this.optionBlockEnableState.restore();
                this.optionBlockEnableState = null;
            }
        } else if (this.optionBlockEnableState == null) {
            this.optionBlockEnableState = ControlEnableState.disable((Control)this.optionBlockControl);
        }
    }

    private void updateLinkVisibility() {
        if (this.workspaceLink == null || this.workspaceLink.isDisposed()) {
            return;
        }
        this.workspaceLink.setEnabled(!this.useProjectSettings());
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element == null) {
            return null;
        }
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return (IProject)element.getAdapter(IProject.class);
    }

    protected void performDefaults() {
        IScopeContext scopeContext;
        if (this.useProjectSettings()) {
            this.enableProjectSpecificSettings(false);
            scopeContext = new ProjectScope(this.getProject());
        } else {
            scopeContext = InstanceScope.INSTANCE;
        }
        IEclipsePreferences prefs = this.wcManager.getWorkingCopy(scopeContext.getNode("org.eclipse.pde.ds.annotations"));
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                prefs.remove(key);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Unable to restore default values.", (Throwable)e));
        }
        this.refreshWidgets();
        super.performDefaults();
    }

    public boolean performOk() {
        IEclipsePreferences prefs;
        if (this.isProjectPreferencePage()) {
            prefs = this.wcManager.getWorkingCopy(new ProjectScope(this.getProject()).getNode("org.eclipse.pde.ds.annotations"));
            if (!this.useProjectSettings()) {
                try {
                    String[] stringArray = prefs.keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        prefs.remove(key);
                        ++n2;
                    }
                }
                catch (BackingStoreException e) {
                    Activator.log((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Unable to reset project preferences.", (Throwable)e));
                }
                prefs = null;
            }
        } else {
            prefs = this.wcManager.getWorkingCopy(InstanceScope.INSTANCE.getNode("org.eclipse.pde.ds.annotations"));
        }
        if (prefs != null) {
            String path = this.pathText.getText().trim();
            if (!Path.EMPTY.isValidPath(path)) {
                this.setErrorMessage(String.format(Messages.DSAnnotationPropertyPage_errorMessage_path, new Object[0]));
                return false;
            }
            prefs.putBoolean("enabled", this.enableCheckbox.getSelection());
            prefs.put("path", new Path(path).toString());
            ValidationErrorLevel[] levels = ValidationErrorLevel.values();
            int errorLevelIndex = this.errorLevelCombo.getSelectionIndex();
            prefs.put("validationErrorLevel", levels[Math.max(Math.min(errorLevelIndex, levels.length - 1), 0)].toString());
            errorLevelIndex = this.missingUnbindMethodCombo.getSelectionIndex();
            prefs.put("validationErrorLevel.missingImplicitUnbindMethod", levels[Math.max(Math.min(errorLevelIndex, levels.length - 1), 0)].toString());
            prefs.putBoolean("generateBundleActivationPolicyLazy", this.enableBAPLGeneration.getSelection());
        }
        try {
            this.wcManager.applyChanges();
        }
        catch (BackingStoreException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.pde.ds.annotations", "Unable to save preferences.", (Throwable)e));
            return false;
        }
        return true;
    }
}

