/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractivePreferences;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

final class RebaseInteractiveDropTargetListener
extends ViewerDropAdapter {
    private final RebaseInteractiveView rebaseInteractiveView;

    RebaseInteractiveDropTargetListener(RebaseInteractiveView rebaseInteractiveView, Viewer viewer) {
        super(viewer);
        this.rebaseInteractiveView = rebaseInteractiveView;
    }

    public boolean performDrop(Object data) {
        if (!this.rebaseInteractiveView.isDragAndDropEnabled()) {
            return false;
        }
        if (!(data instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)data;
        List selectionList = structuredSelection.toList();
        if (selectionList.contains(this.getCurrentTarget())) {
            return false;
        }
        ArrayList<RebaseInteractivePlan.PlanElement> sourceElements = new ArrayList<RebaseInteractivePlan.PlanElement>();
        for (Object obj : selectionList) {
            if (!(obj instanceof RebaseInteractivePlan.PlanElement)) continue;
            sourceElements.add((RebaseInteractivePlan.PlanElement)obj);
        }
        if (sourceElements.isEmpty()) {
            return false;
        }
        Object targetObj = this.getCurrentTarget();
        if (!(targetObj instanceof RebaseInteractivePlan.PlanElement)) {
            return false;
        }
        RebaseInteractivePlan.PlanElement targetElement = (RebaseInteractivePlan.PlanElement)targetObj;
        boolean before = false;
        switch (this.getCurrentLocation()) {
            case 1: {
                before = true;
                break;
            }
            case 4: {
                return false;
            }
        }
        if (!before) {
            Collections.reverse(sourceElements);
        }
        if (RebaseInteractivePreferences.isOrderReversed()) {
            before = !before;
        }
        for (RebaseInteractivePlan.PlanElement element : sourceElements) {
            this.rebaseInteractiveView.getCurrentPlan().moveTodoEntry(element, targetElement, before);
        }
        return true;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (!this.rebaseInteractiveView.isDragAndDropEnabled()) {
            return false;
        }
        if (this.getCurrentTarget() instanceof RebaseInteractivePlan.PlanElement) {
            switch (this.getCurrentLocation()) {
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
        }
        return false;
    }
}

