/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.tasklist.MarkerUtil;

class TasksFilter
extends ViewerFilter
implements Cloneable {
    public static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.problemmarker", "org.eclipse.core.resources.taskmarker"};
    static final int ON_ANY_RESOURCE = 0;
    static final int ON_SELECTED_RESOURCE_ONLY = 1;
    static final int ON_SELECTED_RESOURCE_AND_CHILDREN = 2;
    static final int ON_ANY_RESOURCE_OF_SAME_PROJECT = 3;
    static final int ON_WORKING_SET = 4;
    static final int FILTER_CONTAINS = 0;
    static final int FILTER_DOES_NOT_CONTAIN = 1;
    static final int DEFAULT_MARKER_LIMIT = 2000;
    String[] types;
    int onResource;
    IWorkingSet workingSet;
    boolean filterOnDescription;
    int descriptionFilterKind;
    String descriptionFilter;
    boolean filterOnSeverity;
    int severityFilter;
    boolean filterOnPriority;
    int priorityFilter;
    boolean filterOnCompletion;
    int completionFilter;
    private boolean filterOnMarkerLimit = true;
    private int markerLimit = 2000;
    private static final String TAG_ID = "id";
    private static final String TAG_TYPE = "type";
    private static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_FILTER_ON_DESCRIPTION = "filterOnDescription";
    private static final String TAG_DESCRIPTION_FILTER_KIND = "descriptionFilterKind";
    private static final String TAG_DESCRIPTION_FILTER = "descriptionFilter";
    private static final String TAG_FILTER_ON_SEVERITY = "filterOnSeverity";
    private static final String TAG_SEVERITY_FILTER = "severityFilter";
    private static final String TAG_FILTER_ON_PRIORITY = "filterOnPriority";
    private static final String TAG_PRIORITY_FILTER = "priorityFilter";
    private static final String TAG_FILTER_ON_COMPLETION = "filterOnCompletion";
    private static final String TAG_COMPLETION_FILTER = "completionFilter";
    private static final String TAG_FILTER_ON_MARKER_LIMIT = "filterOnMarkerLimit";
    private static final String TAG_MARKER_LIMIT = "markerLimit";

    public TasksFilter() {
        this.reset();
    }

    boolean getFilterOnMarkerLimit() {
        return this.filterOnMarkerLimit;
    }

    void setFilterOnMarkerLimit(boolean filterOnMarkerLimit) {
        this.filterOnMarkerLimit = filterOnMarkerLimit;
    }

    int getMarkerLimit() {
        return this.markerLimit;
    }

    void setMarkerLimit(int markerLimit) {
        if (markerLimit < 1) {
            markerLimit = 2000;
        }
        this.markerLimit = markerLimit;
    }

    boolean checkDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        boolean contains = this.containsSubstring(desc, this.descriptionFilter);
        return this.descriptionFilterKind == 0 ? contains : !contains;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    boolean containsSubstring(String string, String substring) {
        int strLen = string.length();
        int subLen = substring.length();
        int len = strLen - subLen;
        int i = 0;
        while (i <= len) {
            if (string.regionMatches(true, i, substring, 0, subLen)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosed(IResource element) {
        IPath elementPath = element.getFullPath();
        IAdaptable[] workingSetElements = this.workingSet.getElements();
        if (elementPath.isEmpty() || elementPath.isRoot()) {
            return false;
        }
        int i = 0;
        while (i < workingSetElements.length) {
            IAdaptable workingSetElement = workingSetElements[i];
            IContainmentAdapter containmentAdapter = (IContainmentAdapter)workingSetElement.getAdapter(IContainmentAdapter.class);
            if (containmentAdapter != null ? containmentAdapter.contains((Object)workingSetElement, (Object)element, 11) : this.isEnclosedResource(element, elementPath, workingSetElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosedResource(IResource element, IPath elementPath, IAdaptable workingSetElement) {
        IPath resourcePath;
        if (workingSetElement.equals(element)) {
            return true;
        }
        IResource workingSetResource = (IResource)Adapters.adapt((Object)workingSetElement, IResource.class);
        return workingSetResource != null && (resourcePath = workingSetResource.getFullPath()).isPrefixOf(elementPath);
    }

    public void reset() {
        this.types = ROOT_TYPES;
        this.onResource = 0;
        this.filterOnDescription = false;
        this.descriptionFilter = "";
        this.filterOnSeverity = false;
        this.severityFilter = 0;
        this.filterOnPriority = false;
        this.priorityFilter = 0;
        this.filterOnCompletion = false;
        this.completionFilter = 0;
        this.filterOnMarkerLimit = true;
        this.markerLimit = 2000;
    }

    public void restoreState(IMemento memento) {
        IMemento[] children = memento.getChildren(TAG_TYPE);
        this.types = new String[children.length];
        int i = 0;
        while (i < children.length) {
            this.types[i] = children[i].getString(TAG_ID);
            ++i;
        }
        Integer ival = memento.getInteger(TAG_ON_RESOURCE);
        this.onResource = ival == null ? 0 : ival;
        this.restoreWorkingSet(memento.getString(TAG_WORKING_SET));
        ival = memento.getInteger(TAG_FILTER_ON_DESCRIPTION);
        this.filterOnDescription = ival != null && ival == 1;
        ival = memento.getInteger(TAG_DESCRIPTION_FILTER_KIND);
        this.descriptionFilterKind = ival == null ? 0 : ival;
        this.descriptionFilter = memento.getString(TAG_DESCRIPTION_FILTER);
        if (this.descriptionFilter == null) {
            this.descriptionFilter = "";
        }
        this.filterOnSeverity = (ival = memento.getInteger(TAG_FILTER_ON_SEVERITY)) != null && ival == 1;
        ival = memento.getInteger(TAG_SEVERITY_FILTER);
        this.severityFilter = ival == null ? 0 : ival;
        ival = memento.getInteger(TAG_FILTER_ON_PRIORITY);
        this.filterOnPriority = ival != null && ival == 1;
        ival = memento.getInteger(TAG_PRIORITY_FILTER);
        this.priorityFilter = ival == null ? 0 : ival;
        ival = memento.getInteger(TAG_FILTER_ON_COMPLETION);
        this.filterOnCompletion = ival != null && ival == 1;
        ival = memento.getInteger(TAG_COMPLETION_FILTER);
        this.completionFilter = ival == null ? 0 : ival;
        ival = memento.getInteger(TAG_FILTER_ON_MARKER_LIMIT);
        this.filterOnMarkerLimit = ival == null || ival == 1;
        ival = memento.getInteger(TAG_MARKER_LIMIT);
        this.markerLimit = ival == null ? 2000 : ival;
    }

    private void restoreWorkingSet(String workingSetName) {
        IWorkingSetManager workingSetManager;
        IWorkingSet workingSet;
        if (workingSetName != null && (workingSet = (workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager()).getWorkingSet(workingSetName)) != null) {
            this.workingSet = workingSet;
        }
    }

    public void saveState(IMemento memento) {
        int i = 0;
        while (i < this.types.length) {
            memento.createChild(TAG_TYPE).putString(TAG_ID, this.types[i]);
            ++i;
        }
        memento.putInteger(TAG_ON_RESOURCE, this.onResource);
        if (this.workingSet != null) {
            memento.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
        memento.putInteger(TAG_FILTER_ON_DESCRIPTION, this.filterOnDescription ? 1 : 0);
        memento.putInteger(TAG_DESCRIPTION_FILTER_KIND, this.descriptionFilterKind);
        memento.putString(TAG_DESCRIPTION_FILTER, this.descriptionFilter);
        memento.putInteger(TAG_FILTER_ON_SEVERITY, this.filterOnSeverity ? 1 : 0);
        memento.putInteger(TAG_SEVERITY_FILTER, this.severityFilter);
        memento.putInteger(TAG_FILTER_ON_PRIORITY, this.filterOnPriority ? 1 : 0);
        memento.putInteger(TAG_PRIORITY_FILTER, this.priorityFilter);
        memento.putInteger(TAG_FILTER_ON_COMPLETION, this.filterOnCompletion ? 1 : 0);
        memento.putInteger(TAG_COMPLETION_FILTER, this.completionFilter);
        memento.putInteger(TAG_FILTER_ON_MARKER_LIMIT, this.filterOnMarkerLimit ? 1 : 0);
        memento.putInteger(TAG_MARKER_LIMIT, this.markerLimit);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.select((IMarker)element);
    }

    public boolean select(IMarker marker) {
        return this.selectByType(marker) && this.selectByAttributes(marker) && this.selectByWorkingSet(marker);
    }

    public boolean select(IMarkerDelta markerDelta) {
        return this.selectByType(markerDelta) && this.selectByAttributes(markerDelta) && this.selectByWorkingSet(markerDelta);
    }

    private boolean selectByType(IMarker marker) {
        int i = 0;
        while (i < this.types.length) {
            if (MarkerUtil.isMarkerType(marker, this.types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean selectByType(IMarkerDelta markerDelta) {
        int i = 0;
        while (i < this.types.length) {
            if (markerDelta.isSubtypeOf(this.types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean selectByWorkingSet(IMarker marker) {
        if (this.workingSet == null || this.onResource != 4) {
            return true;
        }
        IResource resource = marker.getResource();
        if (resource != null) {
            return this.isEnclosed(resource);
        }
        return false;
    }

    private boolean selectByWorkingSet(IMarkerDelta markerDelta) {
        if (this.workingSet == null || this.onResource != 4) {
            return true;
        }
        IResource resource = markerDelta.getResource();
        if (resource != null) {
            return this.isEnclosed(resource);
        }
        return false;
    }

    private boolean selectByAttributes(IMarker marker) {
        String desc;
        int sev;
        if (this.filterOnSeverity && MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.problemmarker") && (this.severityFilter & 1 << (sev = MarkerUtil.getSeverity(marker))) == 0) {
            return false;
        }
        if ((this.filterOnPriority || this.filterOnCompletion) && MarkerUtil.isMarkerType(marker, "org.eclipse.core.resources.taskmarker")) {
            boolean complete;
            int pri;
            if (this.filterOnPriority && (this.priorityFilter & 1 << (pri = MarkerUtil.getPriority(marker))) == 0) {
                return false;
            }
            if (this.filterOnCompletion && (this.completionFilter & ((complete = MarkerUtil.isComplete(marker)) ? 2 : 1)) == 0) {
                return false;
            }
        }
        return !this.filterOnDescription || this.checkDescription(desc = MarkerUtil.getMessage(marker));
    }

    private boolean selectByAttributes(IMarkerDelta markerDelta) {
        String desc;
        int sev;
        if (this.filterOnSeverity && markerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker") && (this.severityFilter & 1 << (sev = markerDelta.getAttribute("severity", 1))) == 0) {
            return false;
        }
        if ((this.filterOnPriority || this.filterOnCompletion) && markerDelta.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            boolean complete;
            int pri;
            if (this.filterOnPriority && (this.priorityFilter & 1 << (pri = markerDelta.getAttribute("priority", 1))) == 0) {
                return false;
            }
            if (this.filterOnCompletion && (this.completionFilter & ((complete = markerDelta.getAttribute("done", false)) ? 2 : 1)) == 0) {
                return false;
            }
        }
        return !this.filterOnDescription || this.checkDescription(desc = markerDelta.getAttribute("message", ""));
    }

    public boolean isShowingAll() {
        if (this.filterOnDescription || this.filterOnSeverity || this.filterOnPriority || this.filterOnCompletion) {
            return false;
        }
        if (this.onResource != 0) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(this.types));
        if (set.size() != ROOT_TYPES.length) {
            return false;
        }
        int i = 0;
        while (i < ROOT_TYPES.length) {
            if (!set.contains(ROOT_TYPES[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

