/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;

public class OpenableElementInfo
extends JavaElementInfo {
    protected volatile IJavaElement[] children = JavaElement.NO_ELEMENTS;
    protected boolean isStructureKnown = false;

    public void addChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int length = oldChildren.length;
        if (length == 0) {
            this.children = new IJavaElement[]{child};
        } else {
            int i = 0;
            while (i < length) {
                if (oldChildren[i].equals(child)) {
                    return;
                }
                ++i;
            }
            IJavaElement[] newChildren = new IJavaElement[length + 1];
            System.arraycopy(oldChildren, 0, newChildren, 0, length);
            newChildren[length] = child;
            this.children = newChildren;
        }
    }

    @Override
    public IJavaElement[] getChildren() {
        return this.children;
    }

    public boolean isStructureKnown() {
        return this.isStructureKnown;
    }

    public void removeChild(IJavaElement child) {
        IJavaElement[] oldChildren = this.children;
        int i = 0;
        int length = oldChildren.length;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                if (length == 1) {
                    this.children = JavaElement.NO_ELEMENTS;
                    break;
                }
                IJavaElement[] newChildren = new IJavaElement[length - 1];
                System.arraycopy(oldChildren, 0, newChildren, 0, i);
                if (i < length - 1) {
                    System.arraycopy(oldChildren, i + 1, newChildren, i, length - 1 - i);
                }
                this.children = newChildren;
                break;
            }
            ++i;
        }
    }

    public void setChildren(IJavaElement[] children) {
        this.children = children;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.isStructureKnown = newIsStructureKnown;
    }
}

