/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class FakedTrackingVariable
extends LocalDeclaration {
    private static final int CLOSE_SEEN = 1;
    private static final int SHARED_WITH_OUTSIDE = 2;
    private static final int OWNED_BY_OUTSIDE = 4;
    private static final int CLOSED_IN_NESTED_METHOD = 8;
    private static final int REPORTED_EXPLICIT_CLOSE = 16;
    private static final int REPORTED_POTENTIAL_LEAK = 32;
    private static final int REPORTED_DEFINITIVE_LEAK = 64;
    public static boolean TEST_372319 = false;
    private int globalClosingState = 0;
    public LocalVariableBinding originalBinding;
    public FakedTrackingVariable innerTracker;
    public FakedTrackingVariable outerTracker;
    MethodScope methodScope;
    private HashMap recordedLocations;
    private ASTNode currentAssignment;

    public FakedTrackingVariable(LocalVariableBinding original, ASTNode location) {
        super(original.name, location.sourceStart, location.sourceEnd);
        this.type = new SingleTypeReference(TypeConstants.OBJECT, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        this.methodScope = original.declaringScope.methodScope();
        this.originalBinding = original;
        this.resolve(original.declaringScope);
    }

    private FakedTrackingVariable(BlockScope scope, ASTNode location) {
        super("<unassigned Closeable value>".toCharArray(), location.sourceStart, location.sourceEnd);
        this.type = new SingleTypeReference(TypeConstants.OBJECT, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        this.methodScope = scope.methodScope();
        this.originalBinding = null;
        this.resolve(scope);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
    }

    public void resolve(BlockScope scope) {
        this.binding = new LocalVariableBinding(this.name, (TypeBinding)scope.getJavaLangObject(), 0, false);
        this.binding.closeTracker = this;
        this.binding.declaringScope = scope;
        this.binding.setConstant(Constant.NotAConstant);
        this.binding.useFlag = 1;
        this.binding.id = scope.registerTrackingVariable(this);
    }

    public static FakedTrackingVariable getCloseTrackingVariable(Expression expression) {
        while (true) {
            if (expression instanceof CastExpression) {
                expression = ((CastExpression)expression).expression;
                continue;
            }
            if (!(expression instanceof Assignment)) break;
            expression = ((Assignment)expression).expression;
        }
        if (expression instanceof SingleNameReference) {
            SingleNameReference name = (SingleNameReference)expression;
            if (name.binding instanceof LocalVariableBinding) {
                LocalVariableBinding local = (LocalVariableBinding)name.binding;
                if (local.closeTracker != null) {
                    return local.closeTracker;
                }
                if (!FakedTrackingVariable.isAnyCloseable(expression.resolvedType)) {
                    return null;
                }
                LocalDeclaration location = local.declaration;
                local.closeTracker = new FakedTrackingVariable(local, (ASTNode)location);
                if (local.isParameter()) {
                    local.closeTracker.globalClosingState |= 4;
                }
                return local.closeTracker;
            }
        } else if (expression instanceof AllocationExpression) {
            return ((AllocationExpression)expression).closeTracker;
        }
        return null;
    }

    public static void preConnectTrackerAcrossAssignment(ASTNode location, LocalVariableBinding local, Expression rhs) {
        FakedTrackingVariable closeTracker = null;
        if (rhs instanceof AllocationExpression) {
            closeTracker = local.closeTracker;
            if (closeTracker == null && rhs.resolvedType != TypeBinding.NULL) {
                closeTracker = new FakedTrackingVariable(local, location);
                if (local.isParameter()) {
                    closeTracker.globalClosingState |= 4;
                }
            }
            if (closeTracker != null) {
                closeTracker.currentAssignment = location;
                AllocationExpression allocation = (AllocationExpression)rhs;
                allocation.closeTracker = closeTracker;
                if (allocation.arguments != null && allocation.arguments.length > 0) {
                    FakedTrackingVariable.preConnectTrackerAcrossAssignment(location, local, allocation.arguments[0]);
                }
            }
        }
    }

    public static void analyseCloseableAllocation(BlockScope scope, FlowInfo flowInfo, AllocationExpression allocation) {
        if (((ReferenceBinding)allocation.resolvedType).hasTypeBit(8)) {
            if (allocation.closeTracker != null) {
                scope.removeTrackingVar(allocation.closeTracker);
                allocation.closeTracker = null;
            }
        } else if (((ReferenceBinding)allocation.resolvedType).hasTypeBit(4)) {
            boolean isWrapper = true;
            if (allocation.arguments != null && allocation.arguments.length > 0) {
                FakedTrackingVariable innerTracker = FakedTrackingVariable.findCloseTracker(scope, flowInfo, allocation.arguments[0]);
                if (innerTracker != null) {
                    int finallyStatus;
                    FakedTrackingVariable currentInner = innerTracker;
                    do {
                        if (currentInner != allocation.closeTracker) continue;
                        return;
                    } while ((currentInner = currentInner.innerTracker) != null);
                    int newStatus = 2;
                    if (allocation.closeTracker == null) {
                        allocation.closeTracker = new FakedTrackingVariable(scope, (ASTNode)allocation);
                    } else if (scope.finallyInfo != null && (finallyStatus = scope.finallyInfo.nullStatus(allocation.closeTracker.binding)) != 1) {
                        newStatus = finallyStatus;
                    }
                    allocation.closeTracker.innerTracker = innerTracker;
                    innerTracker.outerTracker = allocation.closeTracker;
                    flowInfo.markNullStatus(allocation.closeTracker.binding, newStatus);
                    if (newStatus != 2) {
                        FakedTrackingVariable currentTracker = innerTracker;
                        while (currentTracker != null) {
                            flowInfo.markNullStatus(currentTracker.binding, newStatus);
                            currentTracker.globalClosingState |= allocation.closeTracker.globalClosingState;
                            currentTracker = currentTracker.innerTracker;
                        }
                    }
                    return;
                }
                if (!FakedTrackingVariable.isAnyCloseable(allocation.arguments[0].resolvedType)) {
                    isWrapper = false;
                }
            } else {
                isWrapper = false;
            }
            if (isWrapper) {
                if (allocation.closeTracker != null) {
                    scope.removeTrackingVar(allocation.closeTracker);
                    allocation.closeTracker = null;
                }
            } else {
                FakedTrackingVariable.handleRegularResource(scope, flowInfo, allocation);
            }
        } else {
            FakedTrackingVariable.handleRegularResource(scope, flowInfo, allocation);
        }
    }

    private static void handleRegularResource(BlockScope scope, FlowInfo flowInfo, AllocationExpression allocation) {
        FakedTrackingVariable presetTracker = allocation.closeTracker;
        if (presetTracker != null && presetTracker.originalBinding != null) {
            int closeStatus = flowInfo.nullStatus(presetTracker.binding);
            if (closeStatus != 4 && closeStatus != 1 && !flowInfo.isDefinitelyNull(presetTracker.originalBinding) && !(presetTracker.currentAssignment instanceof LocalDeclaration)) {
                allocation.closeTracker.recordErrorLocation(presetTracker.currentAssignment, closeStatus);
            }
        } else {
            allocation.closeTracker = new FakedTrackingVariable(scope, (ASTNode)allocation);
        }
        flowInfo.markAsDefinitelyNull(allocation.closeTracker.binding);
    }

    private static FakedTrackingVariable findCloseTracker(BlockScope scope, FlowInfo flowInfo, Expression arg) {
        while (arg instanceof Assignment) {
            Assignment assign = (Assignment)arg;
            LocalVariableBinding innerLocal = assign.localVariableBinding();
            if (innerLocal != null) {
                return innerLocal.closeTracker;
            }
            arg = assign.expression;
        }
        if (arg instanceof SingleNameReference) {
            LocalVariableBinding local = arg.localVariableBinding();
            if (local != null) {
                return local.closeTracker;
            }
        } else if (arg instanceof AllocationExpression) {
            return ((AllocationExpression)arg).closeTracker;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void handleResourceAssignment(BlockScope scope, FlowInfo upstreamInfo, FlowInfo flowInfo, ASTNode location, Expression rhs, LocalVariableBinding local) {
        block16: {
            block17: {
                block18: {
                    previousTracker = null;
                    disconnectedTracker = null;
                    if (local.closeTracker != null) {
                        previousTracker = local.closeTracker;
                        nullStatus = upstreamInfo.nullStatus(local);
                        if (nullStatus != 2 && nullStatus != 1) {
                            disconnectedTracker = previousTracker;
                        }
                    }
                    if (rhs.resolvedType == TypeBinding.NULL) break block16;
                    rhsTrackVar = FakedTrackingVariable.getCloseTrackingVariable(rhs);
                    if (rhsTrackVar == null) break block17;
                    if (local.closeTracker != null) break block18;
                    if (rhsTrackVar.originalBinding != null) {
                        local.closeTracker = rhsTrackVar;
                    }
                    if (rhsTrackVar.currentAssignment == location) {
                        rhsTrackVar.globalClosingState &= -7;
                    }
                    break block16;
                }
                if (!(rhs instanceof AllocationExpression)) ** GOTO lbl-1000
                if (rhsTrackVar == disconnectedTracker) {
                    return;
                }
                if (local.closeTracker == rhsTrackVar && (rhsTrackVar.globalClosingState & 4) != 0) {
                    local.closeTracker = new FakedTrackingVariable(local, location);
                    flowInfo.markAsDefinitelyNull(local.closeTracker.binding);
                } else lbl-1000:
                // 2 sources

                {
                    local.closeTracker = rhsTrackVar;
                }
                break block16;
            }
            if (previousTracker != null) {
                if ((previousTracker.globalClosingState & 6) == 0) {
                    flowInfo.markAsDefinitelyNull(previousTracker.binding);
                }
                local.closeTracker = FakedTrackingVariable.analyseCloseableExpression(flowInfo, local, location, rhs, previousTracker);
            } else {
                rhsTrackVar = FakedTrackingVariable.analyseCloseableExpression(flowInfo, local, location, rhs, null);
                if (rhsTrackVar != null) {
                    local.closeTracker = rhsTrackVar;
                    if ((rhsTrackVar.globalClosingState & 6) == 0) {
                        flowInfo.markAsDefinitelyNull(rhsTrackVar.binding);
                    }
                }
            }
        }
        if (disconnectedTracker != null) {
            if (disconnectedTracker.innerTracker != null && disconnectedTracker.innerTracker.binding.declaringScope == scope) {
                disconnectedTracker.innerTracker.outerTracker = null;
                scope.pruneWrapperTrackingVar(disconnectedTracker);
            } else {
                upstreamStatus = upstreamInfo.nullStatus(disconnectedTracker.binding);
                if (upstreamStatus != 4) {
                    disconnectedTracker.recordErrorLocation(location, upstreamStatus);
                }
            }
        }
    }

    private static FakedTrackingVariable analyseCloseableExpression(FlowInfo flowInfo, LocalVariableBinding local, ASTNode location, Expression expression, FakedTrackingVariable previousTracker) {
        ReferenceBinding resourceType;
        while (true) {
            if (expression instanceof Assignment) {
                expression = ((Assignment)expression).expression;
                continue;
            }
            if (!(expression instanceof CastExpression)) break;
            expression = ((CastExpression)expression).expression;
        }
        if (expression instanceof AllocationExpression) {
            FakedTrackingVariable tracker = ((AllocationExpression)expression).closeTracker;
            if (tracker != null && tracker.originalBinding == null) {
                return null;
            }
            return tracker;
        }
        if (expression instanceof MessageSend || expression instanceof ArrayReference) {
            FakedTrackingVariable tracker = new FakedTrackingVariable(local, location);
            tracker.globalClosingState |= 2;
            flowInfo.markPotentiallyNullBit(tracker.binding);
            return tracker;
        }
        if ((expression.bits & 7) == 1 || expression instanceof QualifiedNameReference && ((QualifiedNameReference)expression).isFieldAccess()) {
            FakedTrackingVariable tracker = new FakedTrackingVariable(local, location);
            tracker.globalClosingState |= 4;
            return tracker;
        }
        if (expression.resolvedType instanceof ReferenceBinding && (resourceType = (ReferenceBinding)expression.resolvedType).hasTypeBit(8)) {
            return null;
        }
        if (local.closeTracker != null) {
            return local.closeTracker;
        }
        FakedTrackingVariable newTracker = new FakedTrackingVariable(local, location);
        LocalVariableBinding rhsLocal = expression.localVariableBinding();
        if (rhsLocal != null && rhsLocal.isParameter()) {
            newTracker.globalClosingState |= 4;
        }
        return newTracker;
    }

    public static void cleanUpAfterAssignment(BlockScope currentScope, int lhsBits, Expression expression) {
        while (true) {
            if (expression instanceof Assignment) {
                expression = ((Assignment)expression).expression;
                continue;
            }
            if (!(expression instanceof CastExpression)) break;
            expression = ((CastExpression)expression).expression;
        }
        if (expression instanceof AllocationExpression) {
            FakedTrackingVariable tracker = ((AllocationExpression)expression).closeTracker;
            if (tracker != null && tracker.originalBinding == null) {
                currentScope.removeTrackingVar(tracker);
                ((AllocationExpression)expression).closeTracker = null;
            }
        } else {
            LocalVariableBinding local = expression.localVariableBinding();
            if (local != null && local.closeTracker != null && (lhsBits & 1) != 0) {
                currentScope.removeTrackingVar(local.closeTracker);
            }
        }
    }

    public static boolean isAnyCloseable(TypeBinding typeBinding) {
        return typeBinding instanceof ReferenceBinding && ((ReferenceBinding)typeBinding).hasTypeBit(3);
    }

    public int findMostSpecificStatus(FlowInfo flowInfo, BlockScope currentScope, BlockScope locationScope) {
        int status = 1;
        FakedTrackingVariable currentTracker = this;
        while (currentTracker != null) {
            LocalVariableBinding currentVar = currentTracker.binding;
            int currentStatus = this.getNullStatusAggressively(currentVar, flowInfo);
            if (locationScope != null) {
                currentStatus = this.mergeCloseStatus(locationScope, currentStatus, currentVar, currentScope);
            }
            if (currentStatus == 4) {
                status = currentStatus;
                break;
            }
            if (status == 2 || status == 1) {
                status = currentStatus;
            }
            currentTracker = currentTracker.innerTracker;
        }
        return status;
    }

    private int getNullStatusAggressively(LocalVariableBinding local, FlowInfo flowInfo) {
        if (flowInfo == FlowInfo.DEAD_END) {
            return 1;
        }
        int reachMode = flowInfo.reachMode();
        int status = 0;
        try {
            if (reachMode != 0) {
                flowInfo.tagBits &= 0xFFFFFFFC;
            }
            status = flowInfo.nullStatus(local);
            if (TEST_372319) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            flowInfo.tagBits |= reachMode;
        }
        if ((status & 2) != 0) {
            if ((status & 0x24) != 0) {
                return 16;
            }
            return 2;
        }
        if ((status & 4) != 0) {
            if ((status & 0x10) != 0) {
                return 16;
            }
            return 4;
        }
        if ((status & 0x10) != 0) {
            return 16;
        }
        return status;
    }

    public int mergeCloseStatus(BlockScope currentScope, int status, LocalVariableBinding local, BlockScope outerScope) {
        if (status != 4) {
            if (currentScope.finallyInfo != null) {
                int finallyStatus = currentScope.finallyInfo.nullStatus(local);
                if (finallyStatus == 4) {
                    return finallyStatus;
                }
                if (finallyStatus != 2) {
                    status = 16;
                }
            }
            if (currentScope != outerScope && currentScope.parent instanceof BlockScope) {
                return this.mergeCloseStatus((BlockScope)currentScope.parent, status, local, outerScope);
            }
        }
        return status;
    }

    public void markClose(FlowInfo flowInfo, FlowContext flowContext) {
        FakedTrackingVariable current = this;
        do {
            flowInfo.markAsDefinitelyNonNull(current.binding);
            current.globalClosingState |= 1;
            if (flowContext.initsOnFinally == null) continue;
            flowContext.initsOnFinally.markAsDefinitelyNonNull(this.binding);
        } while ((current = current.innerTracker) != null);
    }

    public void markClosedInNestedMethod() {
        this.globalClosingState |= 8;
    }

    public static FlowInfo markPassedToOutside(BlockScope scope, Expression expression, FlowInfo flowInfo, boolean owned) {
        FakedTrackingVariable trackVar = FakedTrackingVariable.getCloseTrackingVariable(expression);
        if (trackVar != null) {
            FlowInfo infoResourceIsClosed = owned ? flowInfo : flowInfo.copy();
            int flag = owned ? 4 : 2;
            do {
                trackVar.globalClosingState |= flag;
                if (scope.methodScope() != trackVar.methodScope) {
                    trackVar.globalClosingState |= 8;
                }
                infoResourceIsClosed.markAsDefinitelyNonNull(trackVar.binding);
            } while ((trackVar = trackVar.innerTracker) != null);
            if (owned) {
                return infoResourceIsClosed;
            }
            return FlowInfo.conditional(flowInfo, infoResourceIsClosed);
        }
        return flowInfo;
    }

    public static FakedTrackingVariable pickVarForReporting(Set varsOfScope, BlockScope scope, boolean atExit) {
        if (varsOfScope.isEmpty()) {
            return null;
        }
        FakedTrackingVariable trackingVar = (FakedTrackingVariable)varsOfScope.iterator().next();
        while (trackingVar.outerTracker != null) {
            BlockScope outerTrackerScope;
            if (varsOfScope.contains(trackingVar.outerTracker)) {
                trackingVar = trackingVar.outerTracker;
                continue;
            }
            if (atExit || (outerTrackerScope = trackingVar.outerTracker.binding.declaringScope) == scope) break;
            Scope currentScope = scope;
            while ((currentScope = currentScope.parent) instanceof BlockScope) {
                if (outerTrackerScope != currentScope) continue;
                varsOfScope.remove(trackingVar);
                return FakedTrackingVariable.pickVarForReporting(varsOfScope, scope, atExit);
            }
            break block0;
        }
        varsOfScope.remove(trackingVar);
        return trackingVar;
    }

    public boolean hasDefinitelyNoResource(FlowInfo flowInfo) {
        if (this.originalBinding == null) {
            return false;
        }
        if (flowInfo.isDefinitelyNull(this.originalBinding)) {
            return true;
        }
        return !flowInfo.isDefinitelyAssigned(this.originalBinding) && !flowInfo.isPotentiallyAssigned(this.originalBinding);
    }

    public boolean isClosedInFinallyOfEnclosing(BlockScope scope) {
        BlockScope currentScope = scope;
        while (currentScope.finallyInfo == null || !currentScope.finallyInfo.isDefinitelyNonNull(this.binding)) {
            if (!(currentScope.parent instanceof BlockScope)) {
                return false;
            }
            currentScope = (BlockScope)currentScope.parent;
        }
        return true;
    }

    public boolean isResourceBeingReturned(FakedTrackingVariable returnedResource) {
        FakedTrackingVariable current = this;
        do {
            if (current != returnedResource) continue;
            this.globalClosingState |= 0x40;
            return true;
        } while ((current = current.innerTracker) != null);
        return false;
    }

    public void recordErrorLocation(ASTNode location, int nullStatus) {
        if ((this.globalClosingState & 4) != 0) {
            return;
        }
        if (this.recordedLocations == null) {
            this.recordedLocations = new HashMap();
        }
        this.recordedLocations.put(location, new Integer(nullStatus));
    }

    public boolean reportRecordedErrors(Scope scope, int mergedStatus) {
        FakedTrackingVariable current = this;
        while (current.globalClosingState == 0) {
            current = current.innerTracker;
            if (current != null) continue;
            this.reportError(scope.problemReporter(), null, mergedStatus);
            return true;
        }
        boolean hasReported = false;
        if (this.recordedLocations != null) {
            Iterator locations = this.recordedLocations.entrySet().iterator();
            int reportFlags = 0;
            while (locations.hasNext()) {
                Map.Entry entry = locations.next();
                reportFlags |= this.reportError(scope.problemReporter(), (ASTNode)entry.getKey(), (Integer)entry.getValue());
                hasReported = true;
            }
            if (reportFlags != 0) {
                current = this;
                do {
                    current.globalClosingState |= reportFlags;
                } while ((current = current.innerTracker) != null);
            }
        }
        return hasReported;
    }

    public int reportError(ProblemReporter problemReporter, ASTNode location, int nullStatus) {
        int reportFlag;
        if ((this.globalClosingState & 4) != 0) {
            return 0;
        }
        boolean isPotentialProblem = false;
        if (nullStatus == 2) {
            if ((this.globalClosingState & 8) != 0) {
                isPotentialProblem = true;
            }
        } else if ((nullStatus & 0x30) != 0) {
            isPotentialProblem = true;
        }
        if (isPotentialProblem) {
            if ((this.globalClosingState & 0x60) != 0) {
                return 0;
            }
            problemReporter.potentiallyUnclosedCloseable(this, location);
        } else {
            if ((this.globalClosingState & 0x40) != 0) {
                return 0;
            }
            problemReporter.unclosedCloseable(this, location);
        }
        int n = reportFlag = isPotentialProblem ? 32 : 64;
        if (location == null) {
            FakedTrackingVariable current = this;
            do {
                current.globalClosingState |= reportFlag;
            } while ((current = current.innerTracker) != null);
        }
        return reportFlag;
    }

    public void reportExplicitClosing(ProblemReporter problemReporter) {
        if ((this.globalClosingState & 0x14) == 0) {
            this.globalClosingState |= 0x10;
            problemReporter.explicitlyClosedAutoCloseable(this);
        }
    }

    public void resetReportingBits() {
        FakedTrackingVariable current = this;
        do {
            current.globalClosingState &= 0xFFFFFF9F;
        } while ((current = current.innerTracker) != null);
    }
}

