/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testrail.ui.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.rcptt.internal.testrail.TestRailPlugin;
import org.eclipse.rcptt.testrail.internal.ui.Messages;
import org.eclipse.rcptt.ui.launching.ITestEngineLaunchConfig;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TestRailLaunchConfig
implements ITestEngineLaunchConfig {
    private Text testRunId;

    public void createControl(Composite parent, Listener listener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setFont(parent.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        composite.setLayoutData((Object)gd);
        this.testRunId = this.createText(composite, Messages.TestRailLaunchConfig_TestRunIdField);
        this.testRunId.addListener(24, listener);
    }

    private Text createText(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.testRunId != null) {
            this.testRunId.setText("");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.testRunId.setText(configuration.getAttribute("org.eclipse.rcptt.testrail.ATTR_TESTRAIL_TESTRUNID", ""));
        }
        catch (CoreException e) {
            TestRailPlugin.log((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.rcptt.testrail.ATTR_TESTRAIL_TESTRUNID", this.testRunId.getText());
    }

    public String validatePage() {
        if (!this.isValidId(this.testRunId.getText())) {
            return Messages.TestRailLaunchConfig_IncorrectTestRunIdMsg;
        }
        return null;
    }

    private boolean isValidId(String idString) {
        if (idString == null || idString.equals("")) {
            return true;
        }
        if (!idString.startsWith("R")) {
            return false;
        }
        try {
            idString = idString.substring(1);
            int parsedValue = Integer.parseInt(idString);
            if (parsedValue > 0) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

