/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.ui;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.rcptt.tesla.core.utils.WidgetModels;
import org.eclipse.rcptt.verifications.tree.Cell;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.swt.widgets.Composite;

public class VerificationEditingSupport
extends EditingSupport {
    private TextCellEditor cellEditor;

    public VerificationEditingSupport(ColumnViewer viewer) {
        super(viewer);
        this.cellEditor = new TextCellEditor((Composite)((TreeViewer)viewer).getTree());
    }

    protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        if (cell.getElement() instanceof Row) {
            Cell tableCell = (Cell)((Row)cell.getElement()).getValues().get(cell.getColumnIndex());
            cellEditor.setValue(this.getValue(tableCell));
        }
    }

    protected void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        if (cell.getElement() instanceof Row) {
            Cell tableCell = (Cell)((Row)cell.getElement()).getValues().get(cell.getColumnIndex());
            this.setValue(tableCell, cellEditor.getValue());
            this.getViewer().refresh();
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return false;
    }

    protected Object getValue(Object element) {
        String result = "";
        if (element instanceof Cell) {
            result = WidgetModels.getTextWithoutStyle((Iterable)((Cell)element).getStyle(), (String)((Cell)element).getData().getText());
        }
        return result;
    }

    protected void setValue(Object element, Object value) {
        Object oldValue;
        if (element instanceof Cell && !(oldValue = this.getValue(element)).equals(value)) {
            ((Cell)element).getData().setText(value.toString());
            ((Cell)element).getStyle().clear();
        }
    }
}

