/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.Q7;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.ecl.core.model.CreateReport;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.ecl.core.model.GetReport;
import org.eclipse.rcptt.core.ecl.core.model.PrepareEnvironment;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.ResetVerifications;
import org.eclipse.rcptt.core.ecl.core.model.SetCommandsDelay;
import org.eclipse.rcptt.core.ecl.core.model.SetQ7Features;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.util.ECLBinaryResourceImpl;
import org.eclipse.rcptt.ecl.core.util.ScriptletFactory;
import org.eclipse.rcptt.ecl.internal.core.ProcessStatusConverter;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.GroupExecutable;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ScenarioExecutable;
import org.eclipse.rcptt.internal.launching.TestEngineManager;
import org.eclipse.rcptt.internal.launching.ecl.EclScenarioExecutable;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.Q7LaunchUtils;
import org.eclipse.rcptt.launching.utils.TestSuiteUtils;
import org.eclipse.rcptt.parameters.ParametersFactory;
import org.eclipse.rcptt.parameters.ResetParams;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportContainer;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportSession;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;

public class PrepareExecutionWrapper
extends Executable {
    private final AutLaunch launch;
    private final Executable executable;
    private SherlockReportSession reportSession;
    private String resultReportID;

    @Override
    public void cancel(IStatus status) {
        Executable[] executableArray = this.getChildren();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            IStatus childResult = this.handleChildResult(child.getResultStatus());
            if (child.getStatus() == IExecutable.State.COMPLETED && !childResult.isOK()) {
                return;
            }
            ++n2;
        }
        super.cancel(status);
    }

    public PrepareExecutionWrapper(AutLaunch launch, Executable executable) throws ModelException {
        super(executable.isDebug(), ExecutionPhase.AUTO, true);
        this.launch = launch;
        this.executable = executable;
        Preconditions.checkNotNull((Object)this.getActualElement());
        Preconditions.checkNotNull((Object)this.getActualElement().getID());
    }

    public Executable getExecutable() {
        return this.executable;
    }

    @Override
    public AutLaunch getAut() {
        return this.launch;
    }

    @Override
    public void startLaunching() {
        this.executable.startLaunching();
    }

    @Override
    public Report getResultReport() {
        if (this.resultReportID != null && this.reportSession != null) {
            return this.reportSession.getReport(this.resultReportID);
        }
        return TestSuiteUtils.generateReport(this.getActualElement(), this.getResultStatus());
    }

    @Override
    public IStatus execute() throws InterruptedException {
        Executable rootExecutable;
        this.launch.resetState();
        PrepareEnvironment prepareEnvironment = Q7CoreFactory.eINSTANCE.createPrepareEnvironment();
        SetCommandsDelay commandsDelay = Q7CoreFactory.eINSTANCE.createSetCommandsDelay();
        commandsDelay.setDelay(Q7.INSTANCE.getCommandsExecutionDelay());
        TeslaFeatures.getInstance().getOption("org.eclipse.rcptt.tesla.ecl.execution.delay").setValue(Integer.toString(commandsDelay.getDelay()));
        SetQ7Features setQ7Features = Q7CoreFactory.eINSTANCE.createSetQ7Features();
        Q7LaunchUtils.setQ7Variable(setQ7Features, "current_test", this.getName());
        TeslaFeatures.getInstance().storeValues((List)setQ7Features.getFeatures());
        Q7Features.getInstance().storeValues((List)setQ7Features.getFeatures());
        Sequence command = ScriptletFactory.seq((Command[])new Command[]{prepareEnvironment, commandsDelay, setQ7Features});
        try {
            this.launch.execute((Command)command);
            this.resetParams();
            this.resetVerifications();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Exception e) {
            return Q7LaunchingPlugin.createStatus(e);
        }
        try {
            this.createReport();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        if (this.executable instanceof GroupExecutable && (rootExecutable = ((GroupExecutable)this.executable).getRoot()) instanceof EclScenarioExecutable) {
            EclScenarioExecutable scenario = (EclScenarioExecutable)rootExecutable;
            TestEngineManager.getInstance().fireExecutionStarted(scenario);
        }
        return this.executable.execute();
    }

    private Report getReport() throws InterruptedException, ModelException {
        Report resultReport = null;
        String id = this.getActualElement().getID();
        Preconditions.checkNotNull((Object)id);
        try {
            GetReport getReport = Q7CoreFactory.eINSTANCE.createGetReport();
            Object object = this.launch.execute((Command)getReport);
            if (object instanceof Report) {
                resultReport = (Report)object;
            } else if (object instanceof ReportContainer) {
                ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(((ReportContainer)object).getContent()));
                try {
                    zin.getNextEntry();
                    ECLBinaryResourceImpl res = new ECLBinaryResourceImpl();
                    res.load((InputStream)zin, null);
                    EObject object2 = (EObject)res.getContents().get(0);
                    if (!(object2 instanceof Report)) {
                        throw this.invalidObjectStatus(object2);
                    }
                    resultReport = (Report)object2;
                }
                catch (Exception e) {
                    throw new CoreException(Q7LaunchingPlugin.createStatus(e.getMessage(), e));
                }
            } else {
                if (object == null) {
                    throw this.invalidObjectStatus(object);
                }
                throw this.invalidObjectStatus(object);
            }
            String reportId = ReportHelper.getInfo((Node)resultReport.getRoot()).getId();
            if (!id.equals(reportId)) {
                throw new CoreException(RcpttPlugin.createStatus((String)("Expected item id: " + id + ", actual report id: " + reportId)));
            }
        }
        catch (CoreException e) {
            resultReport = this.generateReport(e.getStatus());
        }
        Q7Info info = ReportHelper.getInfoOnly((Node)resultReport.getRoot());
        if (info != null) {
            info.getVariant().clear();
            info.getVariant().addAll(this.getVariantName());
        }
        return resultReport;
    }

    private CoreException invalidObjectStatus(Object o) {
        String clazz = o == null ? "null" : o.getClass().getName();
        return new CoreException(RcpttPlugin.createStatus((String)("Expected: Report object, found: " + clazz)));
    }

    private void resetParams() throws CoreException, InterruptedException {
        ResetParams cmd = ParametersFactory.eINSTANCE.createResetParams();
        this.launch.execute((Command)cmd);
    }

    private void resetVerifications() throws CoreException, InterruptedException {
        ResetVerifications cmd = Q7CoreFactory.eINSTANCE.createResetVerifications();
        this.launch.execute((Command)cmd);
    }

    private void createReport() throws CoreException, InterruptedException {
        CreateReport createReport = Q7CoreFactory.eINSTANCE.createCreateReport();
        createReport.setName(this.getName());
        createReport.setQ7info(PrepareExecutionWrapper.getQ7Info(this.executable));
        this.launch.execute((Command)createReport);
    }

    private static Q7Info getQ7Info(Executable executable) throws ModelException {
        IQ7NamedElement element = executable.getActualElement();
        return TestSuiteUtils.getQ7Info(element);
    }

    @Override
    public Executable[] getChildren() {
        return this.executable.getChildren();
    }

    @Override
    public IQ7NamedElement getActualElement() {
        return this.executable.getActualElement();
    }

    @Override
    public String getName() {
        return this.executable.getName();
    }

    @Override
    public int getType() {
        return this.executable.getType();
    }

    private static void closeAllNodes(long endTime, Node node) {
        if (node.getEndTime() == 0L) {
            node.setEndTime(endTime);
        }
        Q7Info info = ReportHelper.getInfo((Node)node);
        for (Node child : node.getChildren()) {
            PrepareExecutionWrapper.closeAllNodes(endTime, child);
            Q7Info childInfo = ReportHelper.getInfo((Node)child);
            if (childInfo.getResult() != null) continue;
            ProcessStatus childStatus = RcpttPlugin.createProcessStatus((int)4, (String)(child.getName() + " result is not set"));
            childInfo.setResult(childStatus);
            if (SimpleSeverity.create((Q7Info)info) != SimpleSeverity.OK) continue;
            info.setResult(childStatus);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public IStatus postExecute(IStatus status) {
        Executable rootExecutable;
        IStatus iStatus;
        IStatus temp = this.executable.postExecute(status);
        if (status.isOK() && !temp.isOK()) {
            status = temp;
        }
        Report resultReport = null;
        try {
            if (status.matches(8)) {
                resultReport = this.generateReport(status);
            } else {
                resultReport = this.getReport();
                Node root = resultReport.getRoot();
                Q7Info rootInfo = ReportHelper.getInfo((Node)root);
                assert (rootInfo.getResult() == null);
                rootInfo.setResult(ProcessStatusConverter.toProcessStatus((IStatus)status));
                PrepareExecutionWrapper.closeAllNodes(root.getStartTime() + this.getTime(), root);
                if (status.isOK() && SimpleSeverity.create((Q7Info)rootInfo) != SimpleSeverity.OK) {
                    status = ProcessStatusConverter.toIStatus((ProcessStatus)rootInfo.getResult());
                }
                Executable[] executableArray = this.getChildren();
                int n = executableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Executable ch = executableArray[n2];
                    if (ch instanceof ScenarioExecutable) {
                        rootInfo.setId(ch.getId());
                        break;
                    }
                    ++n2;
                }
                assert (Objects.equal((Object)rootInfo.getId(), (Object)this.getActualElement().getID()));
            }
            iStatus = super.postExecute(status);
        }
        catch (InterruptedException e) {
            Executable rootExecutable2;
            resultReport = this.generateReport(RcpttPlugin.createStatus((String)"Interrupted during report acquisition", (Throwable)e));
            IStatus iStatus2 = Status.CANCEL_STATUS;
            Preconditions.checkNotNull((Object)resultReport);
            if (this.executable instanceof GroupExecutable && (rootExecutable2 = ((GroupExecutable)this.executable).getRoot()) instanceof EclScenarioExecutable) {
                EclScenarioExecutable scenario = (EclScenarioExecutable)rootExecutable2;
                TestEngineManager.getInstance().fireExecutionCompleted(scenario, resultReport);
            }
            if (this.reportSession != null) {
                this.resultReportID = this.reportSession.write(resultReport);
            }
            this.listeners.updateSessionCounters(this, status);
            return iStatus2;
        }
        catch (Throwable e2) {
            Executable rootExecutable3;
            RcpttPlugin.log((Throwable)e2);
            IStatus rv = RcpttPlugin.createStatus((Throwable)e2);
            resultReport = this.generateReport(rv);
            IStatus iStatus3 = rv;
            {
                catch (Throwable throwable) {
                    Executable rootExecutable4;
                    Preconditions.checkNotNull(resultReport);
                    if (this.executable instanceof GroupExecutable && (rootExecutable4 = ((GroupExecutable)this.executable).getRoot()) instanceof EclScenarioExecutable) {
                        EclScenarioExecutable scenario = (EclScenarioExecutable)rootExecutable4;
                        TestEngineManager.getInstance().fireExecutionCompleted(scenario, resultReport);
                    }
                    if (this.reportSession != null) {
                        this.resultReportID = this.reportSession.write(resultReport);
                    }
                    this.listeners.updateSessionCounters(this, status);
                    throw throwable;
                }
            }
            Preconditions.checkNotNull((Object)resultReport);
            if (this.executable instanceof GroupExecutable && (rootExecutable3 = ((GroupExecutable)this.executable).getRoot()) instanceof EclScenarioExecutable) {
                EclScenarioExecutable scenario = (EclScenarioExecutable)rootExecutable3;
                TestEngineManager.getInstance().fireExecutionCompleted(scenario, resultReport);
            }
            if (this.reportSession != null) {
                this.resultReportID = this.reportSession.write(resultReport);
            }
            this.listeners.updateSessionCounters(this, status);
            return iStatus3;
        }
        Preconditions.checkNotNull((Object)resultReport);
        if (this.executable instanceof GroupExecutable && (rootExecutable = ((GroupExecutable)this.executable).getRoot()) instanceof EclScenarioExecutable) {
            EclScenarioExecutable scenario = (EclScenarioExecutable)rootExecutable;
            TestEngineManager.getInstance().fireExecutionCompleted(scenario, resultReport);
        }
        if (this.reportSession != null) {
            this.resultReportID = this.reportSession.write(resultReport);
        }
        this.listeners.updateSessionCounters(this, status);
        return iStatus;
    }

    private Report generateReport(IStatus status) {
        Report report = TestSuiteUtils.generateReport(this.getActualElement(), status);
        Node root = report.getRoot();
        root.setEndTime(root.getStartTime() + this.getTime());
        ReportHelper.appendLog((Node)root, (LoggingCategory)LoggingCategory.NORMAL, (String)this.getLog());
        return report;
    }

    public void setReportSession(SherlockReportSession reportSession) {
        this.reportSession = reportSession;
    }

    public List<String> getVariantName() {
        Executable ex;
        Executable exx = this.getExecutable();
        if (exx instanceof GroupExecutable && (ex = ((GroupExecutable)exx).getRoot()) instanceof EclScenarioExecutable) {
            return ((EclScenarioExecutable)ex).getVariantName();
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "Prepare: " + this.executable.toString();
    }
}

