/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.core.util.ECLBinaryResourceImpl;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.IQ7ReportConstants;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportBuilderStore;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.Procedure1;
import org.eclipse.rcptt.sherlock.core.reporting.ReportBuilder;
import org.eclipse.rcptt.util.FileUtil;

public class ReportManager
implements IQ7ReportConstants {
    private static ReportBuilder builder = null;
    private static boolean hasRun = false;
    public static String[] eventProviders = new String[]{"org.eclipse.rcptt.sherlock.core.log.provider", "org.eclipse.rcptt.sherlock.core.jface.log.provider", "org.eclipse.rcptt.sherlock.jobs.info.provider", "org.eclipse.rcptt.tesla.ecl.iml.info.provider", "org.eclipse.rcptt.core.ecl.core.ecl.provider"};

    private static synchronized void initializeBuilder(String title, ReportBuilderStore store) {
        if (builder != null) {
            builder.unregisterProviders(new String[0]);
        }
        if (store != null) {
            builder = ReportBuilder.load((ReportBuilderStore)store);
        } else {
            assert (title != null);
            builder = ReportBuilder.create((String)title);
        }
        builder.registerProviders(eventProviders);
    }

    public static synchronized Report getReportCopy() {
        if (builder == null) {
            return null;
        }
        return builder.getReportCopy();
    }

    public static synchronized ReportBuilder getBuilder() {
        return builder;
    }

    public static synchronized INodeBuilder getCurrentReportNode() {
        ReportBuilder builder = ReportManager.getBuilder();
        if (builder != null) {
            INodeBuilder rv = builder.getCurrent();
            if (rv == null) {
                throw new NullPointerException();
            }
            return rv;
        }
        return DummyReportNode.INSTANCE;
    }

    public static synchronized void reload() {
        if (builder == null) {
            File current = ReportManager.getReportFile();
            if (current.exists()) {
                ECLBinaryResourceImpl res = new ECLBinaryResourceImpl();
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(current));
                    res.load((InputStream)in, null);
                    in.close();
                    EObject eObject = (EObject)res.getContents().get(0);
                    if (eObject instanceof ReportBuilderStore) {
                        ReportBuilderStore store = (ReportBuilderStore)eObject;
                        ReportManager.initializeBuilder(null, store);
                    }
                    INodeBuilder node = builder.getCurrent();
                    ReportHelper.setResult(node, RcpttPlugin.createProcessStatus((int)0, (String)"Restart successful"));
                    node.endTask();
                    ProcessStatus eclStatus = RcpttPlugin.createProcessStatus((int)0, (String)"AUT restarted. Closing ECL report nodes.");
                    while (ReportManager.getType(node = builder.getCurrent()) == ItemKind.ECL_COMMAND) {
                        ReportHelper.setResult(node, eclStatus);
                        node.endTask();
                    }
                }
                catch (Throwable e) {
                    Q7ReportingPlugin.log(e);
                }
            }
            current.delete();
        }
    }

    private static ItemKind getType(INodeBuilder node) {
        final ItemKind[] rv = new ItemKind[1];
        node.update((Procedure1)new Procedure1<Node>(){

            public void apply(Node arg) {
                rv[0] = ReportHelper.getInfo(arg).getType();
            }
        });
        return rv[0];
    }

    public static synchronized void storeState() {
        ReportBuilder localBuilder = builder;
        if (localBuilder != null) {
            localBuilder.getCurrent().beginTask("Restarting Workbench");
            ECLBinaryResourceImpl res = new ECLBinaryResourceImpl();
            ReportBuilderStore store = localBuilder.save();
            assert (store.getCurrentNode().eContainer() != null);
            res.getContents().add((Object)store);
            File current = ReportManager.getReportFile();
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(current));
                res.save((OutputStream)out, null);
                out.close();
            }
            catch (Throwable e) {
                Q7ReportingPlugin.log(e);
            }
        }
    }

    private static File getReportFile() {
        return new File(Q7ReportingPlugin.getConfigStateLocation(), "current.report");
    }

    private static synchronized void clearOldReports() {
        if (!hasRun) {
            File root = Q7ReportingPlugin.getConfigStateLocation();
            if (root.exists()) {
                FileUtil.deleteFiles((File[])root.listFiles());
            }
            hasRun = true;
        }
    }

    public static void clear() {
        ReportManager.clearOldReports();
        if (builder != null) {
            builder.unregisterProviders(new String[0]);
        }
        builder = null;
    }

    public static void appendLog(String msg) {
        ReportManager.appendLog(msg, LoggingCategory.DEFAULT);
    }

    public static void appendLogError(String msg) {
        ReportManager.appendLog(msg, LoggingCategory.NORMAL);
    }

    public static void appendLogExtra(String msg) {
        ReportManager.appendLog(msg, LoggingCategory.ADVANCED);
    }

    public static synchronized void appendLog(String msg, LoggingCategory cat) {
        ReportManager.getCurrentReportNode().appendLog(cat, String.valueOf(msg) + "\n");
    }

    public static synchronized INodeBuilder createReport(String title, Q7Info q7info) {
        ReportManager.clear();
        ReportManager.initializeBuilder(title, null);
        INodeBuilder root = builder.getCurrent();
        assert (q7info.getType() != null);
        assert (q7info.getResult() == null);
        root.setProperty("q7", (EObject)q7info);
        return root;
    }

    private static class DummyReportNode
    implements INodeBuilder {
        private static final DummyReportNode INSTANCE = new DummyReportNode();

        private DummyReportNode() {
        }

        public INodeBuilder beginTask(String name) {
            return INSTANCE;
        }

        public void endTask() {
        }

        public void createEvent(Event event) {
        }

        public void appendLog(LoggingCategory category, String text) {
        }

        public void setProperty(String key, EObject value) {
        }

        public EObject getProperty(String key) {
            return null;
        }

        public DummyReportNode getParent() {
            return null;
        }

        public void addSnapshot(Snaphot snapshot) {
        }

        public void update(Procedure1<Node> runnable) {
        }

        public String getName() {
            return null;
        }
    }
}

