/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.tesla.jface.DescriptorInfo;
import org.eclipse.rcptt.tesla.swt.images.ImageDataMapping;
import org.eclipse.rcptt.util.WeakIdentityHashMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImageSources {
    INSTANCE;

    private Map<ImageDescriptor, ImageSource> descriptors = new WeakIdentityHashMap();
    private Map<Object, ImageSource> sources = new WeakIdentityHashMap();

    public ImageSource find(Image image) {
        return this.sources.get(ImageSources.dedup(image));
    }

    private synchronized ImageSource findOrCreate(ImageDescriptor descriptor) {
        ImageSource result = this.descriptors.get(descriptor);
        if (result != null) {
            return result;
        }
        if (descriptor instanceof CompositeImageDescriptor) {
            result = new CompositeSource();
            this.descriptors.put(descriptor, result);
            return result;
        }
        String info = DescriptorInfo.getInfo(descriptor);
        if (info != null) {
            result = new ResourceSource(info);
            this.descriptors.put(descriptor, result);
            return result;
        }
        return null;
    }

    public synchronized void imageDataFromDescriptor(ImageData imageData, ImageDescriptor descriptor) {
        this.imageOrDataFromDescriptor(ImageSources.dedup(imageData), descriptor);
    }

    public synchronized void imageFromDescriptor(Image image, ImageDescriptor descriptor) {
        this.imageOrDataFromDescriptor(ImageSources.dedup(image), descriptor);
    }

    private synchronized void imageOrDataFromDescriptor(Object imageOrData, ImageDescriptor descriptor) {
        if (imageOrData == null) {
            return;
        }
        ImageSource source = this.findOrCreate(descriptor);
        if (source == null) {
            return;
        }
        this.sources.put(imageOrData, source);
    }

    private static Object dedup(Object imageOrData) {
        Object source = ImageDataMapping.INSTANCE.getSource(imageOrData);
        return source == null ? imageOrData : source;
    }

    public synchronized void imageDrawn(ImageData data, ImageDescriptor descriptor) {
        ImageSource composite = this.findOrCreate(descriptor);
        ImageSource source = this.sources.get(ImageSources.dedup(data));
        if (source == null) {
            return;
        }
        if (!(composite instanceof CompositeSource)) {
            return;
        }
        ((CompositeSource)composite).addUnique(source);
    }

    public static class CompositeSource
    extends ImageSource {
        public final List<ImageSource> children = new ArrayList<ImageSource>();

        public void addUnique(ImageSource source) {
            for (ImageSource src : this.children) {
                if (!src.equals(source)) continue;
                return;
            }
            this.children.add(source);
        }

        public String toString() {
            return this.children.toString();
        }
    }

    public static class ImageSource {
    }

    public static class ResourceSource
    extends ImageSource {
        public final String source;

        public ResourceSource(String source) {
            this.source = source;
        }

        public String toString() {
            return this.source;
        }
    }
}

