/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class GenerateConstructorUsingFieldsContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private List<IVariableBinding> fFields;
    private List<IVariableBinding> fSelected;

    public GenerateConstructorUsingFieldsContentProvider(List<IVariableBinding> fields, List<IVariableBinding> selected) {
        this.fFields = fields;
        this.fSelected = selected;
    }

    public boolean canMoveDown(List<?> selectedElements) {
        int nSelected = selectedElements.size();
        int index = this.fFields.size() - 1;
        while (index >= 0 && nSelected > 0) {
            if (!selectedElements.contains(this.fFields.get(index))) {
                return true;
            }
            --nSelected;
            --index;
        }
        return false;
    }

    public boolean canMoveUp(List<?> selected) {
        int nSelected = selected.size();
        int index = 0;
        while (index < this.fFields.size() && nSelected > 0) {
            if (!selected.contains(this.fFields.get(index))) {
                return true;
            }
            --nSelected;
            ++index;
        }
        return false;
    }

    public void dispose() {
    }

    public void down(List<?> checked, CheckboxTreeViewer tree) {
        if (checked.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fFields), checked)), tree);
            tree.reveal(checked.get(checked.size() - 1));
        }
        tree.setSelection((ISelection)new StructuredSelection(checked));
    }

    public Object[] getChildren(Object parentElement) {
        return EMPTY;
    }

    public Object[] getElements(Object inputElement) {
        return this.fFields.toArray();
    }

    public List<IVariableBinding> getFieldsList() {
        return this.fFields;
    }

    public Object[] getInitiallySelectedElements() {
        if (this.fSelected.isEmpty()) {
            return this.getElements(null);
        }
        return this.fSelected.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private List<IVariableBinding> moveUp(List<IVariableBinding> elements, List<?> move) {
        ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>(elements.size());
        IVariableBinding floating = null;
        int index = 0;
        while (index < elements.size()) {
            IVariableBinding current = elements.get(index);
            if (move.contains(current)) {
                result.add(current);
            } else {
                if (floating != null) {
                    result.add(floating);
                }
                floating = current;
            }
            ++index;
        }
        if (floating != null) {
            result.add(floating);
        }
        return result;
    }

    private List<IVariableBinding> reverse(List<IVariableBinding> list) {
        ArrayList<IVariableBinding> reverse = new ArrayList<IVariableBinding>(list.size());
        int index = list.size() - 1;
        while (index >= 0) {
            reverse.add(list.get(index));
            --index;
        }
        return reverse;
    }

    public void setElements(List<IVariableBinding> elements, CheckboxTreeViewer tree) {
        this.fFields = new ArrayList<IVariableBinding>(elements);
        if (tree != null) {
            tree.refresh();
        }
    }

    public void up(List<?> checked, CheckboxTreeViewer tree) {
        if (checked.size() > 0) {
            this.setElements(this.moveUp(this.fFields, checked), tree);
            tree.reveal(checked.get(0));
        }
        tree.setSelection((ISelection)new StructuredSelection(checked));
    }
}

