/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class ToolbarButton {
    private String name;
    private String tooltip;
    private String image;
    private String action;
    private String param;
    private String styleClass;
    private boolean state;
    private boolean isSeparator;

    public ToolbarButton() {
        this.isSeparator = true;
    }

    public ToolbarButton(String name, String tooltip, String image, String action, String param, String state) {
        this.name = name;
        this.tooltip = tooltip;
        this.image = image;
        this.action = action;
        this.param = param;
        boolean bl = this.state = state.equalsIgnoreCase("on");
        this.styleClass = state.startsWith("hid") ? "buttonHidden" : ("menu".equals(action) ? "buttonMenu" : (state.equalsIgnoreCase("on") ? "buttonOn" : "button"));
    }

    public boolean isSeparator() {
        return this.isSeparator;
    }

    public boolean isMenu() {
        return "menu".equals(this.action);
    }

    public String getName() {
        return this.name;
    }

    public String[][] getMenuData() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        StringTokenizer tok = new StringTokenizer(this.param, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int index = token.indexOf(61);
            list.add(new String[]{token.substring(0, index), token.substring(index + 1)});
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getImage() {
        return this.image;
    }

    public String getAction() {
        return this.action;
    }

    public String getParam() {
        return this.param;
    }

    public boolean isOn() {
        return this.state;
    }

    public String getStyleClass() {
        return this.styleClass;
    }
}

