/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.pde.api.tools.ui.internal.use.UsePatternPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ArchivePatternPage
extends UsePatternPage {
    static final String PAGE_NAME = "archive";
    private Text bundletext = null;
    private Text patterntext = null;
    private String bundle = null;
    private String archive = null;

    protected ArchivePatternPage(String pattern) {
        super(PAGE_NAME, Messages.ArchivePatternPage_nested_archive_pattern, null);
        String[] parts;
        if (pattern != null && (parts = pattern.split(":")).length == 2) {
            this.bundle = parts[0];
            this.archive = parts[1];
        }
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 768);
        SWTFactory.createLabel(comp, Messages.ArchivePatternPage_bundle_name, 1);
        this.bundletext = SWTFactory.createSingleText(comp, 1);
        if (this.bundle != null) {
            this.bundletext.setText(this.bundle);
        }
        this.bundletext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchivePatternPage.this.setDirty();
                ArchivePatternPage.this.setPageComplete(ArchivePatternPage.this.isPageComplete());
            }
        });
        SWTFactory.createLabel(comp, Messages.ArchivePatternPage_archive_name, 1);
        this.patterntext = SWTFactory.createSingleText(comp, 1);
        if (this.archive != null) {
            this.patterntext.setText(this.archive);
        }
        this.patterntext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArchivePatternPage.this.setDirty();
                ArchivePatternPage.this.setPageComplete(ArchivePatternPage.this.isPageComplete());
            }
        });
        this.setControl((Control)comp);
        this.bundletext.setFocus();
        this.bundletext.selectAll();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IApiToolsHelpContextIds.APITOOLS_ARCHIVE_PATTERN_WIZARD_PAGE);
    }

    public boolean isPageComplete() {
        if (this.bundletext.getText().trim().length() == 0) {
            if (this.pageDirty()) {
                this.setErrorMessage(Messages.ArchivePatternPage_enter_bundle_name);
            } else {
                this.setMessage(Messages.ArchivePatternPage_enter_bundle_name);
            }
            return false;
        }
        if (this.patterntext.getText().trim().length() == 0) {
            if (this.pageDirty()) {
                this.setErrorMessage(Messages.ArchivePatternPage_enter_a_pattern);
            } else {
                this.setMessage(Messages.ArchivePatternPage_enter_a_pattern);
            }
            return false;
        }
        this.resetMessage(this.bundle != null);
        return true;
    }

    @Override
    protected void resetMessage(boolean isediting) {
        this.setErrorMessage(null);
        if (isediting) {
            this.setMessage(Messages.ArchivePatternPage_edit_acrhive_eclusion_pattern);
        } else {
            this.setMessage(Messages.ArchivePatternPage_create_nested_pattern);
        }
    }

    @Override
    public String getPattern() {
        return String.valueOf(this.bundletext.getText().trim()) + ':' + this.patterntext.getText().trim();
    }

    @Override
    public int getKind() {
        return 3;
    }

    public IWizardPage getNextPage() {
        return null;
    }
}

