/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.URIUtil;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConfiguratorUtils {
    private static final String LINK_KEY = "link";
    private static final String LINK_FILE_EXTENSION = ".link";
    private static final String UNC_PREFIX = "//";
    private static final String VERSION_PREFIX = "#version=";
    public static final String ENCODING_UTF8 = "#encoding=UTF-8";
    public static final Version COMPATIBLE_VERSION = new Version(1, 0, 0);
    private static final String FILE_SCHEME = "file";
    private static final String REFERENCE_PREFIX = "reference:";
    private static final String FILE_PREFIX = "file:";
    private static final String COMMA = ",";
    private static final String ENCODED_COMMA = "%2C";
    private static final Set<File> reportedExtensions = Collections.synchronizedSet(new HashSet(0));

    public static List<BundleInfo> readConfiguration(URL url, URI base) throws IOException {
        ArrayList<BundleInfo> result = new ArrayList<BundleInfo>();
        result.addAll(SimpleConfiguratorUtils.readConfigurationFromFile(url, base));
        if (!Activator.EXTENDED) {
            return result;
        }
        SimpleConfiguratorUtils.readExtendedConfigurationFiles(result);
        SimpleConfiguratorUtils.removeDuplicates(result);
        return result;
    }

    public static void removeDuplicates(List<BundleInfo> result) {
        if (result.size() > 1) {
            int index = 0;
            while (index < result.size()) {
                String aSymbolicName = result.get(index).getSymbolicName();
                String aVersion = result.get(index).getVersion();
                int i = index + 1;
                while (i < result.size()) {
                    String bSymbolicName = result.get(i).getSymbolicName();
                    String bVersion = result.get(i).getVersion();
                    if (aSymbolicName.equals(bSymbolicName) && aVersion.equals(bVersion)) {
                        result.remove(i);
                        continue;
                    }
                    ++i;
                }
                ++index;
            }
        }
    }

    public static void readExtendedConfigurationFiles(List<BundleInfo> result) throws IOException, FileNotFoundException, MalformedURLException {
        try {
            ArrayList<File> files = SimpleConfiguratorUtils.getInfoFiles();
            for (File info : files) {
                List<BundleInfo> list = SimpleConfiguratorUtils.readConfigurationFromFile(info.toURL(), info.getParentFile().toURI());
                int i = 0;
                while (i < list.size()) {
                    BundleInfo singleInfo = list.get(i);
                    if (singleInfo.getBaseLocation() != null) {
                        singleInfo = new BundleInfo(singleInfo.getSymbolicName(), singleInfo.getVersion(), singleInfo.getBaseLocation().resolve(singleInfo.getLocation()), singleInfo.getStartLevel(), singleInfo.isMarkedAsStarted());
                        list.remove(i);
                        list.add(i, singleInfo);
                    }
                    ++i;
                }
                result.addAll(list);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Couldn't parse simpleconfigurator extensions", e);
        }
    }

    public static ArrayList<File> getInfoFiles() throws IOException, FileNotFoundException, URISyntaxException {
        ArrayList<File> files = new ArrayList<File>(1);
        if (Activator.EXTENSIONS != null) {
            String[] locationToCheck;
            String stringExtenionLocation = Activator.EXTENSIONS;
            String[] stringArray = locationToCheck = stringExtenionLocation.split(COMMA);
            int n = locationToCheck.length;
            int n2 = 0;
            while (n2 < n) {
                String location = stringArray[n2];
                files.addAll(SimpleConfiguratorUtils.getInfoFilesFromLocation(location));
                ++n2;
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<File> getInfoFilesFromLocation(String locationToCheck) throws IOException, FileNotFoundException, URISyntaxException {
        ArrayList<File> result = new ArrayList<File>(1);
        File extensionsLocation = new File(locationToCheck);
        if (extensionsLocation.exists() && extensionsLocation.isDirectory()) {
            File[] extensions;
            File[] fileArray = extensions = extensionsLocation.listFiles();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                Object link;
                File extension = fileArray[n2];
                if (extension.isFile() && extension.getName().endsWith(LINK_FILE_EXTENSION)) {
                    link = new Properties();
                    ((Properties)link).load(new FileInputStream(extension));
                    String newInfoName = ((Properties)link).getProperty(LINK_KEY);
                    URI newInfoURI = new URI(newInfoName);
                    File newInfoFile = null;
                    newInfoFile = newInfoURI.isAbsolute() ? new File(newInfoName) : new File(extension.getParentFile(), newInfoName);
                    if (newInfoFile.exists()) {
                        extension = newInfoFile.getParentFile();
                    }
                }
                if (extension.isDirectory()) {
                    if (extension.canWrite()) {
                        link = reportedExtensions;
                        synchronized (link) {
                            if (!reportedExtensions.contains(extension)) {
                                reportedExtensions.add(extension);
                                System.err.println("Fragment directory should be read only " + extension);
                            }
                        }
                    } else {
                        File[] listFiles;
                        File[] fileArray2 = listFiles = extension.listFiles();
                        int n3 = listFiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File file = fileArray2[n4];
                            if (file.getName().endsWith(".info")) {
                                result.add(file);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static List<BundleInfo> readConfigurationFromFile(URL url, URI base) throws IOException {
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                return Collections.emptyList();
            }
            throw e;
        }
        try {
            List<BundleInfo> list = SimpleConfiguratorUtils.readConfiguration(stream, base);
            return list;
        }
        finally {
            stream.close();
        }
    }

    public static List<BundleInfo> readConfiguration(InputStream stream, URI base) throws IOException {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        String encoding = SimpleConfiguratorUtils.determineEncoding(bufferedStream);
        BufferedReader r = new BufferedReader(encoding == null ? new InputStreamReader(bufferedStream) : new InputStreamReader((InputStream)bufferedStream, encoding));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("#")) {
                    SimpleConfiguratorUtils.parseCommentLine(line);
                    continue;
                }
                BundleInfo bundleInfo = SimpleConfiguratorUtils.parseBundleInfoLine(line, base);
                if (bundleInfo == null) continue;
                bundles.add(bundleInfo);
            }
        }
        catch (Throwable throwable) {
            try {
                r.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            r.close();
        }
        catch (IOException iOException) {}
        return bundles;
    }

    private static String determineEncoding(BufferedInputStream stream) {
        byte[] utfBytes = ENCODING_UTF8.getBytes();
        byte[] buffer = new byte[utfBytes.length];
        int bytesRead = -1;
        stream.mark(utfBytes.length + 1);
        try {
            bytesRead = stream.read(buffer);
        }
        catch (IOException iOException) {}
        if (bytesRead == utfBytes.length && Arrays.equals(utfBytes, buffer)) {
            return "UTF-8";
        }
        try {
            stream.reset();
        }
        catch (IOException iOException) {}
        return null;
    }

    public static void parseCommentLine(String line) {
        String version;
        if (line.startsWith(VERSION_PREFIX) && !COMPATIBLE_VERSION.equals((Object)new Version(version = line.substring(VERSION_PREFIX.length()).trim()))) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
    }

    public static BundleInfo parseBundleInfoLine(String line, URI base) {
        StringTokenizer tok = new StringTokenizer(line, COMMA);
        int numberOfTokens = tok.countTokens();
        if (numberOfTokens < 5) {
            throw new IllegalArgumentException("Line does not contain at least 5 tokens: " + line);
        }
        String symbolicName = tok.nextToken().trim();
        String version = tok.nextToken().trim();
        URI location = SimpleConfiguratorUtils.parseLocation(tok.nextToken().trim());
        int startLevel = Integer.parseInt(tok.nextToken().trim());
        boolean markedAsStarted = Boolean.parseBoolean(tok.nextToken());
        BundleInfo result = new BundleInfo(symbolicName, version, location, startLevel, markedAsStarted);
        if (!location.isAbsolute()) {
            result.setBaseLocation(base);
        }
        return result;
    }

    public static URI parseLocation(String location) {
        int encodedCommaIndex = location.indexOf(ENCODED_COMMA);
        while (encodedCommaIndex != -1) {
            location = String.valueOf(location.substring(0, encodedCommaIndex)) + COMMA + location.substring(encodedCommaIndex + 3);
            encodedCommaIndex = location.indexOf(ENCODED_COMMA);
        }
        if (File.separatorChar != '/') {
            String scheme;
            int colon = location.indexOf(58);
            String string = scheme = colon < 0 ? null : location.substring(0, colon);
            if (scheme == null || scheme.equals(FILE_SCHEME)) {
                location = location.replace(File.separatorChar, '/');
            }
            if (scheme == null) {
                if (location.startsWith(UNC_PREFIX) && !location.startsWith(UNC_PREFIX, 2)) {
                    location = UNC_PREFIX + location;
                }
            } else if (location.startsWith(UNC_PREFIX, colon + 1) && !location.startsWith(UNC_PREFIX, colon + 3)) {
                location = String.valueOf(location.substring(0, colon + 3)) + location.substring(colon + 1);
            }
        }
        try {
            URI uri = new URI(location);
            if (!uri.isOpaque()) {
                return uri;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        try {
            return URIUtil.fromString(location);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid location: " + location);
        }
    }

    public static void transferStreams(List<InputStream> sources, OutputStream destination) throws IOException {
        destination = new BufferedOutputStream(destination);
        try {
            int i = 0;
            while (i < sources.size()) {
                BufferedInputStream source = new BufferedInputStream(sources.get(i));
                try {
                    byte[] buffer = new byte[8192];
                    while (true) {
                        int bytesRead = -1;
                        bytesRead = ((InputStream)source).read(buffer);
                        if (bytesRead != -1) {
                            destination.write(buffer, 0, bytesRead);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)source).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)source).close();
                }
                catch (IOException iOException) {}
                ++i;
            }
        }
        catch (Throwable throwable) {
            try {
                destination.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            destination.close();
        }
        catch (IOException iOException) {}
    }

    public static String getBundleLocation(BundleInfo bundle, boolean useReference) {
        URI baseLocation;
        URI location = bundle.getLocation();
        String scheme = location.getScheme();
        String host = location.getHost();
        String path = location.getPath();
        if (location.getScheme() == null && (baseLocation = bundle.getBaseLocation()) != null && baseLocation.getScheme() != null) {
            scheme = baseLocation.getScheme();
            host = baseLocation.getHost();
        }
        String bundleLocation = null;
        try {
            URL bundleLocationURL = new URL(scheme, host, path);
            bundleLocation = bundleLocationURL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            bundleLocation = location.toString();
        }
        if (useReference && bundleLocation.startsWith(FILE_PREFIX)) {
            bundleLocation = REFERENCE_PREFIX + bundleLocation;
        }
        return bundleLocation;
    }

    public static long getExtendedTimeStamp() {
        long regularTimestamp = -1L;
        if (Activator.EXTENDED) {
            try {
                ArrayList<File> infoFiles = SimpleConfiguratorUtils.getInfoFiles();
                for (File f : infoFiles) {
                    long infoFileLastModified = f.lastModified();
                    if (infoFileLastModified <= regularTimestamp) continue;
                    regularTimestamp = infoFileLastModified;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return regularTimestamp;
    }
}

