/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.xml;

import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.util.string.CharBuffer;
import org.eclipse.equinox.internal.util.xml.XMLUtil;

public class TagClass {
    private static final String INTERN_TAGCONTENT = "xml.intern.tagcontent";
    private static boolean fInternTagContent = Activator.getBoolean("xml.intern.tagcontent");
    private CharBuffer fContent = null;
    private String fName = null;
    private Vector fTags = null;
    String fAttributes = null;
    private int fLine = -1;
    protected boolean fInline = false;

    public TagClass() {
    }

    public TagClass(String name) {
        this.fName = name;
    }

    public TagClass(int line, String name) {
        this.fLine = line;
        this.fName = name;
    }

    public TagClass(String name, String contentStr) {
        this.setup(-1, name, contentStr);
    }

    public TagClass(int line, String name, String contentStr) {
        this.setup(line, name, contentStr);
    }

    private void setup(int line, String name, String contentStr) {
        this.fLine = line;
        this.fName = name;
        if (contentStr != null && contentStr.length() > 0) {
            this.fContent = new CharBuffer(contentStr.length());
            this.fContent.append(contentStr);
        }
    }

    protected void appendContent(CharBuffer toAppend) {
        if (this.fContent == null) {
            this.fContent = new CharBuffer();
        }
        this.fContent.append(toAppend.getValue());
    }

    protected void appendContent(String toAppend) {
        if (this.fContent == null) {
            this.fContent = new CharBuffer();
        }
        this.fContent.append(toAppend);
    }

    public String getContent() {
        String result = "";
        if (this.fContent != null) {
            result = this.fContent.trim();
            if (fInternTagContent) {
                result = result.intern();
            }
        }
        return result;
    }

    public String getContent(int aPos, String aName) {
        TagClass child = this.getTagAt(aPos);
        if (child == null) {
            throw new NullPointerException("There is no such a tag. [Parent tag name] = [" + aName + "], [child tag index] = " + aPos + ", [child tag name] = [" + aName + ']');
        }
        if (child.getName().equals(aName)) {
            return child.getContent();
        }
        throw new IllegalArgumentException("There is no such a tag. [Parent tag name] = [" + aName + "], [child tag index] = " + aPos + ", [child tag name] = [" + aName + ']');
    }

    protected CharBuffer getContentBuffer() {
        if (this.fContent == null) {
            this.fContent = new CharBuffer();
        }
        return this.fContent;
    }

    public String getName() {
        return this.fName;
    }

    protected void setName(String aName) {
        this.fName = aName;
    }

    public String getAttributes() {
        return this.fAttributes != null ? this.fAttributes : "";
    }

    public String getAttribute(String attrName) {
        return XMLUtil.getAttributeValue(this.fAttributes, attrName, 0);
    }

    public void addTag(TagClass aTag) {
        if (this.fTags == null) {
            this.fTags = new Vector(5, 5);
        }
        this.fTags.addElement(aTag);
    }

    public TagClass getTagAt(int aPos) {
        return this.fTags == null ? null : (TagClass)this.fTags.elementAt(aPos);
    }

    public int size() {
        return this.fTags == null ? 0 : this.fTags.size();
    }

    public int getLine() {
        return this.fLine;
    }

    protected void setLine(int aLine) {
        this.fLine = aLine;
    }

    protected void setInline() {
        this.fInline = true;
    }
}

