/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IExtensionDeltaListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspacePluginModelManager;
import org.eclipse.pde.internal.core.target.P2TargetUtils;

public class PluginModelManager
implements IModelProviderListener {
    private static final String fExternalPluginListFile = "SavedExternalPluginList.txt";
    private static PluginModelManager fModelManager;
    private UpdateClasspathsJob fUpdateJob = new UpdateClasspathsJob();
    private ExternalModelManager fExternalManager;
    private WorkspacePluginModelManager fWorkspaceManager = new WorkspacePluginModelManager();
    private PDEState fState;
    private Map<String, LocalModelEntry> fEntries;
    private ArrayList<IPluginModelListener> fListeners;
    private ArrayList<IStateDeltaListener> fStateListeners;
    private boolean fCancelled = false;

    private PluginModelManager() {
        this.fExternalManager = new ExternalModelManager();
        this.fExternalManager.addModelProviderListener(this);
        this.fWorkspaceManager.addModelProviderListener(this);
    }

    public static synchronized PluginModelManager getInstance() {
        if (fModelManager == null) {
            fModelManager = new PluginModelManager();
        }
        return fModelManager;
    }

    public static synchronized void shutdownInstance() {
        if (fModelManager != null) {
            fModelManager.shutdown();
        }
    }

    @Override
    public void modelsChanged(IModelProviderEvent e) {
        PluginModelDelta delta = new PluginModelDelta();
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            int i = 0;
            while (i < removed.length) {
                IPluginModelBase model = (IPluginModelBase)removed[i];
                String id = model.getPluginBase().getId();
                if (id != null) {
                    this.handleRemove(id, model, delta);
                }
                ++i;
            }
        }
        HashSet<String> addedBSNs = new HashSet<String>();
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            int i = 0;
            while (i < added.length) {
                IPluginModelBase model = (IPluginModelBase)added[i];
                String id = model.getPluginBase().getId();
                if (id != null) {
                    this.handleAdd(id, model, delta);
                    addedBSNs.add(id);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            int i = 0;
            while (i < changed.length) {
                this.handleChange((IPluginModelBase)changed[i], delta);
                ++i;
            }
        }
        if (this.fState != null) {
            StateDelta stateDelta = null;
            stateDelta = addedBSNs.isEmpty() ? this.fState.resolveState(true) : this.fState.resolveState(addedBSNs.toArray(new String[addedBSNs.size()]));
            this.updateAffectedEntries(stateDelta, (e.getEventTypes() & 4) != 0);
            this.fireStateDelta(stateDelta);
        }
        this.fireDelta(delta);
    }

    private void updateAffectedEntries(StateDelta delta, boolean runAsynch) {
        HashMap<IJavaProject, RequiredPluginsClasspathContainer> map = new HashMap<IJavaProject, RequiredPluginsClasspathContainer>();
        if (delta == null) {
            IPluginModelBase[] models = this.getWorkspaceModels();
            int i = 0;
            while (i < models.length) {
                IProject project = models[i].getUnderlyingResource().getProject();
                try {
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        map.put(JavaCore.create((IProject)project), new RequiredPluginsClasspathContainer(models[i]));
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        } else {
            BundleDelta[] deltas = delta.getChanges();
            int i = 0;
            while (i < deltas.length) {
                try {
                    IJavaProject jProject;
                    IProject project;
                    IResource resource;
                    IPluginModelBase model = this.findModel(deltas[i].getBundle());
                    IResource iResource = resource = model == null ? null : model.getUnderlyingResource();
                    if (resource != null && (project = resource.getProject()).hasNature("org.eclipse.jdt.core.javanature") && !map.containsKey(jProject = JavaCore.create((IProject)project))) {
                        map.put(jProject, new RequiredPluginsClasspathContainer(model));
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            IPluginModelBase[] models = this.getWorkspaceModels();
            int i2 = 0;
            while (i2 < models.length) {
                IProject project = models[i2].getUnderlyingResource().getProject();
                try {
                    IBuild build;
                    IJavaProject jProject;
                    if (project.hasNature("org.eclipse.jdt.core.javanature") && !map.containsKey(jProject = JavaCore.create((IProject)project)) && (build = ClasspathUtilCore.getBuild(models[i2])) != null && build.getEntry("additional.bundles") != null) {
                        map.put(jProject, new RequiredPluginsClasspathContainer(models[i2], build));
                    }
                }
                catch (CoreException coreException) {}
                ++i2;
            }
        }
        if (map.size() > 0) {
            Iterator iterator = map.entrySet().iterator();
            IJavaProject[] projects = new IJavaProject[map.size()];
            IClasspathContainer[] containers = new IClasspathContainer[projects.length];
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                projects[index] = (IJavaProject)entry.getKey();
                containers[index] = (IClasspathContainer)entry.getValue();
                ++index;
            }
            if (runAsynch) {
                this.fUpdateJob.add(projects, containers);
                this.fUpdateJob.schedule();
            } else {
                try {
                    JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])projects, (IClasspathContainer[])containers, null);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    private void fireDelta(PluginModelDelta delta) {
        if (this.fListeners != null) {
            int i = 0;
            while (i < this.fListeners.size()) {
                this.fListeners.get(i).modelsChanged(delta);
                ++i;
            }
        }
    }

    private void fireStateDelta(StateDelta delta) {
        if (this.fStateListeners != null) {
            ListIterator<IStateDeltaListener> li = this.fStateListeners.listIterator();
            while (li.hasNext()) {
                li.next().stateResolved(delta);
            }
        }
    }

    private void fireStateChanged(PDEState newState) {
        if (this.fStateListeners != null) {
            ListIterator<IStateDeltaListener> li = this.fStateListeners.listIterator();
            while (li.hasNext()) {
                li.next().stateChanged(newState.getState());
            }
        }
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void addStateDeltaListener(IStateDeltaListener listener) {
        if (this.fStateListeners == null) {
            this.fStateListeners = new ArrayList();
        }
        if (!this.fStateListeners.contains(listener)) {
            this.fStateListeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove(listener);
        }
    }

    public void removeStateDeltaListener(IStateDeltaListener listener) {
        if (this.fStateListeners != null) {
            this.fStateListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.getEntryTable().size() == 0;
    }

    public boolean isInitialized() {
        return this.fEntries != null;
    }

    public boolean isCancelled() {
        return this.fCancelled;
    }

    public void targetReloaded(IProgressMonitor monitor) {
        this.fEntries = null;
        this.initializeTable(monitor);
    }

    private Map<String, LocalModelEntry> getEntryTable() {
        this.initializeTable(null);
        return this.fEntries;
    }

    private synchronized void initializeTable(IProgressMonitor monitor) {
        if (this.fEntries != null) {
            return;
        }
        PlatformAdmin pAdmin = Platform.getPlatformAdmin();
        if (pAdmin == null) {
            PDECore.logErrorMessage(PDECoreMessages.PluginModelManager_PlatformAdminMissingErrorMessage);
            this.fEntries = Collections.emptyMap();
            return;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)PDECoreMessages.PluginModelManager_InitializingPluginModels, (int)100);
        if (PDECore.DEBUG_MODEL) {
            if (this.fState == null) {
                System.out.println("\nInitializing PDE models");
            } else {
                System.out.println("\nTarget changed, recreating PDE models");
            }
        }
        PDEState oldState = this.fState;
        long startTime = System.currentTimeMillis();
        Map<String, LocalModelEntry> entries = Collections.synchronizedMap(new TreeMap());
        this.fCancelled = false;
        ITargetDefinition unresolvedRepoBasedtarget = null;
        try {
            unresolvedRepoBasedtarget = TargetPlatformHelper.getUnresolvedRepositoryBasedWorkspaceTarget();
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        if (unresolvedRepoBasedtarget != null && !P2TargetUtils.isProfileValid(unresolvedRepoBasedtarget)) {
            this.fState = new PDEState(new URL[0], true, true, (IProgressMonitor)subMon);
            this.fExternalManager.setModels(new IPluginModelBase[0]);
            this.fEntries = entries;
            LoadTargetDefinitionJob.load(unresolvedRepoBasedtarget);
            subMon.done();
            if (monitor != null) {
                monitor.done();
            }
            return;
        }
        long startTargetModels = System.currentTimeMillis();
        URL[] externalUrls = this.getExternalBundles((IProgressMonitor)subMon.split(40));
        if (subMon.isCanceled()) {
            if (PDECore.DEBUG_MODEL) {
                System.out.println("Target platform initialization cancelled by user");
            }
            PDECore.log((IStatus)new Status(2, "org.eclipse.pde.core", PDECoreMessages.PluginModelManager_TargetInitCancelledLog));
            this.fCancelled = true;
        }
        this.fState = new PDEState(externalUrls, true, true, (IProgressMonitor)subMon.split(15));
        this.fExternalManager.setModels(this.fState.getTargetModels());
        this.addToTable(entries, this.fExternalManager.getAllModels());
        boolean externalPluginsChanged = this.isSavedExternalPluginListDifferent(externalUrls);
        this.saveExternalPluginList(externalUrls);
        if (PDECore.DEBUG_MODEL) {
            System.out.println(String.valueOf(this.fState.getTargetModels().length) + " target models created in  " + (System.currentTimeMillis() - startTargetModels) + " ms");
        }
        IPluginModelBase[] models = this.fWorkspaceManager.getPluginModels();
        this.addToTable(entries, models);
        long startWorkspaceAdditions = System.currentTimeMillis();
        int i = 0;
        while (i < models.length) {
            this.addWorkspaceBundleToState(entries, models[i]);
            ++i;
        }
        subMon.worked(15);
        if (PDECore.DEBUG_MODEL) {
            System.out.println(String.valueOf(this.fWorkspaceManager.getModels().length) + " workspace models created in  " + (System.currentTimeMillis() - startWorkspaceAdditions) + " ms");
        }
        this.fState.resolveState(true);
        subMon.worked(5);
        this.fEntries = entries;
        PDECore.getDefault().getExtensionsRegistry().targetReloaded();
        if (oldState != null) {
            this.updateAffectedEntries(null, true);
        }
        if (externalPluginsChanged) {
            this.fireStateChanged(this.fState);
            if (PDECore.DEBUG_MODEL) {
                System.out.println("Loaded target models differ from saved list, PDE builder will run on all projects.");
            }
        }
        subMon.worked(25);
        if (PDECore.DEBUG_MODEL) {
            long time = System.currentTimeMillis() - startTime;
            System.out.println("PDE plug-in model initialization complete: " + time + " ms");
        }
        subMon.done();
        if (monitor != null) {
            monitor.done();
        }
    }

    private URL[] getExternalBundles(IProgressMonitor monitor) {
        ITargetDefinition target = null;
        try {
            target = TargetPlatformHelper.getWorkspaceTargetResolved(monitor);
        }
        catch (CoreException e) {
            PDECore.log(e);
            return new URL[0];
        }
        if (target == null) {
            return new URL[0];
        }
        if (target.isResolved() && target.getStatus().getSeverity() == 4) {
            PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.PluginModelManager_CurrentTargetPlatformContainsErrors, (Throwable)new CoreException(target.getStatus())));
        }
        URL[] externalURLs = new URL[]{};
        TargetBundle[] bundles = target.getBundles();
        if (bundles != null) {
            ArrayList<URL> urls = new ArrayList<URL>(bundles.length);
            int i = 0;
            while (i < bundles.length) {
                if (bundles[i].getStatus().isOK()) {
                    try {
                        File file = URIUtil.toFile((URI)bundles[i].getBundleInfo().getLocation());
                        urls.add(file.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++i;
            }
            externalURLs = urls.toArray(new URL[urls.size()]);
        }
        return externalURLs;
    }

    private void addToTable(Map<String, LocalModelEntry> entries, IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            if (id != null) {
                LocalModelEntry entry = entries.get(id);
                if (entry == null) {
                    entry = new LocalModelEntry(id);
                    entries.put(id, entry);
                }
                entry.addModel(models[i]);
            }
            ++i;
        }
    }

    private synchronized void addWorkspaceBundleToState(IPluginModelBase model) {
        this.addWorkspaceBundleToState(this.fEntries, model);
    }

    private synchronized void addWorkspaceBundleToState(Map<String, LocalModelEntry> entries, IPluginModelBase model) {
        ModelEntry hostEntry;
        BundleDescription host;
        HostSpecification spec;
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        ModelEntry entry = entries.get(id);
        if (entry != null) {
            IPluginModelBase[] models = entry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                this.fState.removeBundleDescription(models[i].getBundleDescription());
                ++i;
            }
        }
        this.fState.addBundle(model, false);
        BundleDescription desc = model.getBundleDescription();
        if (desc != null && (spec = desc.getHost()) != null && ("true".equals(System.getProperty("pde.allowCycles")) || this.isPatchFragment(entries, desc) || desc.getImportPackages().length > 0 || desc.getRequiredBundles().length > 0) && (host = (BundleDescription)spec.getSupplier()) != null && (hostEntry = (ModelEntry)entries.get(host.getName())) != null) {
            this.fState.addBundle(hostEntry.getModel(host), true);
        }
    }

    private boolean isPatchFragment(Map<String, LocalModelEntry> entries, BundleDescription desc) {
        ModelEntry entry = entries.get(desc.getSymbolicName());
        if (entry != null) {
            IPluginModelBase base = entry.getModel(desc);
            if (base == null) {
                return false;
            }
            return ClasspathUtilCore.isPatchFragment(base);
        }
        return false;
    }

    private void saveExternalPluginList(URL[] urls) {
        block15: {
            File dir = new File(PDECore.getDefault().getStateLocation().toOSString());
            File saveLocation = new File(dir, fExternalPluginListFile);
            FileWriter fileWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(saveLocation, false);
                    fileWriter.write("# List of external plug-in models previously loaded. Timestamp: " + System.currentTimeMillis() + "\n");
                    int i = 0;
                    while (i < urls.length) {
                        fileWriter.write(urls[i].toString());
                        fileWriter.write("\n");
                        ++i;
                    }
                    fileWriter.flush();
                }
                catch (IOException e) {
                    PDECore.log(e);
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isSavedExternalPluginListDifferent(URL[] newUrls) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleAdd(String id, IPluginModelBase model, PluginModelDelta delta) {
        BundleDescription desc;
        LocalModelEntry entry = this.getEntryTable().get(id);
        if (entry == null) {
            entry = new LocalModelEntry(id);
            this.getEntryTable().put(id, entry);
            delta.addEntry(entry, 1);
        } else {
            delta.addEntry(entry, 4);
        }
        entry.addModel(model);
        if (model.getUnderlyingResource() != null) {
            this.addWorkspaceBundleToState(model);
        } else if (model.isEnabled() && !entry.hasWorkspaceModels() && (desc = model.getBundleDescription()).getContainingState().equals(this.fState)) {
            this.fState.addBundleDescription(desc);
        }
    }

    private void handleRemove(String id, IPluginModelBase model, PluginModelDelta delta) {
        LocalModelEntry entry = this.getEntryTable().get(id);
        if (entry != null) {
            entry.removeModel(model);
            this.fState.removeBundleDescription(model.getBundleDescription());
            if (!entry.hasExternalModels() && !entry.hasWorkspaceModels()) {
                this.getEntryTable().remove(id);
                delta.addEntry(entry, 2);
                return;
            }
            if (model.getUnderlyingResource() != null && !entry.hasWorkspaceModels()) {
                IPluginModelBase[] external = entry.getExternalModels();
                int i = 0;
                while (i < external.length) {
                    if (external[i].isEnabled()) {
                        this.fState.addBundleDescription(external[i].getBundleDescription());
                    }
                    ++i;
                }
            }
            delta.addEntry(entry, 4);
        }
    }

    private void handleChange(IPluginModelBase model, PluginModelDelta delta) {
        BundleDescription desc = model.getBundleDescription();
        String oldID = desc == null ? null : desc.getSymbolicName();
        String newID = model.getPluginBase().getId();
        if (oldID == null && newID == null) {
            return;
        }
        if (oldID == null && newID != null) {
            this.handleAdd(newID, model, delta);
        } else if (oldID != null && newID == null) {
            this.handleRemove(oldID, model, delta);
            model.setBundleDescription(null);
        } else if (oldID != null && oldID.equals(newID)) {
            if (model.isEnabled()) {
                ModelEntry entry = this.getEntryTable().get(oldID);
                IPluginModelBase[] activeModels = entry.getActiveModels();
                boolean isActive = false;
                int i = 0;
                while (i < activeModels.length) {
                    if (activeModels[i] == model) {
                        isActive = true;
                        break;
                    }
                    ++i;
                }
                if (isActive) {
                    this.fState.addBundle(model, true);
                }
            } else {
                this.fState.removeBundleDescription(model.getBundleDescription());
            }
            delta.addEntry(this.findEntry(oldID), 4);
        } else {
            this.handleRemove(oldID, model, delta);
            this.handleAdd(newID, model, delta);
        }
    }

    public ModelEntry findEntry(String id) {
        if ("system.bundle".equals(id)) {
            id = this.getSystemBundleId();
        }
        return id == null ? null : (ModelEntry)this.getEntryTable().get(id);
    }

    public IPluginModelBase findModel(String id) {
        ModelEntry entry = this.findEntry(id);
        return entry == null ? null : entry.getModel();
    }

    public IPluginModelBase findModel(IProject project) {
        this.initializeTable(null);
        return this.fWorkspaceManager.getPluginModel(project);
    }

    public IPluginModelBase findModel(BundleDescription desc) {
        ModelEntry entry = desc != null ? this.findEntry(desc.getSymbolicName()) : null;
        return entry == null ? null : entry.getModel(desc);
    }

    public IPluginModelBase[] getActiveModels() {
        return this.getActiveModels(true);
    }

    public IPluginModelBase[] getActiveModels(boolean includeFragments) {
        int size = this.getEntryTable().size();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>(size);
        for (ModelEntry modelEntry : this.getEntryTable().values()) {
            IPluginModelBase[] models = modelEntry.getActiveModels();
            int i = 0;
            while (i < models.length) {
                if (models[i] instanceof IPluginModel || includeFragments) {
                    result.add(models[i]);
                }
                ++i;
            }
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModelBase[] getAllModels() {
        return this.getAllModels(true);
    }

    public IPluginModelBase[] getAllModels(boolean includeFragments) {
        int size = this.getEntryTable().size();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>(size);
        for (ModelEntry modelEntry : this.getEntryTable().values()) {
            IPluginModelBase[] models = modelEntry.hasWorkspaceModels() ? modelEntry.getWorkspaceModels() : modelEntry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                if (models[i] instanceof IPluginModel || includeFragments) {
                    result.add(models[i]);
                }
                ++i;
            }
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModelBase[] getExternalModels() {
        this.initializeTable(null);
        return this.fExternalManager.getAllModels();
    }

    public IPluginModelBase[] getWorkspaceModels() {
        this.initializeTable(null);
        return this.fWorkspaceManager.getPluginModels();
    }

    public ExternalModelManager getExternalModelManager() {
        this.initializeTable(null);
        return this.fExternalManager;
    }

    public PDEState getState() {
        this.initializeTable(null);
        return this.fState;
    }

    public String getSystemBundleId() {
        return this.getState().getSystemBundle();
    }

    protected void shutdown() {
        this.fWorkspaceManager.shutdown();
        this.fExternalManager.shutdown();
        if (this.fListeners != null) {
            this.fListeners.clear();
        }
        if (this.fStateListeners != null) {
            this.fStateListeners.clear();
        }
    }

    public void addExtensionDeltaListener(IExtensionDeltaListener listener) {
        this.fWorkspaceManager.addExtensionDeltaListener(listener);
    }

    public void removeExtensionDeltaListener(IExtensionDeltaListener listener) {
        this.fWorkspaceManager.removeExtensionDeltaListener(listener);
    }

    public void bundleRootChanged(IProject project) {
        this.fWorkspaceManager.initialize();
        this.fWorkspaceManager.removeModel(project);
        if (this.fWorkspaceManager.isInterestingProject(project)) {
            this.fWorkspaceManager.createModel(project, false);
            Object model = this.fWorkspaceManager.getModel(project);
            this.fWorkspaceManager.addChange(model, 4);
        }
        this.fWorkspaceManager.processModelChanges();
    }

    private class LocalModelEntry
    extends ModelEntry {
        public LocalModelEntry(String id) {
            super(id);
        }

        public void addModel(IPluginModelBase model) {
            if (model.getUnderlyingResource() != null) {
                this.fWorkspaceEntries.add(model);
            } else {
                this.fExternalEntries.add(model);
            }
        }

        public void removeModel(IPluginModelBase model) {
            if (model.getUnderlyingResource() != null) {
                this.fWorkspaceEntries.remove(model);
            } else {
                this.fExternalEntries.remove(model);
            }
        }
    }

    class UpdateClasspathsJob
    extends Job {
        private List<IJavaProject> fProjects;
        private List<IClasspathContainer> fContainers;

        public UpdateClasspathsJob() {
            super(PDECoreMessages.PluginModelManager_1);
            this.fProjects = new ArrayList<IJavaProject>();
            this.fContainers = new ArrayList<IClasspathContainer>();
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                boolean more = false;
                do {
                    IJavaProject[] projects = null;
                    IClasspathContainer[] containers = null;
                    List<IJavaProject> list = this.fProjects;
                    synchronized (list) {
                        projects = this.fProjects.toArray(new IJavaProject[this.fProjects.size()]);
                        containers = this.fContainers.toArray(new IClasspathContainer[this.fContainers.size()]);
                        this.fProjects.clear();
                        this.fContainers.clear();
                    }
                    JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])projects, (IClasspathContainer[])containers, (IProgressMonitor)monitor);
                    list = this.fProjects;
                    synchronized (list) {
                        more = !this.fProjects.isEmpty();
                    }
                } while (more);
            }
            catch (JavaModelException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(IJavaProject[] projects, IClasspathContainer[] containers) {
            List<IJavaProject> list = this.fProjects;
            synchronized (list) {
                int i = 0;
                while (i < containers.length) {
                    this.fProjects.add(projects[i]);
                    this.fContainers.add(containers[i]);
                    ++i;
                }
            }
        }
    }
}

