/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCacheTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingFile;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;

public final class SupportedContextActionsHelper {
    private SupportedContextActionsHelper() {
    }

    public static boolean canCommit(GitModelObject object) {
        return object instanceof GitModelWorkingFile || object instanceof GitModelCacheFile || object instanceof GitModelCacheTree || object instanceof GitModelCache;
    }

    public static boolean canUseMergeTool(GitModelObject object) {
        return object instanceof GitModelWorkingFile || object instanceof GitModelCacheFile;
    }

    public static boolean canStage(GitModelObject object) {
        return object instanceof GitModelWorkingFile || SupportedContextActionsHelper.getRootObject(object) instanceof GitModelWorkingTree;
    }

    public static boolean canAssumeUnchanged(GitModelObject object) {
        return SupportedContextActionsHelper.canStage(object) || object instanceof GitModelCacheFile || object instanceof GitModelCacheTree;
    }

    public static boolean canReset(GitModelObject object) {
        return SupportedContextActionsHelper.isOutGoingCommit(object) || SupportedContextActionsHelper.canCommit(object);
    }

    public static boolean canPush(GitModelObject object) {
        return SupportedContextActionsHelper.isOutGoingCommit(object);
    }

    public static boolean canMerge(GitModelObject object) {
        return SupportedContextActionsHelper.getRootObject(object) instanceof GitModelCommit;
    }

    private static GitModelObject getRootObject(GitModelObject object) {
        GitModelObject root = object.getParent();
        while (root != null && root instanceof GitModelTree) {
            root = root.getParent();
        }
        return root;
    }

    private static boolean isOutGoingCommit(GitModelObject object) {
        int direction = 4;
        if (SupportedContextActionsHelper.getRootObject(object) instanceof GitModelCommit) {
            direction = ((GitModelCommit)object).getKind() & 8;
        }
        return direction == 8;
    }
}

