/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.Search;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.ShowSearchAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ListDialog;

@Deprecated
class ShowSearchesAction
extends Action {
    public ShowSearchesAction() {
        super(SearchMessages.ShowOtherSearchesAction_label);
        this.setToolTipText(SearchMessages.ShowOtherSearchesAction_tooltip);
    }

    public void run() {
        this.run(false);
    }

    public void run(boolean showAll) {
        List<Object> result;
        String message;
        String title;
        Iterator iter = SearchManager.getDefault().getPreviousSearches().iterator();
        int cutOffSize = showAll ? 0 : 10;
        int size = SearchManager.getDefault().getPreviousSearches().size() - cutOffSize;
        Search selectedSearch = SearchManager.getDefault().getCurrentSearch();
        ShowSearchAction selectedAction = null;
        ArrayList<ShowSearchAction> input = new ArrayList<ShowSearchAction>(size);
        int i = 0;
        while (iter.hasNext()) {
            Search search = (Search)iter.next();
            if (i++ < cutOffSize) continue;
            ShowSearchAction action = new ShowSearchAction(search);
            input.add(action);
            if (selectedSearch != search) continue;
            selectedAction = action;
        }
        if (showAll) {
            title = SearchMessages.PreviousSearchesDialog_title;
            message = SearchMessages.PreviousSearchesDialog_message;
        } else {
            title = SearchMessages.OtherSearchesDialog_title;
            message = SearchMessages.OtherSearchesDialog_message;
        }
        SearchesLabelProvider labelProvider = new SearchesLabelProvider();
        ListDialog dlg = new ListDialog(SearchPlugin.getActiveWorkbenchShell());
        dlg.setInput(input);
        dlg.setTitle(title);
        dlg.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dlg.setLabelProvider((ILabelProvider)labelProvider);
        dlg.setMessage(message);
        if (selectedAction != null) {
            Object[] selected = new Object[]{selectedAction};
            dlg.setInitialSelections(selected);
        }
        if (dlg.open() == 0 && (result = Arrays.asList(dlg.getResult())) != null && result.size() == 1) {
            ((ShowSearchAction)((Object)result.get(0))).run();
        }
    }

    private static final class SearchesLabelProvider
    extends LabelProvider {
        private ArrayList<Image> fImages = new ArrayList();

        private SearchesLabelProvider() {
        }

        public String getText(Object element) {
            if (!(element instanceof ShowSearchAction)) {
                return "";
            }
            return ((ShowSearchAction)((Object)element)).getText();
        }

        public Image getImage(Object element) {
            if (!(element instanceof ShowSearchAction)) {
                return null;
            }
            ImageDescriptor imageDescriptor = ((ShowSearchAction)((Object)element)).getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image image = imageDescriptor.createImage();
            this.fImages.add(image);
            return image;
        }

        public void dispose() {
            Iterator<Image> iter = this.fImages.iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
            this.fImages = null;
        }
    }
}

