/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.RefactoringUtils;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteTagReferenceChange;

public class DeleteTagProcessor
extends DeleteProcessor {
    private List<Tag> tags;

    public DeleteTagProcessor(List<Tag> tags) {
        if (tags == null || tags.size() == 0) {
            throw new IllegalArgumentException("Tags must not be null or empty");
        }
        this.tags = tags;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        for (Tag tag : this.tags) {
            RefactoringStatus status = RefactoringUtils.validateTagInSync(tag);
            if (status.isOK()) continue;
            return status;
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            CompositeChange composite = new CompositeChange(Messages.DeleteTagProcessor_ChangeName);
            for (Tag t : this.tags) {
                this.collectUpdates(composite, t);
            }
            CompositeChange compositeChange = composite;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IQ7NamedElement> collectUpdates(CompositeChange composite, Tag tag) {
        ArrayList<IQ7NamedElement> refs = new ArrayList<IQ7NamedElement>();
        Tag tag2 = tag;
        synchronized (tag2) {
            for (Tag t : tag.getTags()) {
                refs.addAll(this.collectUpdates(composite, t));
            }
        }
        String taskName = tag.getPath().equals(tag.getValue()) ? NLS.bind((String)Messages.DeleteTagProcessor_TaskName, (Object[])new Object[]{tag.getValue()}) : NLS.bind((String)Messages.DeleteTagProcessor_TaskName_SubTag, (Object[])new Object[]{tag.getValue(), tag.getPath()});
        CompositeChange sub = new CompositeChange(taskName);
        composite.add((Change)sub);
        Iterator iterator = tag;
        synchronized (iterator) {
            refs.addAll((Collection<IQ7NamedElement>)tag.getRefs());
        }
        for (IQ7NamedElement e : refs) {
            sub.add((Change)new DeleteTagReferenceChange(e, tag));
        }
        return refs;
    }

    public String getIdentifier() {
        return "org.eclipse.rcptt.ui.refactoring.delete.deleteTagProcessor";
    }

    public String getProcessorName() {
        return Messages.DeleteTagProcessor_ProcessorName;
    }

    public boolean isApplicable() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public Object[] getElements() {
        return this.tags.toArray();
    }
}

