/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.nio.ByteBuffer;

public final class UResource {

    public static class ArraySink {
        public void put(int index, Value value) {
        }

        public ArraySink getOrCreateArraySink(int index, int size) {
            return null;
        }

        public TableSink getOrCreateTableSink(int index, int initialSize) {
            return null;
        }

        public void leave() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Key
    implements CharSequence,
    Cloneable,
    Comparable<Key> {
        private byte[] bytes;
        private int offset;
        private int length;
        private String s;

        public Key() {
        }

        private Key(byte[] keyBytes, int keyOffset, int keyLength) {
            this.bytes = keyBytes;
            this.offset = keyOffset;
            this.length = keyLength;
        }

        public void setBytes(byte[] keyBytes, int keyOffset) {
            this.bytes = keyBytes;
            this.offset = keyOffset;
            this.length = 0;
            while (keyBytes[keyOffset + this.length] != 0) {
                ++this.length;
            }
            this.s = null;
        }

        public void setToEmpty() {
            this.bytes = null;
            this.length = 0;
            this.offset = 0;
            this.s = null;
        }

        public Key clone() {
            try {
                return (Key)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public char charAt(int i) {
            assert (i >= 0 && i < this.length);
            return (char)this.bytes[this.offset + i];
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public Key subSequence(int start, int end) {
            assert (start >= 0 && start < this.length);
            assert (start <= end && end <= this.length);
            return new Key(this.bytes, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            if (this.s == null) {
                this.s = this.internalSubString(0, this.length);
            }
            return this.s;
        }

        private String internalSubString(int start, int end) {
            StringBuilder sb = new StringBuilder(end - start);
            int i = start;
            while (i < end) {
                sb.append((char)this.bytes[this.offset + i]);
                ++i;
            }
            return sb.toString();
        }

        public String substring(int start) {
            assert (start >= 0 && start < this.length);
            return this.internalSubString(start, this.length);
        }

        public String substring(int start, int end) {
            assert (start >= 0 && start < this.length);
            assert (start <= end && end <= this.length);
            return this.internalSubString(start, end);
        }

        private boolean regionMatches(byte[] otherBytes, int otherOffset, int n) {
            int i = 0;
            while (i < n) {
                if (this.bytes[this.offset + i] != otherBytes[otherOffset + i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean regionMatches(int start, CharSequence cs, int n) {
            int i = 0;
            while (i < n) {
                if (this.bytes[this.offset + start + i] != cs.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof Key) {
                Key otherKey = (Key)other;
                return this.length == otherKey.length && this.regionMatches(otherKey.bytes, otherKey.offset, this.length);
            }
            return false;
        }

        public boolean contentEquals(CharSequence cs) {
            if (cs == null) {
                return false;
            }
            return this == cs || cs.length() == this.length && this.regionMatches(0, cs, this.length);
        }

        public boolean startsWith(CharSequence cs) {
            int csLength = cs.length();
            return csLength <= this.length && this.regionMatches(0, cs, csLength);
        }

        public boolean endsWith(CharSequence cs) {
            int csLength = cs.length();
            return csLength <= this.length && this.regionMatches(this.length - csLength, cs, csLength);
        }

        public boolean regionMatches(int start, CharSequence cs) {
            int csLength = cs.length();
            return csLength == this.length - start && this.regionMatches(start, cs, csLength);
        }

        public int hashCode() {
            if (this.length == 0) {
                return 0;
            }
            int h = this.bytes[this.offset];
            int i = 1;
            while (i < this.length) {
                h = 37 * h + this.bytes[this.offset];
                ++i;
            }
            return h;
        }

        @Override
        public int compareTo(Key other) {
            return this.compareTo((CharSequence)other);
        }

        @Override
        public int compareTo(CharSequence cs) {
            int csLength = cs.length();
            int minLength = this.length <= csLength ? this.length : csLength;
            int i = 0;
            while (i < minLength) {
                int diff = this.charAt(i) - cs.charAt(i);
                if (diff != 0) {
                    return diff;
                }
                ++i;
            }
            return this.length - csLength;
        }
    }

    public static class TableSink {
        public void put(Key key, Value value) {
        }

        public void putNoFallback(Key key) {
        }

        public ArraySink getOrCreateArraySink(Key key, int size) {
            return null;
        }

        public TableSink getOrCreateTableSink(Key key, int initialSize) {
            return null;
        }

        public void leave() {
        }
    }

    public static abstract class Value {
        protected Value() {
        }

        public abstract int getType();

        public abstract String getString();

        public abstract String getAliasString();

        public abstract int getInt();

        public abstract int getUInt();

        public abstract int[] getIntVector();

        public abstract ByteBuffer getBinary();

        public String toString() {
            switch (this.getType()) {
                case 0: {
                    return this.getString();
                }
                case 7: {
                    return Integer.toString(this.getInt());
                }
                case 14: {
                    int[] iv = this.getIntVector();
                    StringBuilder sb = new StringBuilder("[");
                    sb.append(iv.length).append("]{");
                    if (iv.length != 0) {
                        sb.append(iv[0]);
                        int i = 1;
                        while (i < iv.length) {
                            sb.append(", ").append(iv[i]);
                            ++i;
                        }
                    }
                    return sb.append('}').toString();
                }
                case 1: {
                    return "(binary blob)";
                }
                case 8: {
                    return "(array)";
                }
                case 2: {
                    return "(table)";
                }
            }
            return "???";
        }
    }
}

