/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;

public class RefreshChangeListener
implements ISubscriberChangeListener,
RefreshParticipantJob.IChangeDescription {
    private List changes = new ArrayList();
    private SubscriberSyncInfoCollector collector;
    private IResource[] resources;

    public RefreshChangeListener(IResource[] resources, SubscriberSyncInfoCollector collector) {
        this.resources = resources;
        this.collector = collector;
    }

    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            ISubscriberChangeEvent delta = deltas[i];
            if (delta.getFlags() == 1) {
                this.changes.add(delta);
            }
            ++i;
        }
    }

    public SyncInfo[] getChanges() {
        ArrayList<SyncInfo> changedSyncInfos = new ArrayList<SyncInfo>();
        SyncInfoTree set = this.collector.getSyncInfoSet();
        for (ISubscriberChangeEvent delta : this.changes) {
            SyncInfo info = set.getSyncInfo(delta.getResource());
            if (info == null || !this.interestingChange(info)) continue;
            changedSyncInfos.add(info);
        }
        return changedSyncInfos.toArray(new SyncInfo[changedSyncInfos.size()]);
    }

    private boolean interestingChange(SyncInfo info) {
        int kind = info.getKind();
        if (this.isThreeWay()) {
            int direction = SyncInfo.getDirection((int)kind);
            return direction == 8 || direction == 12;
        }
        return SyncInfo.getChange((int)kind) != 0;
    }

    private boolean isThreeWay() {
        return this.collector.getSubscriber().getResourceComparator().isThreeWay();
    }

    @Override
    public int getChangeCount() {
        return this.getChanges().length;
    }

    public IResource[] getResources() {
        return this.resources;
    }
}

