/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class CreateApiFilterOperation
extends UIJob {
    private IMarker[] fMarkers = null;
    private boolean fAddingComment = false;

    public CreateApiFilterOperation(IMarker[] markers, boolean addingcomments) {
        super(MarkerMessages.CreateApiFilterOperation_0);
        this.fMarkers = markers;
        this.fAddingComment = addingcomments;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            InputDialog dialog;
            HashMap map = new HashMap(this.fMarkers.length);
            IResource resource = null;
            IProject project = null;
            String comment = null;
            HashSet<IProject> projects = new HashSet<IProject>();
            if (this.fAddingComment && (dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MarkerMessages.CreateApiFilterOperation_add_filter_comment, MarkerMessages.CreateApiFilterOperation_filter_comment, null, null)).open() == 0 && (comment = dialog.getValue()) != null && comment.length() < 1) {
                comment = null;
            }
            IMarker marker = null;
            IApiProblem problem = null;
            HashSet<IApiProblemFilter> filters = null;
            IApiComponent component2 = null;
            int i = 0;
            while (i < this.fMarkers.length) {
                marker = this.fMarkers[i];
                resource = marker.getResource();
                project = resource.getProject();
                if (project == null) {
                    return Status.CANCEL_STATUS;
                }
                component2 = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline().getApiComponent(project);
                if (component2 == null) {
                    return Status.CANCEL_STATUS;
                }
                projects.add(project);
                filters = (HashSet)map.get(component2);
                if (filters == null) {
                    filters = new HashSet<IApiProblemFilter>();
                    map.put(component2, filters);
                }
                String typeNameFromMarker = Util.getTypeNameFromMarker((IMarker)marker);
                problem = ApiProblemFactory.newApiProblem((String)resource.getProjectRelativePath().toPortableString(), (String)typeNameFromMarker, (String[])this.getMessageArgumentsFromMarker(marker), null, null, (int)marker.getAttribute("lineNumber", -1), (int)marker.getAttribute("charStart", -1), (int)marker.getAttribute("charEnd", -1), (int)marker.getAttribute("problemid", 0));
                filters.add(ApiProblemFactory.newProblemFilter((String)component2.getSymbolicName(), (IApiProblem)problem, (String)comment));
                Util.touchCorrespondingResource((IProject)project, (IResource)resource, (String)typeNameFromMarker);
                ++i;
            }
            for (IApiComponent component2 : map.keySet()) {
                IApiFilterStore store = component2.getFilterStore();
                filters = (HashSet<IApiProblemFilter>)map.get(component2);
                if (filters == null) continue;
                store.addFilters(filters.toArray(new IApiProblemFilter[filters.size()]));
            }
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                Util.getBuildJob((IProject[])projects.toArray(new IProject[projects.size()]), (int)10).schedule();
            }
            return Status.OK_STATUS;
        }
        catch (CoreException ce) {
            ApiUIPlugin.log(ce);
            return Status.CANCEL_STATUS;
        }
    }

    private String[] getMessageArgumentsFromMarker(IMarker marker) {
        ArrayList args = new ArrayList();
        String arguments = marker.getAttribute("messagearguments", null);
        if (arguments != null) {
            return arguments.split("#");
        }
        return args.toArray(new String[args.size()]);
    }
}

