/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.sourcelookup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupPanel;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SourceLookupDialog
extends TitleAreaDialog {
    private SourceLookupPanel fPanel;
    private ISourceLookupDirector fDirector;

    public SourceLookupDialog(Shell shell, ISourceLookupDirector director) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDirector = director;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(SourceLookupUIMessages.manageSourceDialog_description);
        this.setTitleImage(DebugPluginImages.getImage("IMG_EDIT_SRC_LOCATION"));
        this.setMessage(SourceLookupUIMessages.SourceLookupDialog_add_edit_remove);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.fPanel = new SourceLookupPanel();
        this.fPanel.createControl(composite);
        this.fPanel.initializeFrom(this.fDirector);
        Dialog.applyDialogFont((Control)composite);
        ILaunchConfiguration config = this.fDirector.getLaunchConfiguration();
        if (config != null && config.isReadOnly()) {
            this.setErrorMessage(String.valueOf(SourceLookupUIMessages.SourceLookupDialog_0) + config.getName() + SourceLookupUIMessages.SourceLookupDialog_1);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.debug.ui.edit_source_lookup_path_dialog");
        return composite;
    }

    protected void okPressed() {
        ILaunchConfiguration config = this.fDirector.getLaunchConfiguration();
        ILaunchConfigurationWorkingCopy copy = null;
        if (config != null) {
            try {
                copy = config.getWorkingCopy();
                this.fPanel.performApply(copy);
                copy.doSave();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SourceLookupUIMessages.manageSourceDialog_title);
    }

    public boolean close() {
        this.fPanel.dispose();
        return super.close();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return section;
    }
}

